/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.core.auth.jwt.parts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import eu.securibox.cloudagents.core.auth.jwt.exceptions.JWTDecodeException;
import eu.securibox.cloudagents.core.auth.jwt.parts.Header;
import java.io.IOException;
import java.util.Map;

public class HeaderDeserializer
extends StdDeserializer<Header> {
    private static final long serialVersionUID = 2204771885050775887L;

    public HeaderDeserializer() {
        this(null);
    }

    private HeaderDeserializer(Class<?> vc) {
        super(vc);
    }

    public Header deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Map tree = (Map)p.getCodec().readValue(p, (TypeReference)new TypeReference<Map<String, JsonNode>>(){});
        if (tree == null) {
            throw new JWTDecodeException("Parsing the Header's JSON resulted on a Null map");
        }
        String algorithm = this.getString(tree, "alg");
        String type = this.getString(tree, "typ");
        String contentType = this.getString(tree, "cty");
        String keyId = this.getString(tree, "kid");
        return new Header(algorithm, type, contentType, keyId, tree);
    }

    String getString(Map<String, JsonNode> tree, String claimName) {
        JsonNode node = tree.get(claimName);
        if (node == null || node.isNull()) {
            return null;
        }
        return node.asText(null);
    }
}

