/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.core.auth.jwt.parts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.securibox.cloudagents.core.auth.jwt.exceptions.JWTDecodeException;
import eu.securibox.cloudagents.core.auth.jwt.parts.Claim;
import eu.securibox.cloudagents.core.auth.jwt.parts.NullClaim;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

public class JsonNodeClaim
implements Claim {
    private final JsonNode data;

    private JsonNodeClaim(JsonNode node) {
        this.data = node;
    }

    @Override
    public Boolean asBoolean() {
        return !this.data.isBoolean() ? null : Boolean.valueOf(this.data.asBoolean());
    }

    @Override
    public Integer asInt() {
        return !this.data.isNumber() ? null : Integer.valueOf(this.data.asInt());
    }

    @Override
    public Long asLong() {
        return !this.data.isNumber() ? null : Long.valueOf(this.data.asLong());
    }

    @Override
    public Double asDouble() {
        return !this.data.isNumber() ? null : Double.valueOf(this.data.asDouble());
    }

    @Override
    public String asString() {
        return !this.data.isTextual() ? null : this.data.asText();
    }

    @Override
    public Date asDate() {
        if (!this.data.canConvertToLong()) {
            return null;
        }
        long seconds = this.data.asLong();
        return new Date(seconds * 1000L);
    }

    @Override
    public <T> T[] asArray(Class<T> tClazz) throws JWTDecodeException {
        if (!this.data.isArray()) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        Object[] arr = (Object[])Array.newInstance(tClazz, this.data.size());
        for (int i = 0; i < this.data.size(); ++i) {
            try {
                arr[i] = mapper.treeToValue((TreeNode)this.data.get(i), tClazz);
                continue;
            }
            catch (JsonProcessingException e) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to " + tClazz.getSimpleName(), e);
            }
        }
        return arr;
    }

    @Override
    public <T> List<T> asList(Class<T> tClazz) throws JWTDecodeException {
        if (!this.data.isArray()) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < this.data.size(); ++i) {
            try {
                list.add(mapper.treeToValue((TreeNode)this.data.get(i), tClazz));
                continue;
            }
            catch (JsonProcessingException e) {
                throw new JWTDecodeException("Couldn't map the Claim's array contents to " + tClazz.getSimpleName(), e);
            }
        }
        return list;
    }

    @Override
    public Map<String, Object> asMap() throws JWTDecodeException {
        if (!this.data.isObject()) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper();
        try {
            TypeReference<Map<String, Object>> mapType = new TypeReference<Map<String, Object>>(){};
            return (Map)mapper.treeAsTokens((TreeNode)this.data).readValueAs((TypeReference)mapType);
        }
        catch (IOException e) {
            throw new JWTDecodeException("Couldn't map the Claim value to Map", e);
        }
    }

    @Override
    public <T> T as(Class<T> tClazz) throws JWTDecodeException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (T)mapper.treeAsTokens((TreeNode)this.data).readValueAs(tClazz);
        }
        catch (IOException e) {
            throw new JWTDecodeException("Couldn't map the Claim value to " + tClazz.getSimpleName(), e);
        }
    }

    @Override
    public boolean isNull() {
        return false;
    }

    static Claim extractClaim(String claimName, Map<String, JsonNode> tree) {
        JsonNode node = tree.get(claimName);
        return JsonNodeClaim.claimFromNode(node);
    }

    static Claim claimFromNode(JsonNode node) {
        if (node == null || node.isNull() || node.isMissingNode()) {
            return new NullClaim();
        }
        return new JsonNodeClaim(node);
    }
}

