/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.core.auth.jwt.parts;

import com.fasterxml.jackson.databind.JsonNode;
import eu.securibox.cloudagents.core.auth.jwt.parts.Claim;
import eu.securibox.cloudagents.core.auth.jwt.parts.JsonNodeClaim;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Payload {
    private final String issuer;
    private final String subject;
    private final List<String> audience;
    private final Date expiresAt;
    private final Date notBefore;
    private final Date issuedAt;
    private final String jwtId;
    private final Map<String, JsonNode> tree;

    Payload(String issuer, String subject, List<String> audience, Date expiresAt, Date notBefore, Date issuedAt, String jwtId, Map<String, JsonNode> tree) {
        this.issuer = issuer;
        this.subject = subject;
        this.audience = audience;
        this.expiresAt = expiresAt;
        this.notBefore = notBefore;
        this.issuedAt = issuedAt;
        this.jwtId = jwtId;
        this.tree = Collections.unmodifiableMap(tree == null ? new HashMap() : tree);
    }

    Map<String, JsonNode> getTree() {
        return this.tree;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public Date getExpiresAt() {
        return this.expiresAt;
    }

    public Date getNotBefore() {
        return this.notBefore;
    }

    public Date getIssuedAt() {
        return this.issuedAt;
    }

    public String getId() {
        return this.jwtId;
    }

    public Claim getClaim(String name) {
        return JsonNodeClaim.extractClaim(name, this.tree);
    }

    public Map<String, Claim> getClaims() {
        HashMap<String, Claim> claims = new HashMap<String, Claim>();
        for (String name : this.tree.keySet()) {
            claims.put(name, JsonNodeClaim.extractClaim(name, this.tree));
        }
        return Collections.unmodifiableMap(claims);
    }
}

