/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.core.configuration;

import eu.securibox.cloudagents.core.SecurityConfiguration;
import eu.securibox.cloudagents.core.TrustStore;
import eu.securibox.cloudagents.core.Utils;
import eu.securibox.cloudagents.core.auth.jwt.JWTCreator;
import eu.securibox.cloudagents.core.auth.jwt.algorithms.Algorithm;
import eu.securibox.cloudagents.core.auth.jwt.exceptions.JWTCreationException;
import eu.securibox.cloudagents.core.exceptions.SecurityConfigurationException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.apache.commons.io.FileUtils;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.fluent.Executor;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.ssl.SSLContextBuilder;

public class SSLConfiguration
implements SecurityConfiguration {
    private Executor executor;
    private boolean preemptiveAuth = false;

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    private SSLConfiguration() {
    }

    public static SecurityConfiguration Basic(TrustStore store, String username, String password) throws SecurityConfigurationException {
        if (Utils.nullOrEmpty(username)) {
            throw new IllegalArgumentException("No username was provided for basic authentication.");
        }
        if (Utils.nullOrEmpty(password)) {
            throw new IllegalArgumentException("No password was provided for basic authentication.");
        }
        try {
            SSLConfiguration cfg = new SSLConfiguration();
            SSLContextBuilder contextBuilder = SSLConfiguration.getSSLContextBuilder(store);
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(contextBuilder.build(), new String[]{"TLSv1.2", "TLSv1.3"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            HttpClientBuilder clientBuilder = HttpClients.custom();
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
            credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(username, password));
            clientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            clientBuilder.setConnectionManagerShared(true);
            CloseableHttpClient httpClient = clientBuilder.build();
            cfg.executor = Executor.newInstance((HttpClient)httpClient);
            cfg.preemptiveAuth = true;
            return cfg;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (KeyStoreException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (CertificateException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (IOException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (KeyManagementException e) {
            throw new SecurityConfigurationException(e);
        }
    }

    public static SecurityConfiguration ClientCertificate(TrustStore store, String keyStoreFilename, String keyStorePassword, String keyStorePrivateKeyPassword) throws SecurityConfigurationException {
        if (Utils.nullOrEmpty(keyStoreFilename)) {
            throw new IllegalArgumentException("No keyStore filename was provided for client certificate authentication.");
        }
        if (Utils.nullOrEmpty(keyStorePassword)) {
            keyStorePassword = "";
        }
        if (Utils.nullOrEmpty(keyStorePrivateKeyPassword)) {
            keyStorePrivateKeyPassword = "";
        }
        try {
            SSLConfiguration cfg = new SSLConfiguration();
            SSLContextBuilder contextBuilder = SSLConfiguration.getSSLContextBuilder(store);
            contextBuilder.loadKeyMaterial(new File(keyStoreFilename), keyStorePassword.toCharArray(), keyStorePrivateKeyPassword.toCharArray());
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(contextBuilder.build(), new String[]{"TLSv1.2", "TLSv1.3"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            HttpClientBuilder clientBuilder = HttpClients.custom();
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            clientBuilder.setConnectionManagerShared(true);
            CloseableHttpClient httpClient = clientBuilder.build();
            cfg.executor = Executor.newInstance((HttpClient)httpClient);
            return cfg;
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (KeyStoreException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (CertificateException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (IOException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (KeyManagementException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (UnrecoverableKeyException e) {
            throw new SecurityConfigurationException(e);
        }
    }

    public static SecurityConfiguration JWT(TrustStore store, String publicKeyFilePath, String privateKeyFilePath, String privateKeyPassword, String customerUserId) throws Exception {
        return SSLConfiguration.JWT(store, publicKeyFilePath, privateKeyFilePath, privateKeyPassword, customerUserId, null);
    }

    public static SecurityConfiguration JWT(TrustStore store, String publicKeyFilePath, String privateKeyFilePath, String privateKeyPassword, String customerUserId, String audience) throws Exception {
        try {
            if (Utils.nullOrEmpty(audience)) {
                audience = "https://sca-multitenant.securibox.eu";
            }
            SSLConfiguration cfg = new SSLConfiguration();
            SSLContextBuilder contextBuilder = SSLConfiguration.getSSLContextBuilder(store);
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(contextBuilder.build(), new String[]{"TLSv1.2", "TLSv1.3"}, null, SSLConnectionSocketFactory.getDefaultHostnameVerifier());
            HttpClientBuilder clientBuilder = HttpClients.custom();
            RSAPrivateKey privateKey = SSLConfiguration.loadRSAPrivateKeyFromFile(privateKeyFilePath, privateKeyPassword);
            RSAPublicKey publicKey = SSLConfiguration.loadRSAPublicKeyFromFile(publicKeyFilePath);
            Calendar calendar = Calendar.getInstance();
            long t = calendar.getTimeInMillis();
            Date date = new Date(t);
            Date expiresAt = new Date(t + 3600000L);
            Algorithm JwtAlgorithm = Algorithm.RSA256(publicKey, privateKey);
            String token = JWTCreator.init().withIssuer("SCA API SDK").withIssuedAt(date).withExpiresAt(expiresAt).withAudience(audience).withClaim("uid", customerUserId).sign(JwtAlgorithm);
            BasicHeader jwtHeader = new BasicHeader("Authorization", "Bearer " + token);
            ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
            headers.add(jwtHeader);
            clientBuilder.setDefaultHeaders(headers);
            clientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf);
            clientBuilder.setConnectionManagerShared(true);
            CloseableHttpClient httpClient = clientBuilder.build();
            cfg.executor = Executor.newInstance((HttpClient)httpClient);
            cfg.preemptiveAuth = true;
            return cfg;
        }
        catch (JWTCreationException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (KeyStoreException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (CertificateException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (IOException e) {
            throw new SecurityConfigurationException(e);
        }
        catch (KeyManagementException e) {
            throw new SecurityConfigurationException(e);
        }
    }

    private static SSLContextBuilder getSSLContextBuilder(TrustStore store) throws NoSuchAlgorithmException, KeyStoreException, CertificateException, IOException {
        SSLContextBuilder contextBuilder = new SSLContextBuilder();
        if (store != null) {
            String fileName = store.getFilename();
            String password = store.getPassword();
            if (Utils.nullOrEmpty(password)) {
                password = "";
            }
            contextBuilder.loadTrustMaterial(new File(fileName), password.toCharArray());
        }
        return contextBuilder;
    }

    @Override
    public boolean userPreemptiveAuth() {
        return this.preemptiveAuth;
    }

    public static RSAPrivateKey loadRSAPrivateKeyFromFile(String filePath, String privateKeyPassword) throws Exception {
        String privateKeyPEM = FileUtils.readFileToString((File)new File(filePath), (Charset)StandardCharsets.UTF_8);
        privateKeyPEM = privateKeyPEM.replace("-----BEGIN PRIVATE KEY-----", "").replace("-----END PRIVATE KEY-----", "").replace("-----BEGIN ENCRYPTED PRIVATE KEY-----", "").replace("-----END ENCRYPTED PRIVATE KEY-----", "").replace("-----BEGIN RSA PRIVATE KEY-----", "").replace("-----END RSA PRIVATE KEY-----", "").replaceAll("\\s", "");
        byte[] privateKeyDER = Base64.getDecoder().decode(privateKeyPEM);
        PKCS8EncodedKeySpec privSpec = null;
        if (privateKeyPassword != null && !privateKeyPassword.isEmpty()) {
            EncryptedPrivateKeyInfo ePKInfo = new EncryptedPrivateKeyInfo(privateKeyDER);
            Cipher cipher = Cipher.getInstance(ePKInfo.getAlgName());
            PBEKeySpec pbeKeySpec = new PBEKeySpec(privateKeyPassword.toCharArray());
            SecretKeyFactory skFac = SecretKeyFactory.getInstance(ePKInfo.getAlgName());
            SecretKey pbeKey = skFac.generateSecret(pbeKeySpec);
            AlgorithmParameters algParams = ePKInfo.getAlgParameters();
            cipher.init(2, (Key)pbeKey, algParams);
            privSpec = ePKInfo.getKeySpec(cipher);
        } else {
            privSpec = new PKCS8EncodedKeySpec(privateKeyDER);
        }
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPrivateKey privateKey = (RSAPrivateKey)keyFactory.generatePrivate(privSpec);
        return privateKey;
    }

    public static RSAPublicKey loadRSAPublicKeyFromFile(String filePath) throws Exception {
        String publicKeyPEM = FileUtils.readFileToString((File)new File(filePath), (Charset)StandardCharsets.UTF_8);
        publicKeyPEM = publicKeyPEM.replace("-----BEGIN PUBLIC KEY-----", "").replace("-----END PUBLIC KEY-----", "").replaceAll("\\s", "");
        byte[] publicKeyDER = Base64.getDecoder().decode(publicKeyPEM);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKey publicKey = (RSAPublicKey)keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyDER));
        return publicKey;
    }
}

