/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.core.http;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import eu.securibox.cloudagents.core.ApiError;
import eu.securibox.cloudagents.core.Client;
import eu.securibox.cloudagents.core.Response;
import eu.securibox.cloudagents.core.SecurityConfiguration;
import eu.securibox.cloudagents.core.Utils;
import eu.securibox.cloudagents.core.configuration.FileConfiguration;
import eu.securibox.cloudagents.core.configuration.SSLConfiguration;
import eu.securibox.cloudagents.core.exceptions.ClientException;
import eu.securibox.cloudagents.core.exceptions.ResponseException;
import eu.securibox.cloudagents.core.exceptions.SecurityConfigurationException;
import eu.securibox.cloudagents.core.http.HttpApiError;
import eu.securibox.cloudagents.core.http.HttpMethod;
import eu.securibox.cloudagents.core.http.HttpResponse;
import eu.securibox.cloudagents.core.http.HttpTrustStore;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import org.apache.http.HttpHost;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.entity.ContentType;

public class HttpClient
implements Client {
    protected Executor executor;
    protected String baseUrl;
    protected ObjectMapper mapper;

    public static Client FromConfigFile(String configurationFile) throws SecurityConfigurationException {
        if (Utils.nullOrEmpty(configurationFile)) {
            throw new IllegalArgumentException("No configurationFile was provided.");
        }
        Properties p = FileConfiguration.getProperties(configurationFile);
        HttpTrustStore store = null;
        SecurityConfiguration cfg = null;
        String trustFile = p.getProperty("truststore.filename");
        if (!Utils.nullOrEmpty(trustFile)) {
            store = new HttpTrustStore(trustFile, p.getProperty("truststore.password"));
        }
        String basicUser = p.getProperty("client.username");
        String keyStoreFile = p.getProperty("keystore.filename");
        if (!Utils.nullOrEmpty(basicUser)) {
            cfg = SSLConfiguration.Basic(store, basicUser, p.getProperty("client.password"));
        } else if (!Utils.nullOrEmpty(keyStoreFile)) {
            cfg = SSLConfiguration.ClientCertificate(store, keyStoreFile, p.getProperty("keystore.password"), p.getProperty("keystore.privatekeypassword"));
        } else {
            throw new IllegalArgumentException("The configuration file is not correctly filled. Either 'client.username' or 'keystore.filename' must be provided.");
        }
        return new HttpClient(p.getProperty("client.baseUrl"), cfg);
    }

    public HttpClient(String baseUrl, SecurityConfiguration configuration) {
        if (Utils.nullOrEmpty(baseUrl)) {
            throw new IllegalArgumentException("No base Url was provided.");
        }
        if (!baseUrl.contains("https://")) {
            throw new IllegalArgumentException("The base Url must start with 'https://'. Other protocols are not supported.");
        }
        this.baseUrl = baseUrl.substring(baseUrl.length() - 1).equals("/") ? baseUrl : baseUrl + "/";
        this.executor = configuration.getExecutor();
        if (configuration.userPreemptiveAuth()) {
            String hostString = this.baseUrl.substring(0, this.baseUrl.indexOf("/", this.baseUrl.indexOf("://") + 3));
            HttpHost host = HttpHost.create((String)hostString);
            this.executor.authPreemptive(host);
        }
        this.mapper = new ObjectMapper();
        this.mapper.configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
        this.mapper.registerModule((Module)new ParameterNamesModule());
        this.mapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        this.mapper.setDateFormat((DateFormat)formatter);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public Response get(String path) throws ClientException, ResponseException {
        return this.execute(HttpMethod.GET, path, null);
    }

    @Override
    public Response post(String path) throws ClientException, ResponseException {
        return this.execute(HttpMethod.POST, path, null);
    }

    @Override
    public Response post(String path, String payload) throws ClientException, ResponseException {
        return this.execute(HttpMethod.POST, path, payload);
    }

    @Override
    public Response put(String path) throws ClientException, ResponseException {
        return this.execute(HttpMethod.PUT, path, null);
    }

    @Override
    public Response put(String path, String payload) throws ClientException, ResponseException {
        return this.execute(HttpMethod.PUT, path, payload);
    }

    @Override
    public Response delete(String path) throws ClientException, ResponseException {
        return this.execute(HttpMethod.DELETE, path, null);
    }

    private Response execute(HttpMethod method, String path, String payload) throws ResponseException, ClientException {
        org.apache.http.client.fluent.Response resp = null;
        try {
            switch (method) {
                case GET: {
                    resp = this.executor.execute(Request.Get((String)(this.baseUrl + Utils.clearPath(path))));
                    break;
                }
                case POST: {
                    Request request = Request.Post((String)(this.baseUrl + Utils.clearPath(path)));
                    if (payload != null) {
                        request.bodyString(payload, ContentType.APPLICATION_JSON);
                    }
                    resp = this.executor.execute(request);
                    break;
                }
                case PUT: {
                    Request req = Request.Put((String)(this.baseUrl + Utils.clearPath(path)));
                    if (payload != null) {
                        req.bodyString(payload, ContentType.APPLICATION_JSON);
                    }
                    resp = this.executor.execute(req);
                    break;
                }
                case DELETE: {
                    resp = this.executor.execute(Request.Delete((String)(this.baseUrl + Utils.clearPath(path))));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The HttpMethod " + (Object)((Object)method) + " is not supported");
                }
            }
            HttpResponse response = new HttpResponse(resp);
            int status = response.getStatusCode();
            if (status < 200 || status > 299) {
                ApiError error = null;
                try {
                    error = this.deserialize(response.getBody(), new TypeReference<HttpApiError>(){});
                }
                catch (ClientException e) {
                    throw new ResponseException(response);
                }
                throw new ResponseException(response, error);
            }
            return response;
        }
        catch (ClientProtocolException e) {
            throw new ClientException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public String serialize(Object obj) throws ClientException {
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (JsonGenerationException e) {
            throw new ClientException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new ClientException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public <T> T deserialize(String s, TypeReference<T> type) throws ClientException {
        try {
            Object out = this.mapper.readValue(s, type);
            return (T)out;
        }
        catch (JsonParseException e) {
            throw new ClientException((Exception)((Object)e));
        }
        catch (JsonMappingException e) {
            throw new ClientException((Exception)((Object)e));
        }
        catch (IOException e) {
            throw new ClientException(e);
        }
    }

    @Override
    public <T> void addSerializer(Class<? extends T> type, JsonSerializer<T> ser) {
        SimpleModule module = new SimpleModule();
        module.addSerializer(type, ser);
        this.mapper.registerModule((Module)module);
    }
}

