/*
 * Decompiled with CFR 0.152.
 */
package eu.securibox.cloudagents.core.http;

import eu.securibox.cloudagents.core.Utils;
import eu.securibox.cloudagents.core.types.CountryCode;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class UriParameters
extends HashMap<String, String> {
    private static final long serialVersionUID = 5698539679634758818L;

    public String getParameterString() throws UnsupportedEncodingException {
        if (this.size() == 0) {
            return "";
        }
        ArrayList<String> params = new ArrayList<String>();
        for (Map.Entry entry : this.entrySet()) {
            String key = (String)entry.getKey();
            String value = URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8.toString());
            params.add(key + "=" + value);
        }
        return String.join((CharSequence)"&", params);
    }

    @Override
    public void put(String key, int value) {
        if (value > 0) {
            super.put(key, Integer.toString(value));
        }
    }

    @Override
    public String put(String key, String value) {
        if (!Utils.nullOrEmpty(value)) {
            return super.put(key, value);
        }
        return "";
    }

    @Override
    public void put(String key, Date value) {
        if (value != null) {
            super.put(key, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'0000Z'").format(value));
        }
    }

    @Override
    public void put(String key, boolean value) {
        if (value) {
            super.put(key, "true");
        } else {
            super.put(key, "false");
        }
    }

    @Override
    public void put(String key, CountryCode countryCode) {
        if (countryCode != null) {
            this.put(key, countryCode.getCode());
        }
    }
}

