/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.anim.values;

import org.apache.batik.anim.values.AnimatableValue;
import org.apache.batik.dom.anim.AnimationTarget;

public class AnimatableIntegerValue
extends AnimatableValue {
    protected int value;

    protected AnimatableIntegerValue(AnimationTarget target) {
        super(target);
    }

    public AnimatableIntegerValue(AnimationTarget target, int v) {
        super(target);
        this.value = v;
    }

    public AnimatableValue interpolate(AnimatableValue result2, AnimatableValue to2, float interpolation, AnimatableValue accumulation, int multiplier) {
        AnimatableIntegerValue res = result2 == null ? new AnimatableIntegerValue(this.target) : (AnimatableIntegerValue)result2;
        int v = this.value;
        if (to2 != null) {
            AnimatableIntegerValue toInteger = (AnimatableIntegerValue)to2;
            v = (int)((float)v + ((float)this.value + interpolation * (float)(toInteger.getValue() - this.value)));
        }
        if (accumulation != null) {
            AnimatableIntegerValue accInteger = (AnimatableIntegerValue)accumulation;
            v += multiplier * accInteger.getValue();
        }
        if (res.value != v) {
            res.value = v;
            res.hasChanged = true;
        }
        return res;
    }

    public int getValue() {
        return this.value;
    }

    public boolean canPace() {
        return true;
    }

    public float distanceTo(AnimatableValue other) {
        AnimatableIntegerValue o = (AnimatableIntegerValue)other;
        return Math.abs(this.value - o.value);
    }

    public AnimatableValue getZeroValue() {
        return new AnimatableIntegerValue(this.target, 0);
    }

    public String getCssText() {
        return Integer.toString(this.value);
    }
}

