/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.util;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class PreferenceManager {
    protected Properties internal = null;
    protected Map defaults = null;
    protected String prefFileName = null;
    protected String fullName = null;
    protected static final String USER_HOME = PreferenceManager.getSystemProperty("user.home");
    protected static final String USER_DIR = PreferenceManager.getSystemProperty("user.dir");
    protected static final String FILE_SEP = PreferenceManager.getSystemProperty("file.separator");
    private static String PREF_DIR = null;

    protected static String getSystemProperty(String prop) {
        try {
            return System.getProperty(prop);
        }
        catch (AccessControlException e) {
            return "";
        }
    }

    public PreferenceManager(String prefFileName) {
        this(prefFileName, null);
    }

    public PreferenceManager(String prefFileName, Map defaults) {
        this.prefFileName = prefFileName;
        this.defaults = defaults;
        this.internal = new Properties();
    }

    public static void setPreferenceDirectory(String dir) {
        PREF_DIR = dir;
    }

    public static String getPreferenceDirectory() {
        return PREF_DIR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws IOException {
        FileInputStream fis = null;
        if (this.fullName != null) {
            try {
                fis = new FileInputStream(this.fullName);
            }
            catch (IOException e1) {
                this.fullName = null;
            }
        }
        if (this.fullName == null) {
            if (PREF_DIR != null) {
                try {
                    this.fullName = PREF_DIR + FILE_SEP + this.prefFileName;
                    fis = new FileInputStream(this.fullName);
                }
                catch (IOException e2) {
                    this.fullName = null;
                }
            }
            if (this.fullName == null) {
                try {
                    this.fullName = USER_HOME + FILE_SEP + this.prefFileName;
                    fis = new FileInputStream(this.fullName);
                }
                catch (IOException e3) {
                    try {
                        this.fullName = USER_DIR + FILE_SEP + this.prefFileName;
                        fis = new FileInputStream(this.fullName);
                    }
                    catch (IOException e4) {
                        this.fullName = null;
                    }
                }
            }
        }
        if (this.fullName != null) {
            try {
                this.internal.load(fis);
            }
            finally {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        FileOutputStream fos = null;
        if (this.fullName != null) {
            try {
                fos = new FileOutputStream(this.fullName);
            }
            catch (IOException e1) {
                this.fullName = null;
            }
        }
        if (this.fullName == null) {
            if (PREF_DIR != null) {
                try {
                    this.fullName = PREF_DIR + FILE_SEP + this.prefFileName;
                    fos = new FileOutputStream(this.fullName);
                }
                catch (IOException e2) {
                    this.fullName = null;
                }
            }
            if (this.fullName == null) {
                try {
                    this.fullName = USER_HOME + FILE_SEP + this.prefFileName;
                    fos = new FileOutputStream(this.fullName);
                }
                catch (IOException e3) {
                    this.fullName = null;
                    throw e3;
                }
            }
        }
        try {
            this.internal.store(fos, this.prefFileName);
        }
        finally {
            fos.close();
        }
    }

    private Object getDefault(String key) {
        if (this.defaults != null) {
            return this.defaults.get(key);
        }
        return null;
    }

    public Rectangle getRectangle(String key) {
        Rectangle defaultValue = (Rectangle)this.getDefault(key);
        String sp2 = this.internal.getProperty(key);
        if (sp2 == null) {
            return defaultValue;
        }
        Rectangle result2 = new Rectangle();
        try {
            StringTokenizer st = new StringTokenizer(sp2, " ", false);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            String token2 = st.nextToken();
            int x = Integer.parseInt(token2);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            token2 = st.nextToken();
            int y = Integer.parseInt(token2);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            token2 = st.nextToken();
            int w = Integer.parseInt(token2);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            token2 = st.nextToken();
            int h = Integer.parseInt(token2);
            result2.setBounds(x, y, w, h);
            return result2;
        }
        catch (NumberFormatException e) {
            this.internal.remove(key);
            return defaultValue;
        }
    }

    public Dimension getDimension(String key) {
        Dimension defaultValue = (Dimension)this.getDefault(key);
        String sp2 = this.internal.getProperty(key);
        if (sp2 == null) {
            return defaultValue;
        }
        Dimension result2 = new Dimension();
        try {
            StringTokenizer st = new StringTokenizer(sp2, " ", false);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            String token2 = st.nextToken();
            int w = Integer.parseInt(token2);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            token2 = st.nextToken();
            int h = Integer.parseInt(token2);
            result2.setSize(w, h);
            return result2;
        }
        catch (NumberFormatException e) {
            this.internal.remove(key);
            return defaultValue;
        }
    }

    public Point getPoint(String key) {
        Point defaultValue = (Point)this.getDefault(key);
        String sp2 = this.internal.getProperty(key);
        if (sp2 == null) {
            return defaultValue;
        }
        Point result2 = new Point();
        try {
            StringTokenizer st = new StringTokenizer(sp2, " ", false);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            String token2 = st.nextToken();
            int x = Integer.parseInt(token2);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            token2 = st.nextToken();
            int y = Integer.parseInt(token2);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            result2.setLocation(x, y);
            return result2;
        }
        catch (NumberFormatException e) {
            this.internal.remove(key);
            return defaultValue;
        }
    }

    public Color getColor(String key) {
        Color defaultValue = (Color)this.getDefault(key);
        String sp2 = this.internal.getProperty(key);
        if (sp2 == null) {
            return defaultValue;
        }
        try {
            StringTokenizer st = new StringTokenizer(sp2, " ", false);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            String token2 = st.nextToken();
            int r = Integer.parseInt(token2);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            token2 = st.nextToken();
            int g = Integer.parseInt(token2);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            token2 = st.nextToken();
            int b = Integer.parseInt(token2);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            token2 = st.nextToken();
            int a = Integer.parseInt(token2);
            return new Color(r, g, b, a);
        }
        catch (NumberFormatException e) {
            this.internal.remove(key);
            return defaultValue;
        }
    }

    public Font getFont(String key) {
        Font defaultValue = (Font)this.getDefault(key);
        String sp2 = this.internal.getProperty(key);
        if (sp2 == null) {
            return defaultValue;
        }
        try {
            StringTokenizer st = new StringTokenizer(sp2, " ", false);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            String name = st.nextToken();
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            String token2 = st.nextToken();
            int size2 = Integer.parseInt(token2);
            if (!st.hasMoreTokens()) {
                this.internal.remove(key);
                return defaultValue;
            }
            token2 = st.nextToken();
            int type = Integer.parseInt(token2);
            return new Font(name, type, size2);
        }
        catch (NumberFormatException e) {
            this.internal.remove(key);
            return defaultValue;
        }
    }

    public String getString(String key) {
        String sp2 = this.internal.getProperty(key);
        if (sp2 == null) {
            sp2 = (String)this.getDefault(key);
        }
        return sp2;
    }

    public String[] getStrings(String mkey) {
        int i = 0;
        ArrayList<String> v = new ArrayList<String>();
        while (true) {
            String last2 = this.getString(mkey + i);
            ++i;
            if (last2 == null) break;
            v.add(last2);
        }
        if (v.size() != 0) {
            String[] str = new String[v.size()];
            return v.toArray(str);
        }
        return (String[])this.getDefault(mkey);
    }

    public URL getURL(String key) {
        URL defaultValue = (URL)this.getDefault(key);
        String sp2 = this.internal.getProperty(key);
        if (sp2 == null) {
            return defaultValue;
        }
        URL url = null;
        try {
            url = new URL(sp2);
        }
        catch (MalformedURLException ex) {
            this.internal.remove(key);
            return defaultValue;
        }
        return url;
    }

    public URL[] getURLs(String mkey) {
        int i = 0;
        ArrayList<URL> v = new ArrayList<URL>();
        while (true) {
            URL last2 = this.getURL(mkey + i);
            ++i;
            if (last2 == null) break;
            v.add(last2);
        }
        if (v.size() != 0) {
            URL[] path = new URL[v.size()];
            return v.toArray(path);
        }
        return (URL[])this.getDefault(mkey);
    }

    public File getFile(String key) {
        File defaultValue = (File)this.getDefault(key);
        String sp2 = this.internal.getProperty(key);
        if (sp2 == null) {
            return defaultValue;
        }
        File file = new File(sp2);
        if (file.exists()) {
            return file;
        }
        this.internal.remove(key);
        return defaultValue;
    }

    public File[] getFiles(String mkey) {
        int i = 0;
        ArrayList<File> v = new ArrayList<File>();
        while (true) {
            File last2 = this.getFile(mkey + i);
            ++i;
            if (last2 == null) break;
            v.add(last2);
        }
        if (v.size() != 0) {
            File[] path = new File[v.size()];
            return v.toArray(path);
        }
        return (File[])this.getDefault(mkey);
    }

    public int getInteger(String key) {
        int value2;
        String sp2;
        int defaultValue = 0;
        if (this.getDefault(key) != null) {
            defaultValue = (Integer)this.getDefault(key);
        }
        if ((sp2 = this.internal.getProperty(key)) == null) {
            return defaultValue;
        }
        try {
            value2 = Integer.parseInt(sp2);
        }
        catch (NumberFormatException ex) {
            this.internal.remove(key);
            return defaultValue;
        }
        return value2;
    }

    public float getFloat(String key) {
        float value2;
        String sp2;
        float defaultValue = 0.0f;
        if (this.getDefault(key) != null) {
            defaultValue = ((Float)this.getDefault(key)).floatValue();
        }
        if ((sp2 = this.internal.getProperty(key)) == null) {
            return defaultValue;
        }
        try {
            value2 = Float.parseFloat(sp2);
        }
        catch (NumberFormatException ex) {
            this.setFloat(key, defaultValue);
            return defaultValue;
        }
        return value2;
    }

    public boolean getBoolean(String key) {
        if (this.internal.getProperty(key) != null) {
            return this.internal.getProperty(key).equals("true");
        }
        if (this.getDefault(key) != null) {
            return (Boolean)this.getDefault(key);
        }
        return false;
    }

    public void setRectangle(String key, Rectangle value2) {
        if (value2 != null && !value2.equals(this.getDefault(key))) {
            this.internal.setProperty(key, value2.x + " " + value2.y + " " + value2.width + ' ' + value2.height);
        } else {
            this.internal.remove(key);
        }
    }

    public void setDimension(String key, Dimension value2) {
        if (value2 != null && !value2.equals(this.getDefault(key))) {
            this.internal.setProperty(key, value2.width + " " + value2.height);
        } else {
            this.internal.remove(key);
        }
    }

    public void setPoint(String key, Point value2) {
        if (value2 != null && !value2.equals(this.getDefault(key))) {
            this.internal.setProperty(key, value2.x + " " + value2.y);
        } else {
            this.internal.remove(key);
        }
    }

    public void setColor(String key, Color value2) {
        if (value2 != null && !value2.equals(this.getDefault(key))) {
            this.internal.setProperty(key, value2.getRed() + " " + value2.getGreen() + " " + value2.getBlue() + " " + value2.getAlpha());
        } else {
            this.internal.remove(key);
        }
    }

    public void setFont(String key, Font value2) {
        if (value2 != null && !value2.equals(this.getDefault(key))) {
            this.internal.setProperty(key, value2.getName() + " " + value2.getSize() + " " + value2.getStyle());
        } else {
            this.internal.remove(key);
        }
    }

    public void setString(String key, String value2) {
        if (value2 != null && !value2.equals(this.getDefault(key))) {
            this.internal.setProperty(key, value2);
        } else {
            this.internal.remove(key);
        }
    }

    public void setStrings(String mkey, String[] values) {
        String last2;
        int j = 0;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                this.setString(mkey + j, values[i]);
                ++j;
            }
        }
        while ((last2 = this.getString(mkey + j)) != null) {
            this.setString(mkey + j, null);
            ++j;
        }
    }

    public void setURL(String key, URL value2) {
        if (value2 != null && !value2.equals(this.getDefault(key))) {
            this.internal.setProperty(key, value2.toString());
        } else {
            this.internal.remove(key);
        }
    }

    public void setURLs(String mkey, URL[] values) {
        String last2;
        int j = 0;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                this.setURL(mkey + j, values[i]);
                ++j;
            }
        }
        while ((last2 = this.getString(mkey + j)) != null) {
            this.setString(mkey + j, null);
            ++j;
        }
    }

    public void setFile(String key, File value2) {
        if (value2 != null && !value2.equals(this.getDefault(key))) {
            this.internal.setProperty(key, value2.getAbsolutePath());
        } else {
            this.internal.remove(key);
        }
    }

    public void setFiles(String mkey, File[] values) {
        String last2;
        int j = 0;
        if (values != null) {
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                this.setFile(mkey + j, values[i]);
                ++j;
            }
        }
        while ((last2 = this.getString(mkey + j)) != null) {
            this.setString(mkey + j, null);
            ++j;
        }
    }

    public void setInteger(String key, int value2) {
        if (this.getDefault(key) != null && (Integer)this.getDefault(key) != value2) {
            this.internal.setProperty(key, Integer.toString(value2));
        } else {
            this.internal.remove(key);
        }
    }

    public void setFloat(String key, float value2) {
        if (this.getDefault(key) != null && ((Float)this.getDefault(key)).floatValue() != value2) {
            this.internal.setProperty(key, Float.toString(value2));
        } else {
            this.internal.remove(key);
        }
    }

    public void setBoolean(String key, boolean value2) {
        if (this.getDefault(key) != null && (Boolean)this.getDefault(key) != value2) {
            this.internal.setProperty(key, value2 ? "true" : "false");
        } else {
            this.internal.remove(key);
        }
    }
}

