/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.AreaTreeHandler;
import org.apache.fop.fo.Constants;
import org.apache.fop.fo.pagination.PageSequence;
import org.apache.fop.fo.pagination.SimplePageMaster;
import org.apache.fop.layoutmgr.Page;

public class PageProvider
implements Constants {
    private Log log = LogFactory.getLog(PageProvider.class);
    public static final int RELTO_PAGE_SEQUENCE = 0;
    public static final int RELTO_CURRENT_ELEMENT_LIST = 1;
    private int startPageOfPageSequence;
    private int startPageOfCurrentElementList;
    private int startColumnOfCurrentElementList;
    private boolean spanAllForCurrentElementList;
    private List<Page> cachedPages = new ArrayList<Page>();
    private int lastPageIndex = -1;
    private int indexOfCachedLastPage = -1;
    private int lastRequestedIndex = -1;
    private int lastReportedBPD = -1;
    private AreaTreeHandler areaTreeHandler;
    private PageSequence pageSeq;

    public PageProvider(AreaTreeHandler ath, PageSequence ps) {
        this.areaTreeHandler = ath;
        this.pageSeq = ps;
        this.startPageOfPageSequence = ps.getStartingPageNumber();
    }

    public void setStartOfNextElementList(int startPage, int startColumn, boolean spanAll) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("start of the next element list is: page=" + startPage + " col=" + startColumn + (spanAll ? ", column-spanning" : ""));
        }
        this.startPageOfCurrentElementList = startPage - this.startPageOfPageSequence + 1;
        this.startColumnOfCurrentElementList = startColumn;
        this.spanAllForCurrentElementList = spanAll;
        this.lastRequestedIndex = -1;
        this.lastReportedBPD = -1;
    }

    public void setLastPageIndex(int index2) {
        this.lastPageIndex = index2;
    }

    public int getAvailableBPD(int index2) {
        if (this.lastRequestedIndex == index2) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("getAvailableBPD(" + index2 + ") -> (cached) " + this.lastReportedBPD);
            }
            return this.lastReportedBPD;
        }
        int pageIndex = 0;
        int colIndex = this.startColumnOfCurrentElementList;
        Page page = this.getPage(false, pageIndex, 1);
        for (int c = index2; c > 0; --c) {
            if (++colIndex < page.getPageViewport().getCurrentSpan().getColumnCount()) continue;
            colIndex = 0;
            page = this.getPage(false, ++pageIndex, 1);
        }
        this.lastRequestedIndex = index2;
        this.lastReportedBPD = page.getPageViewport().getBodyRegion().getRemainingBPD();
        if (this.log.isTraceEnabled()) {
            this.log.trace("getAvailableBPD(" + index2 + ") -> " + this.lastReportedBPD);
        }
        return this.lastReportedBPD;
    }

    private int[] getColIndexAndColCount(int index2) {
        Page page;
        int columnCount = 0;
        int colIndex = this.startColumnOfCurrentElementList + index2;
        int pageIndex = -1;
        while ((colIndex -= columnCount) >= (columnCount = (page = this.getPage(false, ++pageIndex, 1)).getPageViewport().getCurrentSpan().getColumnCount())) {
        }
        return new int[]{colIndex, columnCount};
    }

    public int compareIPDs(int index2) {
        Page page;
        int columnCount = 0;
        int colIndex = this.startColumnOfCurrentElementList + index2;
        int pageIndex = -1;
        while ((colIndex -= columnCount) >= (columnCount = (page = this.getPage(false, ++pageIndex, 1)).getPageViewport().getCurrentSpan().getColumnCount())) {
        }
        if (colIndex + 1 < columnCount) {
            return 0;
        }
        Page nextPage = this.getPage(false, pageIndex + 1, 1);
        return page.getPageViewport().getBodyRegion().getIPD() - nextPage.getPageViewport().getBodyRegion().getIPD();
    }

    boolean startPage(int index2) {
        return this.getColIndexAndColCount(index2)[0] == 0;
    }

    boolean endPage(int index2) {
        int[] colIndexAndColCount = this.getColIndexAndColCount(index2);
        return colIndexAndColCount[0] == colIndexAndColCount[1] - 1;
    }

    int getColumnCount(int index2) {
        return this.getColIndexAndColCount(index2)[1];
    }

    public int getStartingPartIndexForLastPage(int partCount) {
        int result2 = 0;
        int pageIndex = 0;
        int colIndex = this.startColumnOfCurrentElementList;
        Page page = this.getPage(false, pageIndex, 1);
        for (int idx = 0; idx < partCount; ++idx) {
            if (colIndex >= page.getPageViewport().getCurrentSpan().getColumnCount()) {
                colIndex = 0;
                page = this.getPage(false, ++pageIndex, 1);
                result2 = idx;
            }
            ++colIndex;
        }
        return result2;
    }

    public Page getPage(boolean isBlank, int index2, int relativeTo) {
        if (relativeTo == 0) {
            return this.getPage(isBlank, index2);
        }
        if (relativeTo == 1) {
            int effIndex = this.startPageOfCurrentElementList + index2;
            return this.getPage(isBlank, effIndex += this.startPageOfPageSequence - 1);
        }
        throw new IllegalArgumentException("Illegal value for relativeTo: " + relativeTo);
    }

    protected Page getPage(boolean isBlank, int index2) {
        boolean isLastPage;
        boolean bl = isLastPage = this.lastPageIndex >= 0 && index2 == this.lastPageIndex;
        if (this.log.isTraceEnabled()) {
            this.log.trace("getPage(" + index2 + " " + (isBlank ? "blank" : "non-blank") + (isLastPage ? " <LAST>" : "") + ")");
        }
        int intIndex = index2 - this.startPageOfPageSequence;
        if (this.log.isTraceEnabled()) {
            if (isBlank) {
                this.log.trace("blank page requested: " + index2);
            }
            if (isLastPage) {
                this.log.trace("last page requested: " + index2);
            }
        }
        while (intIndex >= this.cachedPages.size()) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Caching " + index2);
            }
            this.cacheNextPage(index2, isBlank, isLastPage, this.spanAllForCurrentElementList);
        }
        Page page = this.cachedPages.get(intIndex);
        boolean replace = false;
        if (page.getPageViewport().isBlank() != isBlank) {
            this.log.debug("blank condition doesn't match. Replacing PageViewport.");
            replace = true;
        }
        if (isLastPage && this.indexOfCachedLastPage != intIndex || !isLastPage && this.indexOfCachedLastPage >= 0) {
            this.log.debug("last page condition doesn't match. Replacing PageViewport.");
            replace = true;
            int n = this.indexOfCachedLastPage = isLastPage ? intIndex : -1;
        }
        if (replace) {
            this.discardCacheStartingWith(intIndex);
            page = this.cacheNextPage(index2, isBlank, isLastPage, this.spanAllForCurrentElementList);
        }
        return page;
    }

    private void discardCacheStartingWith(int index2) {
        while (index2 < this.cachedPages.size()) {
            this.cachedPages.remove(this.cachedPages.size() - 1);
            if (this.pageSeq.goToPreviousSimplePageMaster()) continue;
            this.log.warn("goToPreviousSimplePageMaster() on the first page called!");
        }
    }

    private Page cacheNextPage(int index2, boolean isBlank, boolean isLastPage, boolean spanAll) {
        String pageNumberString = this.pageSeq.makeFormattedPageNumber(index2);
        boolean isFirstPage = this.startPageOfPageSequence == index2;
        SimplePageMaster spm = this.pageSeq.getNextSimplePageMaster(index2, isFirstPage, isLastPage, isBlank);
        Page page = new Page(spm, index2, pageNumberString, isBlank, spanAll);
        page.getPageViewport().setKey(this.areaTreeHandler.generatePageViewportKey());
        page.getPageViewport().setForeignAttributes(spm.getForeignAttributes());
        page.getPageViewport().setWritingModeTraits(this.pageSeq);
        this.cachedPages.add(page);
        return page;
    }
}

