/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.pdf;

import java.util.LinkedList;
import java.util.Locale;
import org.apache.fop.accessibility.StructureTreeElement;
import org.apache.fop.accessibility.StructureTreeEventHandler;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.pdf.PDFFactory;
import org.apache.fop.pdf.PDFName;
import org.apache.fop.pdf.PDFObject;
import org.apache.fop.pdf.PDFParentTree;
import org.apache.fop.pdf.PDFStructElem;
import org.apache.fop.pdf.PDFStructTreeRoot;
import org.apache.fop.render.pdf.FOToPDFRoleMap;
import org.apache.fop.render.pdf.PDFLogicalStructureHandler;
import org.xml.sax.Attributes;

class PDFStructureTreeBuilder
implements StructureTreeEventHandler {
    private PDFFactory pdfFactory;
    private PDFLogicalStructureHandler logicalStructureHandler;
    private EventBroadcaster eventBroadcaster;
    private LinkedList<PDFStructElem> ancestors = new LinkedList();
    private PDFStructElem rootStructureElement;

    PDFStructureTreeBuilder() {
    }

    void setPdfFactory(PDFFactory pdfFactory) {
        this.pdfFactory = pdfFactory;
    }

    void setLogicalStructureHandler(PDFLogicalStructureHandler logicalStructureHandler) {
        this.logicalStructureHandler = logicalStructureHandler;
        this.createRootStructureElement();
    }

    private void createRootStructureElement() {
        assert (this.rootStructureElement == null);
        PDFParentTree parentTree = this.logicalStructureHandler.getParentTree();
        PDFStructTreeRoot structTreeRoot = this.pdfFactory.getDocument().makeStructTreeRoot(parentTree);
        this.rootStructureElement = this.createStructureElement("root", structTreeRoot, null);
        structTreeRoot.addKid(this.rootStructureElement);
    }

    void setEventBroadcaster(EventBroadcaster eventBroadcaster) {
        this.eventBroadcaster = eventBroadcaster;
    }

    public void startPageSequence(Locale language2, String role) {
        this.ancestors = new LinkedList();
        PDFStructElem structElem = this.createStructureElement("page-sequence", this.rootStructureElement, role);
        if (language2 != null) {
            structElem.setLanguage(language2);
        }
        this.rootStructureElement.addKid(structElem);
        this.ancestors.add(structElem);
    }

    private PDFStructElem createStructureElement(String name, PDFObject parent, String role) {
        PDFName structureType = FOToPDFRoleMap.mapFormattingObject(name, role, parent, this.eventBroadcaster);
        return this.pdfFactory.getDocument().makeStructureElement(structureType, parent);
    }

    public void endPageSequence() {
    }

    public StructureTreeElement startNode(String name, Attributes attributes) {
        PDFStructElem parent = this.ancestors.getFirst();
        String role = attributes.getValue("role");
        PDFStructElem structElem = this.createStructureElement(name, parent, role);
        parent.addKid(structElem);
        this.ancestors.addFirst(structElem);
        return structElem;
    }

    public void endNode(String name) {
        this.removeFirstAncestor();
    }

    private void removeFirstAncestor() {
        this.ancestors.removeFirst();
    }

    public StructureTreeElement startImageNode(String name, Attributes attributes) {
        PDFStructElem parent = this.ancestors.getFirst();
        String role = attributes.getValue("role");
        PDFStructElem structElem = this.createStructureElement(name, parent, role);
        parent.addKid(structElem);
        String altTextNode = attributes.getValue("http://xmlgraphics.apache.org/fop/extensions", "alt-text");
        if (altTextNode != null) {
            structElem.put("Alt", altTextNode);
        } else {
            structElem.put("Alt", "No alternate text specified");
        }
        this.ancestors.addFirst(structElem);
        return structElem;
    }

    public StructureTreeElement startReferencedNode(String name, Attributes attributes) {
        PDFStructElem parent = this.ancestors.getFirst();
        String role = attributes.getValue("role");
        PDFStructElem structElem = "#PCDATA".equals(name) ? new PDFStructElem.Placeholder((PDFObject)parent, name) : this.createStructureElement(name, parent, role);
        parent.addKid(structElem);
        this.ancestors.addFirst(structElem);
        return structElem;
    }
}

