/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.rtf.rtflib.rtfdoc;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import org.apache.fop.render.rtf.rtflib.exceptions.RtfStructureException;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfAttributes;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfElement;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfFile;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfOptions;
import org.apache.fop.render.rtf.rtflib.rtfdoc.RtfText;

public class RtfContainer
extends RtfElement {
    private LinkedList children;
    private RtfOptions options = new RtfOptions();
    private RtfElement lastChild;

    RtfContainer(RtfContainer parent, Writer w) throws IOException {
        this(parent, w, null);
    }

    RtfContainer(RtfContainer parent, Writer w, RtfAttributes attr) throws IOException {
        super(parent, w, attr);
        this.children = new LinkedList();
    }

    public void setOptions(RtfOptions opt2) {
        this.options = opt2;
    }

    protected void addChild(RtfElement e) throws RtfStructureException {
        if (this.isClosed()) {
            StringBuffer sb = new StringBuffer();
            sb.append("addChild: container already closed (parent=");
            sb.append(this.getClass().getName());
            sb.append(" child=");
            sb.append(e.getClass().getName());
            sb.append(")");
            String msg = sb.toString();
            RtfFile rf = this.getRtfFile();
        }
        this.children.add(e);
        this.lastChild = e;
    }

    public List getChildren() {
        return (List)this.children.clone();
    }

    public int getChildCount() {
        return this.children.size();
    }

    private int findChildren(RtfElement aChild, int iStart) {
        for (RtfElement e : this.getChildren()) {
            int iFound;
            if (aChild == e) {
                return iStart;
            }
            if (!(e instanceof RtfContainer) || (iFound = ((RtfContainer)e).findChildren(aChild, iStart + 1)) == -1) continue;
            return iFound;
        }
        return -1;
    }

    public int findChildren(RtfElement aChild) {
        return this.findChildren(aChild, 0);
    }

    public boolean setChildren(List list2) {
        if (list2 instanceof LinkedList) {
            this.children = (LinkedList)list2;
            return true;
        }
        return false;
    }

    protected void writeRtfContent() throws IOException {
        for (RtfElement e : this.children) {
            e.writeRtf();
        }
    }

    RtfOptions getOptions() {
        return this.options;
    }

    boolean containsText() {
        boolean result2 = false;
        for (RtfElement e : this.children) {
            if (e instanceof RtfText) {
                result2 = !e.isEmpty();
            } else if (e instanceof RtfContainer && ((RtfContainer)e).containsText()) {
                result2 = true;
            }
            if (!result2) continue;
            break;
        }
        return result2;
    }

    void dump(Writer w, int indent) throws IOException {
        super.dump(w, indent);
        for (RtfElement e : this.children) {
            e.dump(w, indent + 1);
        }
    }

    public String toString() {
        return super.toString() + " (" + this.getChildCount() + " children)";
    }

    protected boolean okToWriteRtf() {
        boolean result2;
        boolean bl = result2 = super.okToWriteRtf() && !this.isEmpty();
        if (result2 && !this.options.renderContainer(this)) {
            result2 = false;
        }
        return result2;
    }

    public boolean isEmpty() {
        boolean result2 = true;
        for (RtfElement e : this.children) {
            if (e.isEmpty()) continue;
            result2 = false;
            break;
        }
        return result2;
    }
}

