/*
 * Decompiled with CFR 0.152.
 */
package fi.evolver.script.system;

import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.TextUtils;
import java.util.List;
import java.util.stream.Collectors;

public class Hosts {
    public static void addHostBlock(String blockId, List<HostMapping> hosts) {
        String block = hosts.stream().map(HostMapping::toLine).collect(Collectors.joining("\n"));
        Hosts.addHostBlock(blockId, block);
    }

    public static void addHostBlock(String blockId, String hostsBlock) {
        String originalContents = Shell.sudo("cat", "/etc/hosts");
        String updatedContents = TextUtils.addShellBlock(originalContents, blockId, hostsBlock);
        FileUtils.sudoWrite("/etc/hosts", updatedContents, "root:root", "644");
    }

    public record HostMapping(String ip, String host) {
        public static HostMapping localhost(String host) {
            return new HostMapping("127.0.0.1", host);
        }

        public String toLine() {
            return "%s\t%s".formatted(this.ip, this.host);
        }
    }
}

