package fi.evolver.script.app;

import java.net.URI;

import fi.evolver.script.FileUtils;
import fi.evolver.script.Shell;
import fi.evolver.script.Step;
import fi.evolver.script.app.Apt.Source;

public class Kubectl {

	/**
	 * @param kubectlVersion The kubectl version e.g. 1.32
	 */
	public static void install(String kubectlVersion) {
		try (Step step = Step.start("Kubectl: install")) {
			Apt.addSource(Source.builder("kubernetes", URI.create("https://pkgs.k8s.io/core:/stable:/v%s/deb/".formatted(kubectlVersion)), "/", "")
					.setSignedBy("kubernetes-apt-keyring.gpg", URI.create("https://pkgs.k8s.io/core:/stable:/v%s/deb/Release.key".formatted(kubectlVersion)))
					.build());
			Apt.update();
			Apt.install("kubectl");

			FileUtils.writeShellBlock(Shell.BASHRC, "kubectl config", """
					source <(kubectl completion bash)
					alias k=kubectl
					complete -o default -F __start_kubectl k
					""");
		}
	}

}
