/*
 * Decompiled with CFR 0.152.
 */
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class InterceptedMessage {
    public byte[] requestBody;
    public byte[] responseBody;
    public String requestMethod;
    public URL requestURL;
    public List<String[]> requestHeaders;
    public int responseCode;
    public List<String[]> responseHeaders;

    public InterceptedMessage(ByteBuffer buffer) throws IOException {
        String[] headerArray;
        buffer = buffer.order(ByteOrder.LITTLE_ENDIAN);
        int metadataSize = buffer.getInt();
        int request_content_size = buffer.getInt();
        int response_content_size = buffer.getInt();
        byte[] metadataBytes = new byte[metadataSize];
        buffer.get(metadataBytes);
        this.requestBody = new byte[request_content_size];
        buffer.get(this.requestBody);
        this.responseBody = new byte[response_content_size];
        buffer.get(this.responseBody);
        ObjectMapper mapper = new ObjectMapper();
        JsonNode metadata = mapper.readTree(metadataBytes);
        this.requestMethod = metadata.get("request").get("method").asText();
        this.requestURL = new URL(metadata.get("request").get("url").asText());
        JsonNode headers = metadata.get("request").get("headers");
        this.requestHeaders = new ArrayList<String[]>();
        for (JsonNode headerNode : headers) {
            headerArray = new String[]{headerNode.get(0).asText(), headerNode.get(1).asText()};
            this.requestHeaders.add(headerArray);
        }
        this.responseCode = metadata.get("response").get("status_code").asInt();
        headers = metadata.get("request").get("headers");
        this.responseHeaders = new ArrayList<String[]>();
        for (JsonNode headerNode : headers) {
            headerArray = new String[]{headerNode.get(0).asText(), headerNode.get(1).asText()};
            this.responseHeaders.add(headerArray);
        }
    }

    public ByteBuffer serializedResponseToMitmproxy() throws JsonProcessingException {
        int contentLength = this.responseBody.length;
        ObjectMapper mapper = new ObjectMapper();
        ObjectNode metadataRoot = mapper.createObjectNode();
        metadataRoot.put("status_code", this.responseCode);
        ArrayNode headersNode = mapper.createArrayNode();
        List headerNodes = this.responseHeaders.stream().map(h -> {
            ArrayNode headerPair = mapper.createArrayNode();
            headerPair.add(h[0]);
            if (h[0].equals("content-length")) {
                headerPair.add(Integer.toString(contentLength));
            } else {
                headerPair.add(h[1]);
            }
            return headerPair;
        }).collect(Collectors.toList());
        headersNode.addAll(headerNodes);
        metadataRoot.set("headers", (JsonNode)headersNode);
        String metadataJson = mapper.writeValueAsString((Object)metadataRoot);
        byte[] metadata = metadataJson.getBytes(StandardCharsets.UTF_8);
        int metadataLength = metadata.length;
        ByteBuffer buffer = ByteBuffer.allocate(8 + metadataLength + contentLength);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(metadataLength);
        buffer.putInt(contentLength);
        buffer.put(metadata);
        buffer.put(this.responseBody);
        return (ByteBuffer)buffer.rewind();
    }
}

