/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import org.zeroturnaround.exec.ProcessExecutor;
import org.zeroturnaround.exec.ProcessResult;
import org.zeroturnaround.exec.stream.slf4j.Slf4jStream;

public class MitmproxyJava {
    private String mitmproxyPath;
    private MitmproxyServer server;
    private Future<ProcessResult> mitmproxyProcess;
    public static final int WEBSOCKET_PORT = 8765;

    public MitmproxyJava(String mitmproxyPath, Function<InterceptedMessage, InterceptedMessage> messageInterceptor) throws URISyntaxException {
        this.mitmproxyPath = mitmproxyPath;
        this.server = new MitmproxyServer(new InetSocketAddress("localhost", 8765), messageInterceptor);
        this.server.start();
    }

    public void start() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        System.out.println("starting mitmproxy on port 8080");
        this.mitmproxyProcess = new ProcessExecutor().command(new String[]{this.mitmproxyPath, "--anticache", "-s", "scripts/proxy.py"}).redirectOutput((OutputStream)Slf4jStream.ofCaller().asInfo()).destroyOnExit().start().getFuture();
        this.waitForPortToBeInUse(8080);
        System.out.println("mitmproxy started on port 8080");
    }

    public void stop() throws IOException, InterruptedException {
        if (this.mitmproxyProcess != null) {
            this.mitmproxyProcess.cancel(true);
        }
        this.server.stop(1000);
        Thread.sleep(200L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitForPortToBeInUse(int port) throws TimeoutException {
        boolean inUse = false;
        Socket s = null;
        int tries = 0;
        int maxTries = 600;
        while (!inUse) {
            block15: {
                try {
                    s = new Socket("localhost", port);
                }
                catch (IOException e) {
                    inUse = false;
                }
                finally {
                    if (s == null) break block15;
                    inUse = true;
                    try {
                        s.close();
                    }
                    catch (Exception e) {}
                    break;
                }
            }
            if (++tries == maxTries) {
                throw new TimeoutException("Timed out waiting for mitmproxy to start");
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

