/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.logging;

import io.appulse.logging.AnsiColor;
import io.appulse.logging.AnsiElement;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReference;
import lombok.NonNull;

public final class AnsiOutput {
    private static final String ENCODE_JOIN = ";";
    private static final String OPERATING_SYSTEM_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String ENCODE_START = "\u001b[";
    private static final String ENCODE_END = "m";
    private static final String RESET = "0;" + AnsiColor.DEFAULT;
    private static Enabled enabled = Enabled.DETECT;
    private static Boolean consoleAvailable;
    private static AtomicReference<Boolean> ansiCapable;

    public static void setEnabled(@NonNull Enabled enabled) {
        if (enabled == null) {
            throw new NullPointerException("enabled is marked non-null but is null");
        }
        AnsiOutput.enabled = enabled;
    }

    public static void setConsoleAvailable(Boolean consoleAvailable) {
        AnsiOutput.consoleAvailable = consoleAvailable;
    }

    public static String encode(AnsiElement element) {
        if (AnsiOutput.isEnabled().booleanValue()) {
            return ENCODE_START + element + ENCODE_END;
        }
        return "";
    }

    public static String toString(Object ... elements) {
        StringBuilder sb = new StringBuilder();
        if (AnsiOutput.isEnabled().booleanValue()) {
            AnsiOutput.buildEnabled(sb, elements);
        } else {
            AnsiOutput.buildDisabled(sb, elements);
        }
        return sb.toString();
    }

    static Enabled getEnabled() {
        return enabled;
    }

    private static void buildEnabled(StringBuilder sb, Object[] elements) {
        boolean writingAnsi = false;
        boolean containsEncoding = false;
        for (Object element : elements) {
            if (element instanceof AnsiElement) {
                containsEncoding = true;
                if (writingAnsi) {
                    sb.append(ENCODE_JOIN);
                } else {
                    sb.append(ENCODE_START);
                    writingAnsi = true;
                }
            } else if (writingAnsi) {
                sb.append(ENCODE_END);
                writingAnsi = false;
            }
            sb.append(element);
        }
        if (containsEncoding) {
            sb.append(writingAnsi ? ENCODE_JOIN : ENCODE_START);
            sb.append(RESET);
            sb.append(ENCODE_END);
        }
    }

    private static void buildDisabled(StringBuilder sb, Object[] elements) {
        for (Object element : elements) {
            if (element instanceof AnsiElement || element == null) continue;
            sb.append(element);
        }
    }

    private static Boolean isEnabled() {
        if (enabled != Enabled.DETECT) {
            return enabled == Enabled.ALWAYS;
        }
        Boolean value = ansiCapable.get();
        if (value != null) {
            return value;
        }
        return ansiCapable.updateAndGet(it -> it == null ? AnsiOutput.detectIfAnsiCapable() : it);
    }

    private static Boolean detectIfAnsiCapable() {
        try {
            if (consoleAvailable != null && !consoleAvailable.booleanValue()) {
                return false;
            }
            if (consoleAvailable == null && System.console() == null) {
                return false;
            }
            return OPERATING_SYSTEM_NAME.indexOf("win") < 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private AnsiOutput() {
    }

    static {
        ansiCapable = new AtomicReference();
    }

    public static enum Enabled {
        DETECT,
        ALWAYS,
        NEVER;

    }
}

