/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

public final class AnnotationUtils {
    public static <T extends Annotation> Optional<T> findAnnotation(Class<?> clazz, Class<T> annotationType) {
        T result = AnnotationUtils.findAnnotation(clazz, annotationType, new HashSet<Annotation>());
        return Optional.ofNullable(result);
    }

    public static <T extends Annotation> Optional<T> findAnnotation(AnnotatedElement annotatedElement, Class<T> annotationType) {
        T result = AnnotationUtils.findAnnotation(annotatedElement, annotationType, new HashSet<Annotation>());
        return Optional.ofNullable(result);
    }

    public static <T extends Annotation> Optional<T> findAnnotation(Method method, Class<T> annotationType) {
        T result = AnnotationUtils.findAnnotation(method, annotationType, new HashSet<Annotation>());
        return Optional.ofNullable(result);
    }

    public static boolean isInJavaLangAnnotationPackage(Annotation annotation) {
        return annotation != null && AnnotationUtils.isInJavaLangAnnotationPackage(annotation.annotationType());
    }

    public static boolean isInJavaLangAnnotationPackage(Class<? extends Annotation> annotationType) {
        return annotationType != null && AnnotationUtils.isInJavaLangAnnotationPackage(annotationType.getName());
    }

    public static boolean isInJavaLangAnnotationPackage(String annotationType) {
        return annotationType != null && annotationType.startsWith("java.lang.annotation");
    }

    private static <T extends Annotation> T findAnnotation(Method method, Class<T> annotationType, Set<Annotation> visited) {
        T result = AnnotationUtils.findAnnotation((AnnotatedElement)method, annotationType, visited);
        if (result != null) {
            return result;
        }
        Class<?> declaringClass = method.getDeclaringClass();
        return (T)Optional.ofNullable(declaringClass.getSuperclass()).filter(it -> it != Object.class).map(it -> AnnotationUtils.findAnnotation(it, method, annotationType, visited)).filter(Objects::nonNull).orElseGet(() -> Stream.of(declaringClass.getInterfaces()).map(it -> AnnotationUtils.findAnnotation(it, method, annotationType, visited)).filter(Objects::nonNull).findAny().orElse(null));
    }

    private static <T extends Annotation> T findAnnotation(Class<?> clazz, Method method, Class<T> annotationType, Set<Annotation> visited) {
        return (T)((Annotation)Stream.of(clazz.getDeclaredMethods()).filter(it -> method.getName().equals(it.getName())).filter(it -> Arrays.equals(method.getParameterTypes(), it.getParameterTypes())).findAny().map(it -> AnnotationUtils.findAnnotation(it, annotationType, visited)).orElse(null));
    }

    private static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationType, Set<Annotation> visited) {
        T result = AnnotationUtils.findAnnotation(clazz, annotationType, visited);
        if (result != null) {
            return result;
        }
        for (Class<?> type : clazz.getInterfaces()) {
            T annotation = AnnotationUtils.findAnnotation(type, annotationType, visited);
            if (annotation == null) continue;
            return annotation;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null || Object.class == superclass) {
            return null;
        }
        return AnnotationUtils.findAnnotation(superclass, annotationType, visited);
    }

    private static <T extends Annotation> T findAnnotation(AnnotatedElement annotatedElement, Class<T> annotationType, Set<Annotation> visited) {
        Annotation[] declaredAnnotations;
        for (Annotation annotation : declaredAnnotations = annotatedElement.getDeclaredAnnotations()) {
            if (annotation.annotationType() != annotationType) continue;
            return (T)annotation;
        }
        for (Annotation annotation : declaredAnnotations) {
            T result;
            if (AnnotationUtils.isInJavaLangAnnotationPackage(annotation) || !visited.add(annotation) || (result = AnnotationUtils.findAnnotation(annotation.annotationType(), annotationType, visited)) == null) continue;
            return result;
        }
        return null;
    }

    private AnnotationUtils() {
    }
}

