/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import io.appulse.utils.BytesAbstract;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Arrays;
import lombok.NonNull;

class BytesByteBuffer
extends BytesAbstract {
    private ByteBuffer buffer;
    private int writerIndex;
    private int readerIndex;

    static BytesByteBuffer copy(@NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        ByteBuffer copy = buffer;
        return new BytesByteBuffer(copy);
    }

    BytesByteBuffer(@NonNull ByteBuffer buffer) {
        if (buffer == null) {
            throw new NullPointerException("buffer is marked non-null but is null");
        }
        this.buffer = buffer;
    }

    @Override
    public boolean isAutoResizable() {
        return false;
    }

    @Override
    public Bytes writeNB(@NonNull byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        this.setNB(this.writerIndex, bytes, offset, length);
        this.writerIndex += length;
        return this;
    }

    @Override
    public Bytes write1B(byte value) {
        this.set1B(this.writerIndex, value);
        ++this.writerIndex;
        return this;
    }

    @Override
    public Bytes write2B(short value) {
        this.set2B(this.writerIndex, value);
        this.writerIndex += 2;
        return this;
    }

    @Override
    public Bytes write4B(int value) {
        this.set4B(this.writerIndex, value);
        this.writerIndex += 4;
        return this;
    }

    @Override
    public Bytes write8B(long value) {
        this.set8B(this.writerIndex, value);
        this.writerIndex += 8;
        return this;
    }

    @Override
    public Bytes setNB(int index, @NonNull byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        int position = this.buffer.position();
        this.buffer.position(index);
        this.buffer.put(bytes, offset, length);
        this.buffer.position(position);
        return this;
    }

    @Override
    public Bytes set1B(int index, byte value) {
        this.checkWriteBounds(index, 1);
        this.buffer.put(index, value);
        return this;
    }

    @Override
    public Bytes set2B(int index, short value) {
        this.checkWriteBounds(index, 2);
        this.buffer.putShort(index, value);
        return this;
    }

    @Override
    public Bytes set4B(int index, int value) {
        this.checkWriteBounds(index, 4);
        this.buffer.putInt(index, value);
        return this;
    }

    @Override
    public Bytes set8B(int index, long value) {
        this.checkWriteBounds(index, 8);
        this.buffer.putLong(index, value);
        return this;
    }

    @Override
    public byte readByte() {
        byte result = this.getByte(this.readerIndex);
        ++this.readerIndex;
        return result;
    }

    @Override
    public short readShort() {
        short result = this.getShort(this.readerIndex);
        this.readerIndex += 2;
        return result;
    }

    @Override
    public int readInt() {
        int result = this.getInt(this.readerIndex);
        this.readerIndex += 4;
        return result;
    }

    @Override
    public long readLong() {
        long result = this.getLong(this.readerIndex);
        this.readerIndex += 8;
        return result;
    }

    @Override
    public float readFloat() {
        float result = this.getFloat(this.readerIndex);
        this.readerIndex += 4;
        return result;
    }

    @Override
    public double readDouble() {
        double result = this.getDouble(this.readerIndex);
        this.readerIndex += 8;
        return result;
    }

    @Override
    public char readChar() {
        char result = this.getChar(this.readerIndex);
        this.readerIndex += 2;
        return result;
    }

    @Override
    public Bytes readBytes(@NonNull byte[] destination, int offset, int length) {
        if (destination == null) {
            throw new NullPointerException("destination is marked non-null but is null");
        }
        this.checkReaderBounds(this.readerIndex, length);
        this.buffer.get(destination, offset, length);
        this.readerIndex += length;
        return this;
    }

    @Override
    public byte getByte(int index) {
        this.checkReaderBounds(index, 1);
        return this.buffer.get(index);
    }

    @Override
    public short getShort(int index) {
        this.checkReaderBounds(index, 2);
        return this.buffer.getShort(index);
    }

    @Override
    public int getInt(int index) {
        this.checkReaderBounds(index, 4);
        return this.buffer.getInt(index);
    }

    @Override
    public long getLong(int index) {
        this.checkReaderBounds(index, 8);
        return this.buffer.getLong(index);
    }

    @Override
    public float getFloat(int index) {
        this.checkReaderBounds(index, 4);
        return this.buffer.getFloat(index);
    }

    @Override
    public double getDouble(int index) {
        this.checkReaderBounds(index, 8);
        return this.buffer.getDouble(index);
    }

    @Override
    public char getChar(int index) {
        this.checkReaderBounds(index, 2);
        return this.buffer.getChar(index);
    }

    @Override
    public byte[] getBytes(int index, int length) {
        this.checkReaderBounds(index, length);
        byte[] result = new byte[length];
        int position = this.buffer.position();
        this.buffer.position(index);
        this.buffer.put(result);
        this.buffer.position(position);
        return result;
    }

    @Override
    public String getString(int index, int length, @NonNull Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset is marked non-null but is null");
        }
        this.checkReaderBounds(index, length);
        byte[] bytes = this.getBytes(index, length);
        return new String(bytes, charset);
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public void capacity(int bytes) {
        if (this.capacity() == bytes) {
            return;
        }
        int oldPosition = this.buffer.position();
        byte[] newByteArray = Arrays.copyOf(this.buffer.array(), bytes);
        this.buffer = ByteBuffer.wrap(newByteArray);
        this.buffer.position(Math.min(oldPosition, bytes - 1));
        this.writerIndex = Math.min(this.writerIndex, bytes - 1);
        this.readerIndex = Math.min(this.readerIndex, bytes - 1);
    }

    @Override
    public int writerIndex() {
        return this.writerIndex;
    }

    @Override
    public Bytes writerIndex(int newIndex) {
        if (newIndex < this.readerIndex() || newIndex > this.capacity()) {
            throw new IndexOutOfBoundsException();
        }
        this.writerIndex = newIndex;
        return this;
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    @Override
    public Bytes readerIndex(int newIndex) {
        if (newIndex < 0 || newIndex > this.writerIndex()) {
            throw new IndexOutOfBoundsException();
        }
        this.readerIndex = newIndex;
        return this;
    }

    @Override
    public byte[] array() {
        return this.buffer.array();
    }
}

