/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import java.io.IOException;
import java.io.InputStream;
import lombok.NonNull;

public class BytesInputStream
extends InputStream {
    private Bytes buffer;
    private int mark;

    public BytesInputStream(byte[] bytes) {
        this.buffer = Bytes.wrap(bytes);
    }

    public BytesInputStream(Bytes bytes) {
        this.buffer = bytes;
    }

    public BytesInputStream(byte[] bytes, int offset, int length) {
        this.buffer = Bytes.wrap(bytes);
        this.buffer.readerIndex(offset);
        this.buffer.writerIndex(length);
    }

    @Override
    public synchronized int read() throws IOException {
        return this.buffer.isReadable() ? (int)this.buffer.readUnsignedByte() : -1;
    }

    @Override
    public synchronized int read(@NonNull byte[] bytes, int offset, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes is marked non-null but is null");
        }
        int readerIndex = this.buffer.readerIndex();
        this.buffer.readBytes(bytes, offset, length);
        return this.buffer.readerIndex() - readerIndex;
    }

    @Override
    public synchronized long skip(long skipBytes) {
        int readerIndex = this.buffer.readerIndex();
        int readableBytes = this.buffer.readableBytes();
        int skip = (int)Math.min((long)readableBytes, skipBytes);
        this.buffer.readerIndex(readerIndex + skip);
        return skip;
    }

    @Override
    public synchronized int available() {
        return this.buffer.readableBytes();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readAheadLimit) {
        this.mark = this.buffer.readerIndex();
    }

    @Override
    public synchronized void reset() {
        this.buffer.readerIndex(this.mark);
    }

    @Override
    public void close() {
    }
}

