/*
 * Decompiled with CFR 0.152.
 */
package io.appulse.utils;

import io.appulse.utils.Bytes;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.stream.Stream;
import lombok.NonNull;

public final class BytesUtils {
    public static byte[] asBytes(char value) {
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    public static byte[] asBytes(byte value) {
        return new byte[]{value};
    }

    public static byte[] asBytes(short value) {
        return new byte[]{(byte)(value >> 8), (byte)value};
    }

    public static byte[] asBytes(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static byte[] asBytes(long value) {
        return new byte[]{(byte)(value >> 56), (byte)(value >> 48), (byte)(value >> 40), (byte)(value >> 32), (byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    public static byte[] asBytes(float value) {
        return BytesUtils.asBytes(Float.floatToRawIntBits(value));
    }

    public static byte[] asBytes(double value) {
        return BytesUtils.asBytes(Double.doubleToRawLongBits(value));
    }

    public static short asUnsignedByte(byte value) {
        return BytesUtils.asUnsignedByte(new byte[]{value});
    }

    public static short asUnsignedByte(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return BytesUtils.asShort(bytes);
    }

    public static short asShort(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        byte[] aligned = BytesUtils.align(bytes, 2);
        return (short)(aligned[0] << 8 | aligned[1] & 0xFF);
    }

    public static int asUnsignedShort(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return BytesUtils.asShort(bytes) & 0xFFFF;
    }

    public static char asChar(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        byte[] aligned = BytesUtils.align(bytes, 2);
        return (char)(aligned[0] << 8 | aligned[1] & 0xFF);
    }

    public static int asInteger(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        byte[] aligned = BytesUtils.align(bytes, 4);
        return aligned[0] << 24 | (aligned[1] & 0xFF) << 16 | (aligned[2] & 0xFF) << 8 | aligned[3] & 0xFF;
    }

    public static long asUnsignedInteger(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return BytesUtils.asLong(bytes);
    }

    public static long asLong(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        byte[] aligned = BytesUtils.align(bytes, 8);
        return (long)aligned[0] << 56 | ((long)aligned[1] & 0xFFL) << 48 | ((long)aligned[2] & 0xFFL) << 40 | ((long)aligned[3] & 0xFFL) << 32 | ((long)aligned[4] & 0xFFL) << 24 | ((long)aligned[5] & 0xFFL) << 16 | ((long)aligned[6] & 0xFFL) << 8 | (long)aligned[7] & 0xFFL;
    }

    public static float asFloat(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        byte[] aligned = BytesUtils.align(bytes, 4);
        return Float.intBitsToFloat(BytesUtils.asInteger(aligned));
    }

    public static double asDouble(@NonNull byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        byte[] aligned = BytesUtils.align(bytes, 8);
        return Double.longBitsToDouble(BytesUtils.asLong(aligned));
    }

    public static byte[] concatenate(byte[] ... arrays) {
        if (arrays == null) {
            throw new NullPointerException("arrays");
        }
        int size = Stream.of(arrays).mapToInt(it -> ((byte[])it).length).sum();
        ByteBuffer buffer = ByteBuffer.allocate(size);
        Stream.of(arrays).forEach(buffer::put);
        return buffer.array();
    }

    public static byte[] align(@NonNull byte[] bytes, int length) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        if (length <= 0 || bytes.length == length) {
            return bytes;
        }
        byte[] result = new byte[length];
        int srcPos = 0;
        int destPos = 0;
        if (bytes.length > length) {
            srcPos = bytes.length - length;
        } else if (bytes.length < length) {
            destPos = length - bytes.length;
        }
        System.arraycopy(bytes, srcPos, result, destPos, Math.min(bytes.length, length));
        return result;
    }

    public static byte[] read(@NonNull InputStream stream) {
        int length;
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(32);
        byte[] buffer = new byte[32];
        while ((length = stream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, length);
        }
        return outputStream.toByteArray();
    }

    public static byte[] read(@NonNull InputStream stream, int length) {
        int count;
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        byte[] result = new byte[length];
        for (int readed = 0; readed < length; readed += count) {
            count = stream.read(result, readed, length - readed);
            if (count >= -1) continue;
            throw new EOFException();
        }
        return result;
    }

    public static Bytes readBytes(@NonNull InputStream stream) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        byte[] result = BytesUtils.read(stream);
        return Bytes.wrap(result);
    }

    public static Bytes readBytes(@NonNull InputStream stream, int length) {
        if (stream == null) {
            throw new NullPointerException("stream");
        }
        byte[] result = BytesUtils.read(stream, length);
        return Bytes.wrap(result);
    }

    private BytesUtils() {
    }
}

