/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.plugin.cloudsql.postgres;

import com.google.common.collect.ImmutableMap;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.cdap.etl.api.FailureCollector;
import io.cdap.cdap.etl.api.PipelineConfigurer;
import io.cdap.plugin.db.action.AbstractDBAction;
import io.cdap.plugin.db.action.QueryConfig;
import io.cdap.plugin.util.CloudSQLUtil;
import java.util.Map;
import javax.annotation.Nullable;

@Plugin(type="action")
@Name(value="CloudSQLPostgreSQL")
@Description(value="Action that runs a PostgreSQL command on a CloudSQL PostgreSQL instance")
public class CloudSQLPostgreSQLAction
extends AbstractDBAction {
    private final CloudSQLPostgreSQLActionConfig cloudsqlPostgresqlActionConfig;

    public CloudSQLPostgreSQLAction(CloudSQLPostgreSQLActionConfig cloudsqlPostgresqlActionConfig) {
        super((QueryConfig)cloudsqlPostgresqlActionConfig, Boolean.valueOf(false));
        this.cloudsqlPostgresqlActionConfig = cloudsqlPostgresqlActionConfig;
    }

    public void configurePipeline(PipelineConfigurer pipelineConfigurer) {
        FailureCollector failureCollector = pipelineConfigurer.getStageConfigurer().getFailureCollector();
        CloudSQLUtil.checkConnectionName((FailureCollector)failureCollector, (String)this.cloudsqlPostgresqlActionConfig.instanceType, (String)this.cloudsqlPostgresqlActionConfig.connectionName);
        super.configurePipeline(pipelineConfigurer);
    }

    public static class CloudSQLPostgreSQLActionConfig
    extends QueryConfig {
        @Name(value="connectionName")
        @Description(value="The CloudSQL instance to connect to. For a public instance, the connection string should be in the format <PROJECT_ID>:<REGION>:<INSTANCE_NAME> which can be found in the instance overview page. For a private instance, enter the internal IP address of the Compute Engine VM cloudsql proxy is running on.")
        public String connectionName;
        @Name(value="database")
        @Description(value="Database name to connect to")
        public String database;
        @Name(value="connectionTimeout")
        @Description(value="The timeout value used for socket connect operations. If connecting to the server takes longer than this value, the connection is broken. The timeout is specified in seconds and a value of zero means that it is disabled")
        @Nullable
        public Integer connectionTimeout;
        @Name(value="instanceType")
        @Description(value="Whether the CloudSQL instance to connect to is private or public.")
        @Nullable
        public String instanceType = "public";

        public String getConnectionString() {
            if ("private".equalsIgnoreCase(this.instanceType)) {
                return String.format("jdbc:postgresql://%s/%s", this.connectionName, this.database);
            }
            return String.format("jdbc:postgresql:///%s?cloudSqlInstance=%s&socketFactory=com.google.cloud.sql.postgres.SocketFactory", this.database, this.connectionName);
        }

        public Map<String, String> getDBSpecificArguments() {
            return ImmutableMap.of((Object)"connectionTimeout", (Object)String.valueOf(this.connectionTimeout));
        }
    }
}

