/*
 * Decompiled with CFR 0.152.
 */
package io.cloudboost;

import io.cloudboost.CloudException;
import io.cloudboost.json.JSONArray;
import io.cloudboost.json.JSONException;
import io.cloudboost.json.JSONObject;
import java.util.ArrayList;

public class CloudGeoPoint {
    JSONObject document;
    private ArrayList<Double> coordinates;

    public CloudGeoPoint(Double latitude, Double longitude) throws CloudException {
        this.document = new JSONObject();
        this.coordinates = new ArrayList();
        try {
            this.document.put("_type", "point");
            this.document.put("_isModified", true);
            if (!(latitude >= -90.0 && latitude <= 90.0 && longitude >= -180.0 && longitude <= 180.0)) {
                throw new CloudException("latitude and longitudes are not in range");
            }
            this.coordinates.add(longitude);
            this.coordinates.add(latitude);
            this.document.put("coordinates", this.coordinates);
            this.document.put("longitude", longitude);
            this.document.put("latitude", latitude);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public CloudGeoPoint(String latitud, String longitud) throws CloudException {
        Double latitude = 0.0;
        Double longitude = 0.0;
        try {
            latitude = Double.parseDouble(latitud);
            longitude = Double.parseDouble(longitud);
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException();
        }
        this.document = new JSONObject();
        this.coordinates = new ArrayList();
        try {
            this.document.put("_type", "point");
            this.document.put("_isModified", true);
            if (!(latitude >= -90.0 && latitude <= 90.0 && longitude >= -180.0 && longitude <= 180.0)) {
                throw new CloudException("latitude and longitudes are not in range");
            }
            this.coordinates.add(longitude);
            this.coordinates.add(latitude);
            this.document.put("coordinates", this.coordinates);
            this.document.put("longitude", longitude);
            this.document.put("latitude", latitude);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void setLongitude(Double longitude) throws CloudException {
        if (longitude >= -180.0 && longitude <= 180.0) {
            try {
                this.document.put("longitude", longitude);
                JSONArray lat = new JSONArray(this.document.get("coordinates").toString());
                for (int i = 0; i < lat.length(); ++i) {
                    this.coordinates.add(Double.valueOf(lat.getInt(i)));
                }
                this.coordinates.set(0, longitude);
                this.document.put("coordinates", this.coordinates);
                this.document.put("_isModified", true);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            throw new CloudException("Longitude is not in Range");
        }
    }

    public Double getLongitude() {
        try {
            return this.document.getDouble("longitude");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public void setLatitute(Double latitute) throws CloudException {
        if (latitute >= -90.0 && latitute <= 90.0) {
            try {
                this.document.put("latitude", latitute);
                JSONArray lat = new JSONArray(this.document.get("coordinates").toString());
                for (int i = 0; i < lat.length(); ++i) {
                    this.coordinates.add(Double.valueOf(lat.getInt(i)));
                }
                this.coordinates.set(1, latitute);
                this.document.put("coordinates", this.coordinates);
                this.document.put("_isModified", true);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            throw new CloudException("Latitude is not in Range");
        }
    }

    public Double getLatitute() {
        try {
            return this.document.getDouble("latitude");
        }
        catch (JSONException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public Double distanceInKMs(CloudGeoPoint point) {
        int earthRedius = 6371;
        return (double)earthRedius * this.greatCircleFormula(point);
    }

    public Double distanceInMiles(CloudGeoPoint point) {
        int earthRedius = 3959;
        return (double)earthRedius * this.greatCircleFormula(point);
    }

    public Double distanceInRadians(CloudGeoPoint point) {
        return this.greatCircleFormula(point);
    }

    private Double greatCircleFormula(CloudGeoPoint point) {
        try {
            this.coordinates = (ArrayList)this.document.get("coordinates");
            point.coordinates = (ArrayList)point.document.get("coordinates");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        Double dLat = this.toRad(this.coordinates.get(1) - point.coordinates.get(1));
        Double dLon = this.toRad(this.coordinates.get(0) - point.coordinates.get(0));
        Double lat1 = this.toRad(point.coordinates.get(1));
        Double lat2 = this.toRad(this.coordinates.get(1));
        Double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.sin(dLon / 2.0) * Math.sin(dLon / 2.0) * Math.cos(lat1) * Math.cos(lat2);
        Double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        return c;
    }

    private Double toRad(Double number) {
        return number * Math.PI / 180.0;
    }

    public static CloudGeoPoint toGeoPoint(Object object) throws JSONException, CloudException {
        JSONObject doc = new JSONObject(object.toString());
        CloudGeoPoint loc = new CloudGeoPoint(doc.getDouble("latitude"), doc.getDouble("longitude"));
        loc.document = doc;
        return loc;
    }
}

