/*
 * Decompiled with CFR 0.152.
 */
package io.cloudboost;

import io.cloudboost.ACL;
import io.cloudboost.CloudApp;
import io.cloudboost.CloudException;
import io.cloudboost.CloudQueueArrayCallback;
import io.cloudboost.CloudQueueCallback;
import io.cloudboost.CloudQueueMessageCallback;
import io.cloudboost.QueueMessage;
import io.cloudboost.beans.CBResponse;
import io.cloudboost.json.JSONArray;
import io.cloudboost.json.JSONException;
import io.cloudboost.json.JSONObject;
import io.cloudboost.util.CBParser;
import java.util.ArrayList;

public class CloudQueue {
    public ACL acl = new ACL();
    protected JSONObject document;
    private CloudQueue thisObj;
    protected ArrayList<String> subscribers;
    protected String queueType = "pull";
    protected long timeout = 1800L;
    protected long delay = 1800L;
    protected ArrayList<QueueMessage> messages = new ArrayList();
    public static final String QUEUE_TYPE = "queueType";
    protected String name;

    public JSONObject getDocument() {
        return this.document;
    }

    public void setDocument(JSONObject document) {
        this.document = document;
    }

    public ArrayList<String> getSubscribers() {
        return this.subscribers;
    }

    public void setSubscribers(ArrayList<String> subscribers) {
        this.subscribers = subscribers;
    }

    public ACL getAcl() {
        return this.acl;
    }

    public void setAcl(ACL acl) {
        this.acl = acl;
    }

    public CloudQueue getThisObj() {
        return this.thisObj;
    }

    public void setThisObj(CloudQueue thisObj) {
        this.thisObj = thisObj;
    }

    public void setQueueType(String queueType) {
        this.setAttribute(QUEUE_TYPE, queueType);
    }

    public long getTimeout() {
        return (Long)this.getAttribute("timeout");
    }

    public void setTimeout(long timeout) {
        this.setAttribute("timeout", timeout);
    }

    public long getDelay() {
        return (Long)this.getAttribute("delay");
    }

    public void setDelay(long delay) {
        this.setAttribute("delay", delay);
    }

    public ArrayList<QueueMessage> getMessages() {
        return this.messages;
    }

    public void setMessages(ArrayList<QueueMessage> messages) {
        this.messages = messages;
        this.setAttribute("messages", messages);
    }

    public String getName() {
        return (String)this.getAttribute("name");
    }

    public void setName(String name) {
        this.setAttribute("name", name);
    }

    public static String getQueueType() {
        return QUEUE_TYPE;
    }

    public CloudQueue(String queueName, String queueType) {
        this.subscribers = new ArrayList();
        this.document = new JSONObject();
        try {
            this.document.put("subscribers", this.subscribers);
            this.document.put("retry", JSONObject.NULL);
            this.document.put("name", queueName == null ? "null" : queueName);
            this.document.put("_type", "queue");
            this.document.put("ACL", this.acl.getACL());
            this.document.put("expires", JSONObject.NULL);
            this.document.put(QUEUE_TYPE, queueType == null ? this.queueType : queueType);
            this.document.put("messages", this.messages);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.thisObj = this;
    }

    public Object getAttribute(String key) {
        try {
            return this.document.get(key);
        }
        catch (JSONException e) {
            return null;
        }
    }

    public void refreshMessageTimeout(QueueMessage msg, CloudQueueMessageCallback callback) {
        JSONObject data = new JSONObject();
        String id = msg.getId();
        try {
            data.put("key", CloudApp.getAppKey());
            String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/" + id + "/refresh-message-timeout";
            if (this.validate()) {
                CBResponse response = CBParser.callJson(url, "PUT", data);
                if (response.getStatusCode() == 200) {
                    JSONObject body = new JSONObject(response.getResponseBody());
                    QueueMessage qmsg = new QueueMessage();
                    qmsg.setDocument(body);
                    QueueMessage[] qmsgs = new QueueMessage[]{qmsg};
                    callback.done(qmsgs, null);
                } else {
                    callback.done(null, new CloudException(response.getStatusMessage()));
                }
            } else {
                callback.done(null, new CloudException("Object Validation Failure"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void refreshMessageTimeout(QueueMessage msg, int timeout, CloudQueueMessageCallback callback) {
        JSONObject data = new JSONObject();
        String id = msg.getId();
        try {
            data.put("timeout", timeout);
            data.put("key", CloudApp.getAppKey());
            String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/" + id + "/refresh-message-timeout";
            if (this.validate()) {
                CBResponse response = CBParser.callJson(url, "PUT", data);
                if (response.getStatusCode() == 200) {
                    JSONObject body = new JSONObject(response.getResponseBody());
                    QueueMessage qmsg = new QueueMessage();
                    qmsg.setDocument(body);
                    QueueMessage[] qmsgs = new QueueMessage[]{qmsg};
                    callback.done(qmsgs, null);
                } else {
                    callback.done(null, new CloudException(response.getStatusMessage()));
                }
            } else {
                callback.done(null, new CloudException("Object Validation Failure"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void addChangedColumn(String columnName) {
    }

    public void setAttribute(String propertyName, Object value) {
        try {
            this.document.put(propertyName, value);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public boolean validate() {
        try {
            String name = this.document.getString("name");
            return name != null && !"".equals(name);
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void peekMessage(int count, CloudQueueMessageCallback callback) {
        block7: {
            JSONObject data = new JSONObject();
            try {
                data.put("count", count);
                data.put("key", CloudApp.getAppKey());
                String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + "/" + this.document.get("name") + "/peekMessage";
                if (this.validate()) {
                    CBResponse response = CBParser.callJson(url, "POST", data);
                    if (response.getStatusCode() == 200) {
                        JSONArray body = null;
                        try {
                            body = new JSONArray(response.getResponseBody());
                        }
                        catch (JSONException e) {
                            body = new JSONArray();
                            body.put(new JSONObject(response.getResponseBody()));
                        }
                        QueueMessage[] msgArr = new QueueMessage[body.length()];
                        for (int i = 0; i < body.length(); ++i) {
                            JSONObject obj = body.getJSONObject(i);
                            QueueMessage msg = new QueueMessage();
                            msg.setDocument(obj);
                            msgArr[i] = msg;
                        }
                        callback.done(msgArr, null);
                        break block7;
                    }
                    callback.done(null, new CloudException(response.getStatusMessage()));
                    break block7;
                }
                callback.done(null, new CloudException("Object Validation Failure"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void peek(int count, CloudQueueMessageCallback callback) {
        block7: {
            JSONObject data = new JSONObject();
            try {
                data.put("count", count);
                data.put("key", CloudApp.getAppKey());
                String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/peek";
                if (this.validate()) {
                    CBResponse response = CBParser.callJson(url, "POST", data);
                    if (response.getStatusCode() == 200) {
                        JSONArray body = null;
                        try {
                            body = new JSONArray(response.getResponseBody());
                        }
                        catch (JSONException e) {
                            body = new JSONArray();
                            body.put(new JSONObject(response.getResponseBody()));
                        }
                        QueueMessage[] msgArr = new QueueMessage[body.length()];
                        for (int i = 0; i < body.length(); ++i) {
                            JSONObject obj = body.getJSONObject(i);
                            QueueMessage msg = new QueueMessage();
                            msg.setDocument(obj);
                            msgArr[i] = msg;
                        }
                        callback.done(msgArr, null);
                        break block7;
                    }
                    callback.done(null, new CloudException(response.getStatusMessage()));
                    break block7;
                }
                callback.done(null, new CloudException("Object Validation Failure"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void getMessage(int count, CloudQueueMessageCallback callback) {
        block8: {
            JSONObject data = new JSONObject();
            try {
                data.put("count", count);
                data.put("key", CloudApp.getAppKey());
                String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/getMessage";
                if (this.validate()) {
                    CBResponse response = CBParser.callJson(url, "POST", data);
                    if (response.getResponseBody() == null || "".equals(response.getResponseBody())) {
                        callback.done(null, new CloudException("No message found"));
                        return;
                    }
                    if (response.getStatusCode() == 200) {
                        JSONArray body = null;
                        try {
                            body = new JSONArray(response.getResponseBody());
                        }
                        catch (JSONException e) {
                            body = new JSONArray();
                            body.put(new JSONObject(response.getResponseBody()));
                        }
                        QueueMessage[] msgArr = new QueueMessage[body.length()];
                        for (int i = 0; i < body.length(); ++i) {
                            JSONObject obj = body.getJSONObject(i);
                            QueueMessage msg = new QueueMessage();
                            msg.setDocument(obj);
                            msgArr[i] = msg;
                        }
                        callback.done(msgArr, null);
                        break block8;
                    }
                    callback.done(null, new CloudException(response.getStatusMessage()));
                    break block8;
                }
                callback.done(null, new CloudException("Object Validation Failure"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteMessage(String id, CloudQueueMessageCallback callback) {
        block7: {
            JSONObject data = new JSONObject();
            try {
                data.put("key", CloudApp.getAppKey());
                String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/message/" + id;
                if (this.validate()) {
                    CBResponse response = CBParser.callJson(url, "DELETE", data);
                    if (response.getStatusCode() == 200) {
                        JSONArray body = null;
                        try {
                            body = new JSONArray(response.getResponseBody());
                        }
                        catch (JSONException e) {
                            body = new JSONArray();
                            body.put(new JSONObject(response.getResponseBody()));
                        }
                        QueueMessage[] msgArr = new QueueMessage[body.length()];
                        for (int i = 0; i < body.length(); ++i) {
                            JSONObject obj = body.getJSONObject(i);
                            QueueMessage msg = new QueueMessage();
                            msg.setDocument(obj);
                            msgArr[i] = msg;
                        }
                        callback.done(msgArr, null);
                        break block7;
                    }
                    callback.done(null, new CloudException(response.getStatusMessage()));
                    break block7;
                }
                callback.done(null, new CloudException("Object Validation Failure"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteMessage(QueueMessage message, CloudQueueMessageCallback callback) {
        block7: {
            JSONObject data = new JSONObject();
            try {
                data.put("key", CloudApp.getAppKey());
                String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/message/" + message.getId();
                if (this.validate()) {
                    CBResponse response = CBParser.callJson(url, "DELETE", data);
                    if (response.getStatusCode() == 200) {
                        JSONArray body = null;
                        try {
                            body = new JSONArray(response.getResponseBody());
                        }
                        catch (JSONException e) {
                            body = new JSONArray();
                            body.put(new JSONObject(response.getResponseBody()));
                        }
                        QueueMessage[] msgArr = new QueueMessage[body.length()];
                        for (int i = 0; i < body.length(); ++i) {
                            JSONObject obj = body.getJSONObject(i);
                            QueueMessage msg = new QueueMessage();
                            msg.setDocument(obj);
                            msgArr[i] = msg;
                        }
                        callback.done(msgArr, null);
                        break block7;
                    }
                    callback.done(null, new CloudException(response.getStatusMessage()));
                    break block7;
                }
                callback.done(null, new CloudException("Object Validation Failure"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void getMessageById(String id, CloudQueueMessageCallback callback) {
        block8: {
            JSONObject data = new JSONObject();
            try {
                data.put("key", CloudApp.getAppKey());
                String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/message/" + id;
                if (this.validate()) {
                    CBResponse response = CBParser.callJson(url, "POST", data);
                    if (response.getStatusCode() == 200) {
                        JSONArray body;
                        block7: {
                            body = null;
                            try {
                                body = new JSONArray(response.getResponseBody());
                            }
                            catch (JSONException e) {
                                body = new JSONArray();
                                String respon = response.getResponseBody();
                                if (respon == null || "".equals(respon)) break block7;
                                body.put(new JSONObject(respon));
                            }
                        }
                        QueueMessage[] msgArr = new QueueMessage[body.length()];
                        for (int i = 0; i < body.length(); ++i) {
                            JSONObject obj = body.getJSONObject(i);
                            QueueMessage msg = new QueueMessage();
                            msg.setDocument(obj);
                            msgArr[i] = msg;
                        }
                        callback.done(msgArr, null);
                        break block8;
                    }
                    callback.done(null, new CloudException(response.getStatusMessage()));
                    break block8;
                }
                callback.done(null, new CloudException("Object Validation Failure"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void deleteSubscriber(Object subscriber, CloudQueueCallback callback) {
        this.subscribers.clear();
        try {
            Object mss;
            if (subscriber instanceof String[]) {
                for (String str : mss = (String[])subscriber) {
                    this.subscribers.add(str);
                }
            } else if (subscriber instanceof String) {
                mss = (String)subscriber;
                this.subscribers.add((String)mss);
            } else if (subscriber == null) {
                throw new CloudException("Cannot push null into queue");
            }
            String url = null;
            JSONObject data = new JSONObject();
            this.document.put("subscribers", this.subscribers);
            data.put("document", this.document);
            data.put("key", CloudApp.getAppKey());
            url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/subscriber";
            this.thisObj = this;
            if (this.validate()) {
                CBResponse response = CBParser.callJson(url, "DELETE", data);
                if (response.getStatusCode() == 200) {
                    JSONObject body;
                    this.document = body = new JSONObject(response.getResponseBody());
                    callback.done(this.thisObj, null);
                } else {
                    callback.done(null, new CloudException(response.getStatusMessage()));
                }
            } else {
                callback.done(null, new CloudException("Object Validation Failure"));
            }
        }
        catch (JSONException e) {
            callback.done(null, new CloudException(e.getMessage()));
        }
        catch (CloudException e) {
            callback.done(null, e);
        }
    }

    public void addSubscriber(Object subscriber, CloudQueueCallback callback) {
        this.subscribers.clear();
        try {
            Object mss;
            if (subscriber instanceof String[]) {
                for (String str : mss = (String[])subscriber) {
                    this.subscribers.add(str);
                }
            } else if (subscriber instanceof String) {
                mss = (String)subscriber;
                this.subscribers.add((String)mss);
            } else if (subscriber == null) {
                throw new CloudException("invalid url");
            }
            String url = null;
            JSONObject data = new JSONObject();
            this.document.put("subscribers", this.subscribers);
            data.put("document", this.document);
            data.put("key", CloudApp.getAppKey());
            url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/subscriber";
            this.thisObj = this;
            if (this.validate()) {
                CBResponse response = CBParser.callJson(url, "POST", data);
                if (response.getStatusCode() == 200) {
                    JSONObject body;
                    this.document = body = new JSONObject(response.getResponseBody());
                    callback.done(this.thisObj, null);
                } else {
                    callback.done(null, new CloudException(response.getStatusMessage()));
                }
            } else {
                callback.done(null, new CloudException("Object Validation Failure"));
            }
        }
        catch (JSONException e) {
            callback.done(null, new CloudException(e.getMessage()));
        }
        catch (CloudException e) {
            callback.done(null, e);
        }
    }

    public void removeSubscriber(Object subscriber, CloudQueueCallback callback) {
        this.subscribers.clear();
        try {
            Object mss;
            if (subscriber instanceof String[]) {
                for (String str : mss = (String[])subscriber) {
                    this.subscribers.add(str);
                }
            } else if (subscriber instanceof String) {
                mss = (String)subscriber;
                this.subscribers.add((String)mss);
            } else if (subscriber == null) {
                throw new CloudException("invalid url");
            }
            String url = null;
            JSONObject data = new JSONObject();
            this.document.put("subscribers", this.subscribers);
            data.put("document", this.document);
            data.put("key", CloudApp.getAppKey());
            url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/subscriber";
            this.thisObj = this;
            if (this.validate()) {
                CBResponse response = CBParser.callJson(url, "DELETE", data);
                if (response.getStatusCode() == 200) {
                    JSONObject body;
                    this.document = body = new JSONObject(response.getResponseBody());
                    callback.done(this.thisObj, null);
                } else {
                    callback.done(null, new CloudException(response.getStatusMessage()));
                }
            } else {
                callback.done(null, new CloudException("Object Validation Failure"));
            }
        }
        catch (JSONException e) {
            callback.done(null, new CloudException(e.getMessage()));
        }
        catch (CloudException e) {
            callback.done(null, e);
        }
    }

    public void addMessage(Object message, CloudQueueMessageCallback callback) {
        block20: {
            this.messages.clear();
            try {
                Object mss;
                if (message instanceof QueueMessage[]) {
                    mss = (QueueMessage[])message;
                    for (Object object : mss) {
                        this.messages.add((QueueMessage)object);
                    }
                } else if (message instanceof QueueMessage) {
                    this.messages.add((QueueMessage)message);
                } else if (message instanceof String[]) {
                    mss = (String[])message;
                    for (Object object : mss) {
                        QueueMessage msg = new QueueMessage();
                        msg.push((String)object);
                        this.messages.add(msg);
                    }
                } else if (message instanceof String) {
                    mss = (String)message;
                    QueueMessage msg = new QueueMessage();
                    msg.push((String)mss);
                    this.messages.add(msg);
                } else if (message == null) {
                    throw new CloudException("Cannot push null into queue");
                }
                JSONArray arr = new JSONArray();
                String url = null;
                JSONObject data = new JSONObject();
                for (QueueMessage queueMessage : this.messages) {
                    arr.put(queueMessage.getDocument());
                }
                this.document.put("messages", arr);
                data.put("document", this.document);
                data.put("key", CloudApp.getAppKey());
                url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/message";
                this.thisObj = this;
                boolean valid = this.validate();
                if (valid) {
                    CBResponse cBResponse = CBParser.callJson(url, "PUT", data);
                    if (cBResponse.getStatusCode() == 200) {
                        JSONArray body = null;
                        try {
                            body = new JSONArray(cBResponse.getResponseBody());
                        }
                        catch (JSONException e) {
                            body = new JSONArray();
                            body.put(new JSONObject(cBResponse.getResponseBody()));
                        }
                        QueueMessage[] msgArr = new QueueMessage[body.length()];
                        for (int i = 0; i < body.length(); ++i) {
                            JSONObject obj = body.getJSONObject(i);
                            QueueMessage msg = new QueueMessage();
                            msg.setDocument(obj);
                            msgArr[i] = msg;
                        }
                        callback.done(msgArr, null);
                        break block20;
                    }
                    callback.done(null, new CloudException(cBResponse.getStatusMessage()));
                    break block20;
                }
                callback.done(null, new CloudException("Object Validation Failure"));
            }
            catch (JSONException e) {
                callback.done(null, new CloudException(e.getMessage()));
            }
            catch (CloudException e) {
                callback.done(null, e);
            }
        }
    }

    public void push(Object message, CloudQueueMessageCallback callback) {
        block18: {
            this.messages.clear();
            try {
                Object mss;
                if (message instanceof QueueMessage[]) {
                    mss = (QueueMessage[])message;
                    for (Object object : mss) {
                        this.messages.add((QueueMessage)object);
                    }
                } else if (message instanceof String[]) {
                    mss = (String[])message;
                    for (Object object : mss) {
                        QueueMessage msg = new QueueMessage();
                        msg.push((String)object);
                        this.messages.add(msg);
                    }
                } else if (message instanceof String) {
                    mss = (String)message;
                    QueueMessage msg = new QueueMessage();
                    msg.push((String)mss);
                    this.messages.add(msg);
                } else if (message == null) {
                    throw new CloudException("Cannot push null into queue");
                }
                JSONArray arr = new JSONArray();
                String url = null;
                JSONObject data = new JSONObject();
                for (QueueMessage queueMessage : this.messages) {
                    arr.put(queueMessage.getDocument());
                }
                this.document.put("messages", arr);
                data.put("document", this.document);
                data.put("key", CloudApp.getAppKey());
                url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/message";
                this.thisObj = this;
                boolean valid = this.validate();
                if (valid) {
                    CBResponse cBResponse = CBParser.callJson(url, "PUT", data);
                    if (cBResponse.getStatusCode() == 200) {
                        JSONArray body = null;
                        try {
                            body = new JSONArray(cBResponse.getResponseBody());
                        }
                        catch (JSONException e) {
                            body = new JSONArray();
                            body.put(new JSONObject(cBResponse.getResponseBody()));
                        }
                        QueueMessage[] msgArr = new QueueMessage[body.length()];
                        for (int i = 0; i < body.length(); ++i) {
                            JSONObject obj = body.getJSONObject(i);
                            QueueMessage msg = new QueueMessage();
                            msg.setDocument(obj);
                            msgArr[i] = msg;
                        }
                        callback.done(msgArr, null);
                        break block18;
                    }
                    callback.done(null, new CloudException(cBResponse.getStatusMessage()));
                    break block18;
                }
                callback.done(null, new CloudException("Object Validation Failure"));
            }
            catch (JSONException e) {
                callback.done(null, new CloudException(e.getMessage()));
            }
            catch (CloudException e) {
                callback.done(null, e);
            }
        }
    }

    public void deleteQueue(CloudQueueCallback callback) {
        try {
            String url = null;
            JSONObject data = new JSONObject();
            data.put("document", this.document);
            data.put("key", CloudApp.getAppKey());
            url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name");
            this.thisObj = this;
            if (this.validate()) {
                CBResponse response = CBParser.callJson(url, "DELETE", data);
                if (response.getStatusCode() == 200) {
                    JSONObject body;
                    this.thisObj.document = body = new JSONObject(response.getResponseBody());
                    callback.done(this.thisObj, null);
                } else {
                    callback.done(null, new CloudException(response.getStatusMessage()));
                }
            } else {
                callback.done(null, new CloudException("Object Validation Failure"));
            }
        }
        catch (JSONException e) {
            callback.done(null, new CloudException(e.getMessage()));
        }
    }

    public void pull(int count, CloudQueueMessageCallback callback) {
        block7: {
            try {
                String url = null;
                JSONObject data = new JSONObject();
                data.put("count", count);
                data.put("key", CloudApp.getAppKey());
                url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/pull";
                this.thisObj = this;
                if (this.validate()) {
                    CBResponse response = CBParser.callJson(url, "POST", data);
                    if (response.getStatusCode() == 200) {
                        JSONArray body = null;
                        try {
                            body = new JSONArray(response.getResponseBody());
                        }
                        catch (JSONException e) {
                            body = new JSONArray();
                            body.put(new JSONObject(response.getResponseBody()));
                        }
                        QueueMessage[] msgArr = new QueueMessage[body.length()];
                        for (int i = 0; i < body.length(); ++i) {
                            JSONObject obj = body.getJSONObject(i);
                            QueueMessage msg = new QueueMessage();
                            msg.setDocument(obj);
                            msgArr[i] = msg;
                        }
                        callback.done(msgArr, null);
                        break block7;
                    }
                    callback.done(null, new CloudException(response.getStatusMessage()));
                    break block7;
                }
                callback.done(null, new CloudException("Object Validation Failure"));
            }
            catch (JSONException e) {
                callback.done(null, new CloudException(e.getMessage()));
            }
        }
    }

    public void clear(CloudQueueCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put("key", CloudApp.getAppKey());
            data.put("document", this.document);
            String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/clear";
            if (this.validate()) {
                CBResponse response = CBParser.callJson(url, "DELETE", data);
                if (response.getStatusCode() == 200) {
                    JSONObject body;
                    this.thisObj.document = body = new JSONObject(response.getResponseBody());
                    callback.done(this.thisObj, null);
                } else {
                    callback.done(null, new CloudException(response.getStatusMessage()));
                }
            } else {
                callback.done(null, new CloudException("Object Validation Failure"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void get(String queueName, CloudQueueCallback callback) {
        CloudQueue queue = new CloudQueue(queueName, null);
        queue.get(callback);
    }

    public void deleteQueue(String queueName, CloudQueueCallback callback) {
        CloudQueue queue = new CloudQueue(queueName, null);
        queue.deleteQueue(callback);
    }

    public void update(CloudQueueCallback callback) {
        this.validate();
        JSONObject data = new JSONObject();
        try {
            data.put("key", CloudApp.getAppKey());
            this.setAttribute("_isModified", true);
            this.setAttribute("_modifiedColumns", "[\"queueType\"]");
            data.put("document", this.document);
            String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name");
            if (this.validate()) {
                CBResponse response = CBParser.callJson(url, "PUT", data);
                if (response.getStatusCode() == 200) {
                    JSONObject body;
                    this.thisObj.document = body = new JSONObject(response.getResponseBody());
                    callback.done(this.thisObj, null);
                } else {
                    callback.done(null, new CloudException(response.getStatusMessage()));
                }
            } else {
                callback.done(null, new CloudException("Object Validation Failure"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void get(CloudQueueCallback callback) {
        this.validate();
        JSONObject data = new JSONObject();
        try {
            data.put("key", CloudApp.getAppKey());
            String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/";
            if (this.validate()) {
                CBResponse response = CBParser.callJson(url, "POST", data);
                if (response.getStatusCode() == 200) {
                    JSONObject body;
                    this.thisObj.document = body = new JSONObject(response.getResponseBody());
                    callback.done(this.thisObj, null);
                } else {
                    callback.done(null, new CloudException(response.getStatusMessage()));
                }
            } else {
                callback.done(null, new CloudException("Object Validation Failure"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void getAllMessages(CloudQueueArrayCallback callback) {
        this.validate();
        JSONObject data = new JSONObject();
        try {
            data.put("key", CloudApp.getAppKey());
            String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + "/messages";
            if (this.validate()) {
                CBResponse response = CBParser.callJson(url, "POST", data);
                if (response.getStatusCode() == 200) {
                    JSONArray arr = new JSONArray(response.getResponseBody());
                    CloudQueue[] queues = new CloudQueue[arr.length()];
                    for (int i = 0; i < arr.length(); ++i) {
                        JSONObject obj = arr.getJSONObject(i);
                        CloudQueue queue = new CloudQueue(null, null);
                        queue.document = obj;
                        queue.thisObj = queue;
                        queues[i] = queue;
                    }
                    callback.done(queues, null);
                } else {
                    callback.done(null, new CloudException(response.getStatusMessage()));
                }
            } else {
                callback.done(null, new CloudException("Object Validation Failure"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void delete(CloudQueueCallback callback) {
        JSONObject data = new JSONObject();
        if (!this.validate()) {
            callback.done(null, new CloudException("Can't create queue without a name"));
            return;
        }
        try {
            data.put("key", CloudApp.getAppKey());
            data.put("document", this.document);
            String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + "/" + this.getAttribute("name");
            CBResponse response = CBParser.callJson(url, "DELETE", data);
            if (response.getStatusCode() == 200) {
                JSONObject body;
                this.document = body = new JSONObject(response.getResponseBody());
                callback.done(this, null);
            } else {
                callback.done(null, new CloudException(response.getStatusMessage()));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void create(CloudQueueCallback callback) {
        JSONObject data = new JSONObject();
        if (!this.validate()) {
            callback.done(null, new CloudException("Can't create queue without a name"));
            return;
        }
        try {
            data.put("key", CloudApp.getAppKey());
            data.put("document", this.document);
            String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + "/" + this.getAttribute("name") + "/create";
            CBResponse response = CBParser.callJson(url, "POST", data);
            if (response.getStatusCode() == 200) {
                JSONObject body;
                this.document = body = new JSONObject(response.getResponseBody());
                callback.done(this, null);
            } else {
                callback.done(null, new CloudException(response.getStatusMessage()));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public static void getAll(CloudQueueArrayCallback callback) {
        JSONObject data = new JSONObject();
        try {
            data.put("key", CloudApp.getAppKey());
            String url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/';
            CBResponse response = CBParser.callJson(url, "POST", data);
            String body = response.getResponseBody();
            if (body == null || "".equals(body)) {
                callback.done(null, new CloudException("No queues found"));
                return;
            }
            if (response.getStatusCode() == 200) {
                JSONArray arr = new JSONArray(response.getResponseBody());
                CloudQueue[] queues = new CloudQueue[arr.length()];
                for (int i = 0; i < arr.length(); ++i) {
                    JSONObject obj = arr.getJSONObject(i);
                    CloudQueue queue = new CloudQueue(null, null);
                    queue.document = obj;
                    queue.thisObj = queue;
                    queues[i] = queue;
                }
                callback.done(queues, null);
            } else {
                callback.done(null, new CloudException(response.getStatusMessage()));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void updateMessage(QueueMessage[] message, CloudQueueMessageCallback callback) {
        block12: {
            this.messages.clear();
            try {
                QueueMessage[] mss;
                if (message == null) {
                    throw new CloudException("Cannot push null into queue");
                }
                for (QueueMessage ms : mss = message) {
                    if (ms.getId() == null) {
                        callback.done(null, new CloudException("The message cannot be updated because it has never been saved"));
                        return;
                    }
                    this.messages.add(ms);
                }
                JSONArray arr = new JSONArray();
                String url = null;
                JSONObject data = new JSONObject();
                for (QueueMessage ms : this.messages) {
                    arr.put(ms.getDocument());
                }
                this.document.put("messages", arr);
                data.put("document", this.document);
                data.put("key", CloudApp.getAppKey());
                url = CloudApp.getApiUrl() + "/queue/" + CloudApp.getAppId() + '/' + this.document.get("name") + "/message";
                this.thisObj = this;
                boolean valid = this.validate();
                if (valid) {
                    CBResponse response = CBParser.callJson(url, "PUT", data);
                    if (response.getStatusCode() == 200) {
                        JSONArray body = null;
                        try {
                            body = new JSONArray(response.getResponseBody());
                        }
                        catch (JSONException e) {
                            body = new JSONArray();
                            body.put(new JSONObject(response.getResponseBody()));
                        }
                        QueueMessage[] msgArr = new QueueMessage[body.length()];
                        for (int i = 0; i < body.length(); ++i) {
                            JSONObject obj = body.getJSONObject(i);
                            QueueMessage msg = new QueueMessage();
                            msg.setDocument(obj);
                            msgArr[i] = msg;
                        }
                        callback.done(msgArr, null);
                        break block12;
                    }
                    callback.done(null, new CloudException(response.getStatusMessage()));
                    break block12;
                }
                callback.done(null, new CloudException("Object Validation Failure"));
            }
            catch (JSONException e) {
                callback.done(null, new CloudException(e.getMessage()));
            }
            catch (CloudException e) {
                callback.done(null, e);
            }
        }
    }

    public static void main(String[] args) {
        CloudApp.init("bengi123", "mLiJB380x9fhPRCjCGmGRg==");
        CloudQueue q = new CloudQueue("egigi", null);
        q.create(new CloudQueueCallback(){

            @Override
            public void done(CloudQueue q, CloudException e) {
            }
        });
    }
}

