/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.core.reflection;

import io.contextmap.annotations.ContextApiProperty;
import io.contextmap.core.reflection.PrimitiveChecker;
import io.contextmap.core.reflection.Property;
import io.contextmap.core.reflection.SwaggerV2;
import io.contextmap.core.reflection.SwaggerV3;
import io.contextmap.core.reflection.TypeToReadableStringConverter;
import io.contextmap.model.json.ScannedAnonymousObjectNode;
import io.contextmap.model.json.ScannedArrayNode;
import io.contextmap.model.json.ScannedBooleanNode;
import io.contextmap.model.json.ScannedJsonNode;
import io.contextmap.model.json.ScannedNullNode;
import io.contextmap.model.json.ScannedNumberNode;
import io.contextmap.model.json.ScannedObjectNode;
import io.contextmap.model.json.ScannedStringNode;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ObjectToJsonConverter {
    private final ObjectToJsonReflection reflectionService;
    private final ObjectToJsonLogger logger;
    private static Map<Class, ScannedJsonNode> cacheOfProcessedSerializedTypes = new HashMap<Class, ScannedJsonNode>();
    private static Map<Class, ScannedJsonNode> cacheOfProcessedDeserializedTypes = new HashMap<Class, ScannedJsonNode>();

    public ObjectToJsonConverter(ObjectToJsonReflection objectToJsonReflection, ObjectToJsonLogger logger) {
        this.reflectionService = objectToJsonReflection;
        this.logger = logger;
    }

    public ScannedJsonNode serializedJson(Class<?> type, Property property, List<Class<?>> typesToExcludeToPreventLoop) {
        Parameters parameters = new Parameters();
        parameters.type = type;
        parameters.property = property;
        parameters.typesToExcludeToPreventLoop = typesToExcludeToPreventLoop;
        parameters.shouldIncludeProperty = prop -> prop.getField() != null || prop.getGetterMethod() != null;
        parameters.cacheOfTypes = cacheOfProcessedSerializedTypes;
        parameters.methodFromPropertyFunction = Property::getGetterMethod;
        parameters.genericTypeFromPropertyFunction = prop -> {
            Type genericType = null;
            if (prop != null && prop.getGetterMethod() != null) {
                genericType = prop.getGetterMethod().getGenericReturnType();
            } else if (prop != null && prop.getField() != null) {
                genericType = prop.getField().getGenericType();
            }
            return genericType;
        };
        return this.toJson(parameters);
    }

    public ScannedJsonNode deserializedJson(Class<?> type, Property property, List<Class<?>> typesToExcludeToPreventLoop) {
        Parameters parameters = new Parameters();
        parameters.type = type;
        parameters.property = property;
        parameters.typesToExcludeToPreventLoop = typesToExcludeToPreventLoop;
        parameters.shouldIncludeProperty = prop -> prop.getField() != null || prop.getSetterMethod() != null || prop.getGetterMethod() != null;
        parameters.cacheOfTypes = cacheOfProcessedDeserializedTypes;
        parameters.methodFromPropertyFunction = prop -> prop.getGetterMethod() != null ? prop.getGetterMethod() : prop.getSetterMethod();
        parameters.genericTypeFromPropertyFunction = prop -> {
            Type genericType = null;
            if (prop != null && prop.getSetterMethod() != null && prop.getSetterMethod().getGenericParameterTypes().length > 0) {
                genericType = prop.getSetterMethod().getGenericParameterTypes()[0];
            } else if (prop != null && prop.getField() != null) {
                genericType = prop.getField().getGenericType();
            }
            return genericType;
        };
        return this.toJson(parameters);
    }

    private ScannedJsonNode toJson(Parameters parameters) {
        this.logger.debug("Serialize type " + parameters.type);
        if (this.isVoidType(parameters.type)) {
            return new ScannedNullNode();
        }
        if (parameters.typesToExcludeToPreventLoop.contains(parameters.type)) {
            return new ScannedAnonymousObjectNode();
        }
        if (PrimitiveChecker.isPrimitive(parameters.type)) {
            return this.getPrimitiveJsonType(parameters.type);
        }
        if (this.isCollection(parameters.type)) {
            Type genericType = parameters.genericTypeFromPropertyFunction.apply(parameters.property);
            return this.getCollectionJsonType(parameters.type, genericType, parameters.typesToExcludeToPreventLoop, parameters);
        }
        if (this.isObject(parameters.type)) {
            String dataType = TypeToReadableStringConverter.convertObjectTypeToDataTypeString(parameters);
            ScannedAnonymousObjectNode objectNode = new ScannedAnonymousObjectNode();
            objectNode.setDataType(dataType);
            return objectNode;
        }
        if (this.isHttpEntity(parameters.type) || this.isDeferredResult(parameters.type)) {
            Type genericType = parameters.genericTypeFromPropertyFunction.apply(parameters.property);
            return this.getHttpEntityJsonType(parameters.type, genericType, parameters.typesToExcludeToPreventLoop, parameters);
        }
        if (parameters.cacheOfTypes.containsKey(parameters.type)) {
            this.logger.debug("Reusing cached result for type " + parameters.type.getSimpleName());
            return parameters.cacheOfTypes.get(parameters.type);
        }
        ArrayList typesToExcludeForChildren = new ArrayList(parameters.typesToExcludeToPreventLoop);
        TypeVariable<Class<?>>[] typeParams = parameters.type.getTypeParameters();
        if (typeParams.length == 0) {
            typesToExcludeForChildren.add(parameters.type);
        }
        List<Property> properties = this.listProperties(parameters.type);
        this.filterIgnorableProperties(properties, parameters.methodFromPropertyFunction, parameters.shouldIncludeProperty);
        this.correctlyNameProperties(properties, parameters.methodFromPropertyFunction);
        ScannedObjectNode result = new ScannedObjectNode();
        result.setDataType(parameters.type.getSimpleName());
        properties.stream().sorted(Comparator.comparing(Property::getName)).forEach(prop -> {
            this.logger.debug("Property " + prop.getName() + " -> " + prop.getPropertyType().getSimpleName());
            ScannedJsonNode propertyJsonNode = this.toJson(parameters.deriveParameters(prop.getPropertyType(), (Property)prop, typesToExcludeForChildren));
            result.addProperty(prop.getName(), propertyJsonNode);
            Optional<ContextApiProperty> optCtxApiPropAnnotation = this.checkForContextApiPropertyAnnotation((Property)prop, parameters.methodFromPropertyFunction);
            optCtxApiPropAnnotation.ifPresent(apiPropertyAnnotation -> {
                this.logger.debug("Applying ContextApiProperty documentation");
                if (!apiPropertyAnnotation.dataType().isEmpty()) {
                    propertyJsonNode.setDataType(apiPropertyAnnotation.dataType());
                }
                if (!apiPropertyAnnotation.description().isEmpty()) {
                    propertyJsonNode.setDescription(apiPropertyAnnotation.description());
                }
                if (!apiPropertyAnnotation.example().isEmpty()) {
                    propertyJsonNode.setExample(apiPropertyAnnotation.example());
                }
            });
            boolean isEnriched = optCtxApiPropAnnotation.isPresent();
            if (!isEnriched) {
                SwaggerV3 swaggerV3 = new SwaggerV3(this.reflectionService);
                isEnriched = swaggerV3.enrichWithSchemaAnnotationIfAvailable((Property)prop, parameters.methodFromPropertyFunction, propertyJsonNode);
            }
            if (!isEnriched) {
                // empty if block
            }
            if (!isEnriched) {
                SwaggerV2 swaggerV2 = new SwaggerV2(this.reflectionService);
                isEnriched = swaggerV2.enrichWithApiModelPropertyAnnotationIfAvailable((Property)prop, parameters.methodFromPropertyFunction, propertyJsonNode);
            }
        });
        Type genericType = parameters.genericTypeFromPropertyFunction.apply(parameters.property);
        if (!(genericType instanceof ParameterizedType) && typeParams.length <= 0) {
            parameters.cacheOfTypes.put(parameters.type, result);
        }
        return result;
    }

    private Optional<ContextApiProperty> checkForContextApiPropertyAnnotation(Property property, Function<Property, Method> methodToCheck) {
        Optional<Annotation> annotation;
        Method method = methodToCheck.apply(property);
        if (method != null && (annotation = this.reflectionService.getAnnotation(method, ContextApiProperty.class.getName())).isPresent()) {
            return annotation;
        }
        if (property.getField() != null && (annotation = this.reflectionService.getAnnotation(property.getField(), ContextApiProperty.class.getName())).isPresent()) {
            return annotation;
        }
        return Optional.empty();
    }

    private void filterIgnorableProperties(List<Property> properties, Function<Property, Method> methodToCheck, Predicate<Property> shouldInclude) {
        Iterator<Property> iter = properties.iterator();
        while (iter.hasNext()) {
            Property property = iter.next();
            Method method = methodToCheck.apply(property);
            boolean shouldBeIgnored = false;
            if (!shouldInclude.test(property)) {
                shouldBeIgnored = true;
            }
            if (!shouldBeIgnored && method != null) {
                boolean bl = shouldBeIgnored = this.reflectionService.getAnnotation(method, "com.fasterxml.jackson.annotation.JsonIgnore").map(this::getValueFromAnnotation).orElse(false) != false || this.reflectionService.getAnnotation(method, "java.beans.Transient").map(this::getValueFromAnnotation).orElse(false) != false;
            }
            if (!shouldBeIgnored && property.getField() != null) {
                int fieldModifiers = property.getField().getModifiers();
                boolean bl = shouldBeIgnored = Modifier.isStatic(fieldModifiers) || Modifier.isTransient(fieldModifiers) || this.reflectionService.getAnnotation(property.getField(), "com.fasterxml.jackson.annotation.JsonIgnore").map(this::getValueFromAnnotation).orElse(false) != false;
            }
            if (!shouldBeIgnored) continue;
            iter.remove();
        }
    }

    private void correctlyNameProperties(List<Property> properties, Function<Property, Method> methodToCheck) {
        String jsonPropertyAnnotationName = "com.fasterxml.jackson.annotation.JsonProperty";
        properties.forEach(property -> {
            Method method = (Method)methodToCheck.apply((Property)property);
            String customName = null;
            if (method != null) {
                customName = this.reflectionService.getAnnotation(method, jsonPropertyAnnotationName).flatMap(annotation -> this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "value")).map(obj -> (String)obj).orElse("");
            }
            if ((customName == null || customName.isEmpty()) && property.getField() != null) {
                customName = this.reflectionService.getAnnotation(property.getField(), jsonPropertyAnnotationName).flatMap(annotation -> this.reflectionService.getAnnotationFieldValue((Annotation)annotation, "value")).map(obj -> (String)obj).orElse("");
            }
            if (customName != null && !customName.isEmpty()) {
                property.setCustomName(customName);
            }
        });
    }

    private List<Property> listProperties(Class<?> type) {
        Method[] methods = type.getMethods();
        HashMap<String, Method> getters = new HashMap<String, Method>();
        HashMap<String, Method> setters = new HashMap<String, Method>();
        for (Method i : methods) {
            String name;
            if (i.getName().equals("getClass")) continue;
            if (i.getName().startsWith("get") && i.getName().length() > 3 && i.getParameterCount() == 0 && i.getReturnType() != Void.TYPE) {
                name = Character.toLowerCase(i.getName().charAt(3)) + i.getName().substring(4);
                getters.put(name, i);
                continue;
            }
            if (i.getName().startsWith("is") && i.getName().length() > 3 && i.getParameterCount() == 0 && i.getReturnType() == Boolean.TYPE) {
                name = Character.toLowerCase(i.getName().charAt(2)) + i.getName().substring(3);
                getters.put(name, i);
                continue;
            }
            if (!i.getName().startsWith("set") || i.getName().length() <= 3 || i.getParameterCount() != 1) continue;
            name = Character.toLowerCase(i.getName().charAt(3)) + i.getName().substring(4);
            setters.put(name, i);
        }
        Map<String, Field> fields = Arrays.stream(type.getDeclaredFields()).collect(Collectors.toMap(Field::getName, f -> f));
        ArrayList<Property> properties = new ArrayList<Property>();
        HashSet names = new HashSet(getters.keySet());
        names.addAll(setters.keySet());
        for (String name : names) {
            Class<?> st;
            Method get = (Method)getters.get(name);
            Method set = (Method)setters.get(name);
            Field field2 = fields.get(name);
            if (get == null) {
                properties.add(new Property(name, get, set, field2, set.getParameterTypes()[0]));
                continue;
            }
            if (set == null) {
                properties.add(new Property(name, get, set, field2, get.getReturnType()));
                continue;
            }
            Class<?> gt = get.getReturnType();
            if (gt == (st = set.getParameterTypes()[0])) {
                properties.add(new Property(name, get, set, field2, gt));
                continue;
            }
            if (gt.isAssignableFrom(st)) {
                properties.add(new Property(name, get, set, field2, gt));
                continue;
            }
            if (!st.isAssignableFrom(gt)) continue;
            properties.add(new Property(name, get, set, field2, st));
        }
        if (type.getSuperclass() != null && type.getSuperclass().getName().equals("java.lang.Record")) {
            Arrays.stream(type.getDeclaredFields()).filter(field -> !names.contains(field.getName())).forEach(field -> properties.add(new Property(field.getName(), null, null, (Field)field, field.getType())));
        } else {
            Arrays.stream(type.getDeclaredFields()).filter(field -> !names.contains(field.getName())).filter(field -> Modifier.isPublic(field.getModifiers())).forEach(field -> properties.add(new Property(field.getName(), null, null, (Field)field, field.getType())));
        }
        return properties;
    }

    private boolean isObject(Class<?> type) {
        return type.getName().equals(Object.class.getName()) || Map.class.isAssignableFrom(type);
    }

    private boolean isCollection(Class<?> type) {
        return Collection.class.isAssignableFrom(type) || type.isArray() || type.getName().equals("reactor.core.publisher.Flux");
    }

    private boolean isHttpEntity(Class<?> type) {
        for (Class<?> aClass = type; aClass != null; aClass = aClass.getSuperclass()) {
            if (!aClass.getName().equals("org.springframework.http.HttpEntity")) continue;
            return true;
        }
        return false;
    }

    private boolean isDeferredResult(Class<?> type) {
        for (Class<?> aClass = type; aClass != null; aClass = aClass.getSuperclass()) {
            if (!aClass.getName().equals("org.springframework.web.context.request.async.DeferredResult") && !aClass.getName().equals("org.springframework.web.context.request.async.WebAsyncTask") && !aClass.getName().equals("java.util.concurrent.Callable") && !aClass.getName().equals("reactor.core.publisher.Mono") && !aClass.getName().equals("reactor.core.publisher.Flux") && !aClass.getName().equals("java.util.concurrent.CompletableFuture")) continue;
            return true;
        }
        return false;
    }

    private ScannedJsonNode getHttpEntityJsonType(Class<?> type, Type genericType, List<Class<?>> typesToExcludeToPreventLoop, Parameters parameters) {
        if (genericType instanceof ParameterizedType) {
            return this.getParameterizedTypeJsonType((ParameterizedType)genericType, typesToExcludeToPreventLoop, parameters);
        }
        return new ScannedAnonymousObjectNode();
    }

    private ScannedJsonNode getCollectionJsonType(Class<?> type, Type genericType, List<Class<?>> typesToExcludeToPreventLoop, Parameters parameters) {
        if (type.isArray()) {
            ScannedJsonNode elementType = this.toJson(parameters.deriveParameters(type.getComponentType(), null, typesToExcludeToPreventLoop));
            return new ScannedArrayNode(elementType);
        }
        if (genericType instanceof ParameterizedType) {
            ScannedJsonNode elementType = this.getParameterizedTypeJsonType((ParameterizedType)genericType, typesToExcludeToPreventLoop, parameters);
            return new ScannedArrayNode(elementType);
        }
        this.logger.warn("Unmappable collection type will be mapped to object-array: " + type.getName());
        return new ScannedArrayNode(new ScannedAnonymousObjectNode());
    }

    private ScannedJsonNode getParameterizedTypeJsonType(ParameterizedType genericType, List<Class<?>> typesToExcludeToPreventLoop, Parameters parameters) {
        Type[] typeArguments = genericType.getActualTypeArguments();
        if (typeArguments.length > 0) {
            if (typeArguments[0] instanceof ParameterizedType) {
                ParameterizedType paramType = (ParameterizedType)typeArguments[0];
                if (this.isCollection((Class)paramType.getRawType())) {
                    return this.getCollectionJsonType((Class)paramType.getRawType(), paramType, typesToExcludeToPreventLoop, parameters);
                }
                if (paramType.getRawType() instanceof Class) {
                    Property property = new Property("", null, null, null, null);
                    Parameters derivedParams = parameters.deriveParameters((Class)paramType.getRawType(), property, typesToExcludeToPreventLoop);
                    Function<Property, Type> fallbackDefault = derivedParams.genericTypeFromPropertyFunction;
                    derivedParams.genericTypeFromPropertyFunction = prop -> {
                        if (prop == property) {
                            return paramType;
                        }
                        return (Type)fallbackDefault.apply((Property)prop);
                    };
                    return this.toJson(derivedParams);
                }
                this.logger.warn("Unable to get nested parameterizedtype, mapping to object: " + paramType.getTypeName());
                return new ScannedAnonymousObjectNode();
            }
            if (typeArguments[0] instanceof WildcardType) {
                return new ScannedAnonymousObjectNode();
            }
            if (typeArguments[0] instanceof Class) {
                return this.toJson(parameters.deriveParameters((Class)typeArguments[0], null, typesToExcludeToPreventLoop));
            }
            if (typeArguments[0] instanceof TypeVariable) {
                if (parameters.parentParameters != null) {
                    Type parentTypeWithTypeVar = parameters.parentParameters.genericTypeFromPropertyFunction.apply(parameters.parentParameters.property);
                    if (parentTypeWithTypeVar instanceof ParameterizedType) {
                        return this.getParameterizedTypeJsonType((ParameterizedType)parentTypeWithTypeVar, typesToExcludeToPreventLoop, parameters);
                    }
                    if (parentTypeWithTypeVar instanceof Class) {
                        return this.toJson(parameters.deriveParameters((Class)parentTypeWithTypeVar, null, typesToExcludeToPreventLoop));
                    }
                }
                this.logger.warn("Unable to get type variable, will map to object: " + parameters.property);
                return new ScannedAnonymousObjectNode();
            }
            this.logger.warn("Unsupported parameterizedtype for " + typeArguments[0].getTypeName());
            return new ScannedAnonymousObjectNode();
        }
        this.logger.warn("Unable to get actual type parameter for " + genericType.getTypeName());
        return new ScannedAnonymousObjectNode();
    }

    private ScannedJsonNode getPrimitiveJsonType(Class<?> type) {
        String typeName = type.getName();
        if (PrimitiveChecker.isStringPrimitive(typeName)) {
            ScannedStringNode node = new ScannedStringNode();
            node.setDataType(type.getSimpleName());
            return node;
        }
        if (PrimitiveChecker.isNumberPrimitive(typeName)) {
            ScannedNumberNode node = new ScannedNumberNode();
            node.setDataType(type.getSimpleName());
            return node;
        }
        if (PrimitiveChecker.isBooleanPrimitive(typeName)) {
            ScannedBooleanNode node = new ScannedBooleanNode();
            node.setDataType(type.getSimpleName());
            return node;
        }
        if (type.isEnum()) {
            ScannedStringNode node = new ScannedStringNode();
            node.setDataType(type.getSimpleName());
            ?[] enumValues = type.getEnumConstants();
            if (enumValues != null) {
                int maxAmount = 8;
                String examples = Arrays.stream(enumValues).map(o -> o.toString()).limit(maxAmount).collect(Collectors.joining(", "));
                if (enumValues.length > maxAmount) {
                    int remainder = enumValues.length - maxAmount;
                    examples = examples + ", ... (+" + remainder + " more)";
                }
                node.setExample(examples);
            }
            return node;
        }
        this.logger.warn("Unknown primitive type will be mapped as string: " + type.getName());
        ScannedStringNode node = new ScannedStringNode();
        node.setDataType(type.getSimpleName());
        return node;
    }

    private boolean getValueFromAnnotation(Annotation annotation) {
        return this.reflectionService.getAnnotationFieldValue(annotation, "value").map(o -> (Boolean)o).orElse(false);
    }

    private boolean isVoidType(Class<?> type) {
        return type == null || Void.TYPE.equals(type) || Void.class.equals(type);
    }

    public static interface ObjectToJsonReflection {
        public Optional<Object> getAnnotationFieldValue(Annotation var1, String var2);

        public Optional<Annotation> getAnnotation(Method var1, String var2);

        public Optional<Annotation> getAnnotation(Field var1, String var2);
    }

    public static interface ObjectToJsonLogger {
        public void debug(CharSequence var1);

        public void info(CharSequence var1);

        public void warn(CharSequence var1);
    }

    public static class Parameters {
        public Parameters parentParameters;
        public Class<?> type;
        public Property property;
        public List<Class<?>> typesToExcludeToPreventLoop;
        public Function<Property, Method> methodFromPropertyFunction;
        public Function<Property, Type> genericTypeFromPropertyFunction;
        public Predicate<Property> shouldIncludeProperty;
        public Map<Class, ScannedJsonNode> cacheOfTypes;

        Parameters deriveParameters(Class<?> childType, Property childProperty, List<Class<?>> childTypesToExclude) {
            Parameters derived = new Parameters();
            derived.parentParameters = this;
            derived.type = childType;
            derived.property = childProperty;
            derived.typesToExcludeToPreventLoop = childTypesToExclude;
            derived.shouldIncludeProperty = this.shouldIncludeProperty;
            derived.methodFromPropertyFunction = this.methodFromPropertyFunction;
            derived.genericTypeFromPropertyFunction = this.genericTypeFromPropertyFunction;
            derived.cacheOfTypes = this.cacheOfTypes;
            return derived;
        }
    }
}

