/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.core.reflection;

import io.contextmap.core.reflection.ObjectToJsonConverter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;

public class TypeToReadableStringConverter {
    public static String convertObjectTypeToDataTypeString(ObjectToJsonConverter.Parameters parameters) {
        if (Map.class.isAssignableFrom(parameters.type)) {
            try {
                Type genericType = parameters.genericTypeFromPropertyFunction.apply(parameters.property);
                return TypeToReadableStringConverter.typeToString(genericType);
            }
            catch (Exception e) {
                return parameters.type.getSimpleName();
            }
        }
        return parameters.type.getSimpleName();
    }

    private static String typeToString(Type genericType) {
        if (genericType instanceof ParameterizedType) {
            String rawTypeName = TypeToReadableStringConverter.getRawTypeName((ParameterizedType)genericType);
            StringBuilder str = new StringBuilder(rawTypeName);
            str.append("<");
            Type[] actualTypes = ((ParameterizedType)genericType).getActualTypeArguments();
            for (int i = 0; i < actualTypes.length; ++i) {
                Type actualType = actualTypes[i];
                if (actualType instanceof ParameterizedType) {
                    String actualTypeAsString = TypeToReadableStringConverter.typeToString(actualType);
                    str.append(actualTypeAsString);
                } else if (actualType instanceof Class) {
                    str.append(((Class)actualType).getSimpleName());
                } else {
                    str.append(actualType.getTypeName());
                }
                if (i + 1 >= actualTypes.length) continue;
                str.append(",");
            }
            str.append(">");
            return str.toString();
        }
        return "";
    }

    private static String getRawTypeName(ParameterizedType type) {
        Type rawType = type.getRawType();
        if (rawType instanceof Class) {
            return ((Class)rawType).getSimpleName();
        }
        return rawType.getTypeName();
    }
}

