/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.core.reflection;

import io.contextmap.model.json.ScannedArrayNode;
import io.contextmap.model.json.ScannedJsonNode;
import io.contextmap.model.json.ScannedObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ScannedJsonNodeMerger {
    private static final String DELIMITER = "$CTXMP$";
    public static final String COUNT_KEY = "count";
    public static final String TOTAL_KEY = "total";
    private ScannedJsonNode current;
    private int nrOfMergedObjects = 0;

    public ScannedJsonNode getMergeResult() {
        this.includeTotalInCurrent();
        return this.current;
    }

    private void includeTotalInCurrent() {
        if (this.current == null) {
            return;
        }
        this.current.getMetaProperties().put(TOTAL_KEY, String.valueOf(this.nrOfMergedObjects));
        this.current.getMetaProperties().put(COUNT_KEY, String.valueOf(this.nrOfMergedObjects));
    }

    public void merge(ScannedJsonNode node) {
        if (node == null) {
            return;
        }
        ScannedJsonNode safeNode = ScannedJsonNodeMerger.keysWithTypesToPreventCollision(node);
        if (this.current == null) {
            this.current = safeNode;
        } else {
            ScannedJsonNodeMerger.combine(this.current, safeNode);
        }
        ++this.nrOfMergedObjects;
    }

    private static ScannedJsonNode keysWithTypesToPreventCollision(ScannedJsonNode node) {
        if (!(node instanceof ScannedObjectNode)) {
            ScannedArrayNode arrayNode;
            ScannedJsonNodeMerger.incrementOccurrenceCount(node);
            if (node instanceof ScannedArrayNode && (arrayNode = (ScannedArrayNode)node).getElement() != null) {
                ScannedJsonNode safeElement = ScannedJsonNodeMerger.keysWithTypesToPreventCollision(arrayNode.getElement());
                arrayNode.setElement(safeElement);
            }
            return node;
        }
        ScannedObjectNode safeNode = new ScannedObjectNode();
        safeNode.setDataType(node.getDataType());
        ScannedJsonNodeMerger.incrementOccurrenceCount(safeNode);
        List<ScannedObjectNode.ScannedObjectNodeProperty> properties = ((ScannedObjectNode)node).getProperties();
        if (properties == null) {
            return safeNode;
        }
        properties.forEach(prop -> {
            String valueType;
            ScannedJsonNode valueNode = ScannedJsonNodeMerger.keysWithTypesToPreventCollision(prop.getValue());
            if (valueNode instanceof ScannedArrayNode) {
                ScannedArrayNode valueArrayNode = (ScannedArrayNode)valueNode;
                valueType = String.valueOf(valueNode.getDataType()) + String.valueOf(valueArrayNode.getElement().getDataType());
            } else {
                valueType = String.valueOf(valueNode.getDataType());
            }
            safeNode.addProperty(valueType + DELIMITER + prop.getKey(), valueNode);
        });
        return safeNode;
    }

    private static void combine(ScannedJsonNode existing, ScannedJsonNode other) {
        ScannedJsonNodeMerger.incrementOccurrenceCount(existing);
        if (existing instanceof ScannedObjectNode && other instanceof ScannedObjectNode) {
            ScannedObjectNode existingNode = (ScannedObjectNode)existing;
            ScannedObjectNode otherNode = (ScannedObjectNode)other;
            for (ScannedObjectNode.ScannedObjectNodeProperty otherProperty : otherNode.getProperties()) {
                ScannedJsonNodeMerger.incrementOccurrenceCount(existingNode, otherProperty);
            }
        } else if (existing instanceof ScannedArrayNode && other instanceof ScannedArrayNode) {
            ScannedArrayNode existingArray = (ScannedArrayNode)existing;
            ScannedArrayNode otherArray = (ScannedArrayNode)other;
            if (existingArray.getElement() != null && otherArray.getElement() != null) {
                ScannedJsonNodeMerger.combine(existingArray.getElement(), otherArray.getElement());
            }
        }
    }

    private static void incrementOccurrenceCount(ScannedObjectNode node, ScannedObjectNode.ScannedObjectNodeProperty property) {
        if (node.contains(property.getKey())) {
            ScannedObjectNode.ScannedObjectNodeProperty propertyToIncrement = node.getProperty(property.getKey());
            if (propertyToIncrement.getValue() != null) {
                ScannedJsonNodeMerger.combine(propertyToIncrement.getValue(), property.getValue());
            }
            return;
        }
        node.addProperty(property.getKey(), property.getValue());
    }

    private static void incrementOccurrenceCount(ScannedJsonNode node) {
        Map<String, String> meta;
        if (node.getMetaProperties() == null) {
            node.setMetaProperties(new HashMap<String, String>());
        }
        if ((meta = node.getMetaProperties()).containsKey(COUNT_KEY)) {
            int counter = Integer.parseInt(meta.get(COUNT_KEY));
            meta.put(COUNT_KEY, String.valueOf(counter + 1));
        } else {
            meta.put(COUNT_KEY, "1");
        }
    }
}

