/*
 * Decompiled with CFR 0.152.
 */
package io.contextmap.spring.runtime.scanner.storage.mongodb;

import io.contextmap.core.reflection.PrimitiveChecker;
import io.contextmap.model.json.ScannedAnonymousObjectNode;
import io.contextmap.model.json.ScannedArrayNode;
import io.contextmap.model.json.ScannedBooleanNode;
import io.contextmap.model.json.ScannedJsonNode;
import io.contextmap.model.json.ScannedNullNode;
import io.contextmap.model.json.ScannedNumberNode;
import io.contextmap.model.json.ScannedObjectNode;
import io.contextmap.model.json.ScannedStringNode;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.ObjectId;

public class DocumentToJsonConverter {
    public static final int MAX_JSON_PROPERTY_DEPTH = 5;

    public static ScannedJsonNode toScannedJsonNode(Document document) {
        return DocumentToJsonConverter.convertDocumentToScannedJsonNode(document, 0);
    }

    private static ScannedJsonNode convertDocumentToScannedJsonNode(Document document, int depth) {
        if (depth > 5) {
            ScannedAnonymousObjectNode node = new ScannedAnonymousObjectNode();
            node.setDataType("<too deep>");
            return node;
        }
        ScannedObjectNode jsonNode = new ScannedObjectNode();
        jsonNode.setDataType("Object");
        for (Map.Entry entry : document.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value instanceof Document) {
                jsonNode.addProperty(key, DocumentToJsonConverter.convertDocumentToScannedJsonNode((Document)value, depth + 1));
                continue;
            }
            jsonNode.addProperty(key, DocumentToJsonConverter.convertNonDocumentValueToScannedJsonNode(value, depth));
        }
        return jsonNode;
    }

    private static ScannedJsonNode convertNonDocumentValueToScannedJsonNode(Object value, int depth) {
        if (value == null) {
            return new ScannedNullNode();
        }
        Class<?> valueType = value.getClass();
        if (PrimitiveChecker.isPrimitive(valueType)) {
            return DocumentToJsonConverter.getPrimitiveJsonType(valueType);
        }
        if (value instanceof ObjectId) {
            ScannedAnonymousObjectNode node = new ScannedAnonymousObjectNode();
            node.setDataType("ObjectId");
            return node;
        }
        if (value instanceof Binary) {
            Binary binary = (Binary)value;
            ScannedAnonymousObjectNode node = new ScannedAnonymousObjectNode();
            if (binary.getType() == 0) {
                node.setDataType("Binary (generic)");
            } else if (binary.getType() == 1) {
                node.setDataType("Binary (function)");
            } else if (binary.getType() == 2) {
                node.setDataType("Binary (old)");
            } else if (binary.getType() == 3) {
                node.setDataType("Binary (UUID old)");
            } else if (binary.getType() == 4) {
                node.setDataType("Binary (UUID)");
            } else if (binary.getType() == 5) {
                node.setDataType("Binary (MD5)");
            } else if (binary.getType() == 6) {
                node.setDataType("Binary (BSON)");
            } else if (binary.getType() == 7) {
                node.setDataType("Binary (time)");
            } else {
                node.setDataType("Binary (custom)");
            }
            return node;
        }
        if (value instanceof Collection) {
            ScannedArrayNode node = new ScannedArrayNode();
            node.setDataType("Array");
            Collection collection = (Collection)value;
            if (!collection.isEmpty()) {
                Object firstElement = collection.iterator().next();
                if (firstElement instanceof Document) {
                    node.setElement(DocumentToJsonConverter.convertDocumentToScannedJsonNode((Document)firstElement, depth + 1));
                } else {
                    node.setElement(DocumentToJsonConverter.convertNonDocumentValueToScannedJsonNode(firstElement, depth + 1));
                }
            }
            return node;
        }
        return new ScannedAnonymousObjectNode();
    }

    private static ScannedJsonNode getPrimitiveJsonType(Class<?> type) {
        String typeName = type.getName();
        if (PrimitiveChecker.isStringPrimitive((String)typeName)) {
            ScannedStringNode node = new ScannedStringNode();
            node.setDataType(type.getSimpleName());
            return node;
        }
        if (PrimitiveChecker.isNumberPrimitive((String)typeName)) {
            ScannedNumberNode node = new ScannedNumberNode();
            node.setDataType(type.getSimpleName());
            return node;
        }
        if (PrimitiveChecker.isBooleanPrimitive((String)typeName)) {
            ScannedBooleanNode node = new ScannedBooleanNode();
            node.setDataType(type.getSimpleName());
            return node;
        }
        if (type.isEnum()) {
            ScannedStringNode node = new ScannedStringNode();
            node.setDataType(type.getSimpleName());
            ?[] enumValues = type.getEnumConstants();
            if (enumValues != null) {
                int maxAmount = 8;
                String examples = Arrays.stream(enumValues).map(o -> o.toString()).limit(maxAmount).collect(Collectors.joining(", "));
                if (enumValues.length > maxAmount) {
                    int remainder = enumValues.length - maxAmount;
                    examples = examples + ", ... (+" + remainder + " more)";
                }
                node.setExample(examples);
            }
            return node;
        }
        ScannedStringNode node = new ScannedStringNode();
        node.setDataType(type.getSimpleName());
        return node;
    }
}

