/*
 * Decompiled with CFR 0.152.
 */
package cronapi;

import cronapi.AppConfig;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import java.util.Date;

public class TokenUtils {
    private static String secret = AppConfig.token();
    public static final String AUTH_HEADER_NAME = "X-AUTH-TOKEN";

    public static String getUsernameFromToken(String token) {
        String username;
        try {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            username = claims.getSubject();
        }
        catch (Exception e) {
            username = null;
        }
        return username;
    }

    public static Claims getClaimsFromToken(String token) {
        Claims claims;
        try {
            claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token).getBody();
        }
        catch (Exception e) {
            claims = null;
        }
        return claims;
    }

    public static String addClaimToToken(String token, String key, Object value) {
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token).getBody();
            claims.put((Object)key, value);
            return Jwts.builder().setClaims(claims).setExpiration(claims.getExpiration()).signWith(SignatureAlgorithm.HS512, secret).compact();
        }
        catch (Exception e) {
            throw new RuntimeException("Token is not in the header");
        }
    }

    public static String setExpiration(String token, Date expiration) {
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(secret).parseClaimsJws(token).getBody();
            return Jwts.builder().setClaims(claims).setExpiration(expiration).signWith(SignatureAlgorithm.HS512, secret).compact();
        }
        catch (Exception e) {
            throw new RuntimeException("Token is not in the header");
        }
    }
}

