/*
 * Decompiled with CFR 0.152.
 */
package cronapi.jdbc;

import cronapi.Var;
import cronapi.jdbc.DatabaseMetadata;
import cronapi.jdbc.SQLAnsiMetadata;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Fetch;
import net.sf.jsqlparser.statement.select.Offset;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.apache.olingo.odata2.jpa.processor.core.ExpressionProvider;
import org.apache.olingo.odata2.jpa.processor.core.ExpressionProviderFactory;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.SQLServerDictionary;
import org.apache.openjpa.lib.conf.Configuration;

public class MSSQLMetadata
extends SQLAnsiMetadata
implements DatabaseMetadata {
    private static final SQLServerDictionary DICTIONARY = new SQLServerDictionary();

    @Override
    public String limit(Statement statement, Connection connection, Integer top, Integer skip) throws Exception {
        PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
        Integer version = Integer.valueOf(connection.getMetaData().getDatabaseProductVersion().split("\\.")[0]);
        if (version >= 11) {
            if (select.getOrderByElements() == null || select.getOrderByElements().isEmpty()) {
                select.setOrderByElements(((PlainSelect)((Select)CCJSqlParserUtil.parse((String)"SELECT * FROM FOO ORDER BY (SELECT 0)")).getSelectBody()).getOrderByElements());
            }
            Offset offset = new Offset().withOffsetParam("ROWS");
            offset.setOffset((Expression)new LongValue((long)skip.intValue()));
            select.setOffset(offset);
            Fetch fetch = new Fetch().withFetchParam("ROWS");
            fetch.setRowCount((long)top.intValue());
            select.setFetch(fetch);
            return statement.toString();
        }
        Object orderBy = "ORDER BY (SELECT 0)";
        if (select.getOrderByElements() != null && select.getOrderByElements().size() > 0) {
            orderBy = "ORDER BY ";
            for (OrderByElement o : select.getOrderByElements()) {
                if (((String)orderBy).length() > 9) {
                    orderBy = (String)orderBy + ", ";
                }
                orderBy = (String)orderBy + o.toString();
            }
        }
        select.setLimit(null);
        select.setOrderByElements(List.of());
        SelectExpressionItem count = new SelectExpressionItem().withExpression(CCJSqlParserUtil.parseExpression((String)("row_number() OVER(" + (String)orderBy + ") AS CRONAPP_ROW_NUMBER")));
        count.setAlias(new Alias("CRONAPP_ROW_NUMBER").withUseAs(true));
        select.getSelectItems().add(0, count);
        return "SELECT TOP " + top + "\r\n * \r\n FROM \r\n (\r\n" + statement + "\r\n)\r\n AS CRONAPP_PAGING WHERE CRONAPP_ROW_NUMBER > " + skip;
    }

    @Override
    public String count(Statement statement, Connection connection) {
        PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
        select.setOrderByElements(List.of());
        List withList = ((Select)statement).getWithItemsList();
        if (withList != null && !withList.isEmpty()) {
            try {
                Expression count = CCJSqlParserUtil.parseExpression((String)"count(*)");
                select.setSelectItems(List.of(new SelectExpressionItem().withExpression(count).withAlias(new Alias("CRONAPP_COUNT").withUseAs(true))));
                select.setTop(null);
                select.setDistinct(null);
                return statement.toString();
            }
            catch (JSQLParserException e) {
                throw new RuntimeException(e);
            }
        }
        String sql = "select count(*) AS CRONAPP_COUNT from (" + statement + ") as CRONAPP_COUNT_SELECT";
        return sql;
    }

    @Override
    public DBDictionary getDictionary(Connection connection) throws SQLException {
        return DICTIONARY;
    }

    @Override
    public Map<String, Object> getGenerated(EdmEntityType entity, PreparedStatement ps, Connection connection) throws Exception {
        ResultSet keys = ps.getGeneratedKeys();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        int c = 0;
        if (keys != null && keys.next()) {
            for (String name : entity.getPropertyNames()) {
                EdmSimplePropertyImplProv property = (EdmSimplePropertyImplProv)entity.getProperty(name);
                if (property.getFacets() == null || !property.getFacets().isAutoGenerated()) continue;
                map.put(property.getName(), Var.valueOf(keys.getObject(++c)).getObject(((JPAEdmMappingImpl)property.getMapping()).getJPAType()));
            }
        }
        return map;
    }

    @Override
    public ExpressionProvider getExpressionProvider() {
        return ExpressionProviderFactory.getProvider((String)"Microsoft SQL Server");
    }

    @Override
    public String getUpdateSQL(String mainTable, String alias, String columns, String values, String where) {
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            return "UPDATE " + alias + " SET " + values + " FROM " + mainTable + " " + alias + " WHERE " + where;
        }
        return super.getUpdateSQL(mainTable, alias, columns, values, where);
    }

    @Override
    public String getDeleteSQL(String mainTable, String alias, String columns, String values, String where) {
        if (StringUtils.isNotBlank((CharSequence)alias)) {
            return "DELETE " + alias + " FROM " + mainTable + " " + alias + " WHERE " + where;
        }
        return super.getDeleteSQL(mainTable, alias, columns, values, where);
    }

    static {
        DICTIONARY.setConfiguration((Configuration)new JDBCConfigurationImpl());
    }
}

