/*
 * Decompiled with CFR 0.152.
 */
package cronapi;

import cronapi.TokenUtils;
import cronapi.Var;
import cronapi.database.TransactionManager;
import cronapi.util.LRUCache;
import java.util.Date;
import java.util.LinkedHashSet;
import javax.persistence.EntityManager;
import javax.persistence.TemporalType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ApiManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApiManager.class);
    private static boolean INVALIDATED_TOKEN_CACHE_ENABLED;
    protected static int INTERVAL;
    private static final LRUCache<String, LinkedHashSet<String>> INVALIDATED_TOKEN_CACHE;

    public static boolean isInvalidatedTokenCacheEnabled() {
        return INVALIDATED_TOKEN_CACHE_ENABLED;
    }

    public static LinkedHashSet<String> getInvalidatedTokens() {
        if (INVALIDATED_TOKEN_CACHE_ENABLED) {
            LinkedHashSet<String> list;
            block4: {
                list = INVALIDATED_TOKEN_CACHE.get("listInvalidatedTokens-unique");
                if (list == null) {
                    list = new LinkedHashSet();
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName("app.entity.InvalidatedToken");
                        TransactionManager.begin(clazz);
                        EntityManager em = TransactionManager.getEntityManager(clazz);
                        em.createQuery("DELETE FROM InvalidatedToken e WHERE e.expirationDate < :now").setParameter("now", TokenUtils.generateCurrentDate(), TemporalType.TIMESTAMP).executeUpdate();
                        list.addAll(em.createQuery("SELECT e.id FROM InvalidatedToken e", String.class).getResultList());
                        TransactionManager.commit(clazz);
                        INVALIDATED_TOKEN_CACHE.put("listInvalidatedTokens-unique", list);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error to sync INVALIDATED_TOKEN_CACHE. Motive: " + e.getMessage() + ". Revoke token on logout was disabled.");
                        INVALIDATED_TOKEN_CACHE_ENABLED = false;
                        if (clazz == null) break block4;
                        TransactionManager.rollback(clazz);
                    }
                }
            }
            return list;
        }
        return new LinkedHashSet<String>();
    }

    public static void addInvalidatedToken(String id, Date expirationDate) {
        block3: {
            if (INVALIDATED_TOKEN_CACHE_ENABLED) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName("app.entity.InvalidatedToken");
                    Var object = new Var(clazz.getConstructors()[0].newInstance(new Object[0]));
                    object.setField("id", id);
                    object.setField("expirationDate", expirationDate);
                    TransactionManager.begin(clazz);
                    TransactionManager.getEntityManager(clazz).persist(object.getObject(clazz));
                    TransactionManager.commit(clazz);
                    LinkedHashSet<String> list = ApiManager.getInvalidatedTokens();
                    list.add(id);
                    INVALIDATED_TOKEN_CACHE.put("listInvalidatedTokens-unique", list);
                }
                catch (Exception e) {
                    LOGGER.error("Error to add token to INVALIDATED_TOKEN_CACHE. Motive: " + e.getMessage() + ". Revoke token on logout was disabled.");
                    INVALIDATED_TOKEN_CACHE_ENABLED = false;
                    if (clazz == null) break block3;
                    TransactionManager.rollback(clazz);
                }
            }
        }
    }

    static {
        INTERVAL = 60000;
        INVALIDATED_TOKEN_CACHE = new LRUCache(Integer.MAX_VALUE, INTERVAL);
        try {
            Class.forName("app.entity.InvalidatedToken");
            INVALIDATED_TOKEN_CACHE_ENABLED = true;
        }
        catch (ClassNotFoundException e) {
            LOGGER.info("Class app.entity.InvalidatedToken not exists. Revoke token on logout was disabled.");
            INVALIDATED_TOKEN_CACHE_ENABLED = false;
        }
    }
}

