/*
 * Decompiled with CFR 0.152.
 */
package cronapi.report;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.stimulsoft.base.exception.StiException;
import com.stimulsoft.base.licenses.StiLicense;
import com.stimulsoft.lib.utils.StiValidationUtil;
import com.stimulsoft.report.StiExportManager;
import com.stimulsoft.report.StiOptions;
import com.stimulsoft.report.StiReport;
import com.stimulsoft.report.StiSerializeManager;
import com.stimulsoft.report.export.settings.StiExcelExportSettings;
import com.stimulsoft.report.export.settings.StiHtmlExportSettings;
import com.stimulsoft.report.export.settings.StiPdfExportSettings;
import com.stimulsoft.report.export.tools.html.StiHtmlExportQuality;
import cronapi.CronapiConfigurator;
import cronapi.CronapiException;
import cronapi.QueryManager;
import cronapi.Utils;
import cronapi.report.DataSourcesInBand;
import cronapi.report.odata.StiODataDatabase;
import cronapi.report.odata.StiODataSource;
import cronapi.rest.DownloadREST;
import cronapp.reports.PrintDesign;
import cronapp.reports.ReportExport;
import cronapp.reports.ReportManager;
import cronapp.reports.commons.Functions;
import cronapp.reports.commons.Parameter;
import cronapp.reports.commons.ParameterType;
import cronapp.reports.commons.ReportFront;
import cronapp.reports.j4c.dataset.J4CDataset;
import cronapp.reports.j4c.dataset.J4CEntity;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.sql.DataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.olingo.odata2.client.api.ODataClient;
import org.apache.olingo.odata2.client.api.uri.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ReportService {
    public static final String SINGLE_QUOTE = "'";
    private static final String TYPE_PDF = "pdf";
    private static final String TYPE_HTML = "html";
    private static final String TYPE_EXCEL = "excel";
    private static HashMap<String, String> charCannotBeEscaped;
    private static final String REPORT_CONFIG = "reportConfig";
    private static final Logger log;
    private final ClassLoader loader = Thread.currentThread().getContextClassLoader();

    ReportService() {
    }

    public ReportFront getReport(String reportName) {
        ReportFront reportResult = new ReportFront(reportName);
        try {
            if (reportName.contains("jrxml")) {
                log.info("Report in design mode, build the parameters...");
                InputStream inputStream = this.getInputStream(reportName);
                JasperDesign jasperDesign = JRXmlLoader.load((InputStream)inputStream);
                Stream.of(jasperDesign.getParameters()).filter(jrParameter -> !jrParameter.isSystemDefined()).filter(jrParameter -> !jrParameter.getName().contains("image_")).filter(jrParameter -> !jrParameter.getName().contains("sub_")).forEach(jrParameter -> {
                    Parameter parameter = new Parameter();
                    parameter.setName(jrParameter.getName());
                    parameter.setType(ParameterType.toType((Class)jrParameter.getValueClass()));
                    parameter.setDescription(jrParameter.getDescription());
                    JRExpression expression = jrParameter.getDefaultValueExpression();
                    if (expression != null) {
                        parameter.setValue((Object)expression.getText());
                    }
                    reportResult.addParameter(parameter);
                });
            }
        }
        catch (JRException e) {
            log.error("Problems to make JasperDesign object.");
            throw new RuntimeException(e);
        }
        return reportResult;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public String getContentReport(String reportName) {
        try (InputStream inputStream = this.getInputStream(reportName);){
            String string;
            try (BufferedReader buffer = new BufferedReader(new InputStreamReader(inputStream, CronapiConfigurator.ENCODING));){
                String content = buffer.lines().collect(Collectors.joining("\n"));
                JsonObject json = (JsonObject)new JsonParser().parse(content);
                json.addProperty("reportName", reportName);
                string = json.toString();
            }
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DataSourcesInBand getDataSourcesParams(DataSourcesInBand dataSourcesInBand) {
        dataSourcesInBand.getDatasources().forEach(dsp -> {
            JsonObject currentCustomQuery = null;
            try {
                currentCustomQuery = QueryManager.getQuery(dsp.getCustomId());
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
            List<DataSourcesInBand.ParamValue> dsParams = this.getDataSourceParamsFromCustomQuery(currentCustomQuery);
            dsParams.forEach(param -> {
                Optional<DataSourcesInBand.FieldParam> exist = dsp.getFieldParams().stream().filter(fp -> param.getFieldName().equals(fp.getField())).findAny();
                if (!exist.isPresent()) {
                    dsp.getFieldParams().add(new DataSourcesInBand.FieldParam(param.getFieldName(), param.getFieldName(), "String", ""));
                }
                dsp.getQueryParams().add(new DataSourcesInBand.ParamValue(param.getFieldName(), ":" + param.getFieldName()));
            });
            if (dsp.getFieldParams().size() > 0) {
                dataSourcesInBand.setHasParam(true);
            }
        });
        return dataSourcesInBand;
    }

    public String getPDFAsFile(ReportFront reportFront) {
        ReportExport result = this.getReportExport(reportFront);
        if (result == null) {
            return "";
        }
        result.exportReportToPdfFile();
        return DownloadREST.getDownloadUrl(new File(result.getTargetFile()));
    }

    public byte[] getPDF(ReportFront reportFront) {
        byte[] bytes = new byte[]{};
        String reportName = reportFront.getReportName();
        if (reportName.contains(".report")) {
            File file = this.exportReportFile(reportFront, TYPE_PDF);
            if (file.exists()) {
                try {
                    bytes = Files.readAllBytes(file.toPath());
                    file.delete();
                    log.info("Temporary report file removed.");
                }
                catch (IOException io) {
                    log.error("Problems to make the temporary report file.");
                    throw new RuntimeException(io);
                }
            }
        } else {
            ReportExport result = this.getReportExport(reportFront);
            if (result == null) {
                return new byte[0];
            }
            bytes = result.toPDF();
        }
        return bytes;
    }

    ReportExport getReportExport(ReportFront reportFront, File file) {
        ReportExport result;
        block19: {
            File pdf;
            result = null;
            try {
                if (file == null) {
                    pdf = DownloadREST.getTempFile(UUID.randomUUID().toString() + ".pdf");
                    if (pdf.createNewFile()) {
                        log.info("Temporary report file created.");
                    }
                } else {
                    pdf = file;
                }
            }
            catch (IOException e) {
                log.error("Problems to make the temporary report file.");
                throw new RuntimeException(e);
            }
            InputStream inputStream = this.getInputStream(reportFront.getReportName());
            String reportName = reportFront.getReportName();
            if (reportName.contains("jrxml")) {
                ReportManager reportManager = ReportManager.newPrint((InputStream)inputStream, (String)pdf.getAbsolutePath());
                PrintDesign printDesign = reportManager.byDesign(reportFront.getParameters()).updateParameters().updateImages().updateSubreports();
                J4CDataset dataset = printDesign.getCollectionDataset();
                if (dataset == null) {
                    String datasource = printDesign.getDatasource();
                    try (Connection connection = this.getConnection(datasource);){
                        result = printDesign.print(connection);
                        break block19;
                    }
                    catch (SQLException e) {
                        throw new RuntimeException(e);
                    }
                }
                J4CEntity entity = dataset.getEntity();
                String jpql = entity.getJpql();
                if (Functions.isExists((String)jpql)) {
                    String persistenceUnit = dataset.getPersistenceUnitName();
                    EntityManager entityManager = this.getEntityManager(persistenceUnit);
                    Map printParameters = printDesign.getPrintParameters();
                    Query queryObject = entityManager.createQuery(jpql);
                    Set objectParameters = queryObject.getParameters();
                    Set parameterNames = objectParameters.stream().map(javax.persistence.Parameter::getName).collect(Collectors.toSet());
                    Set entrySet = printParameters.entrySet();
                    for (Map.Entry item : entrySet) {
                        String name = (String)item.getKey();
                        if (!parameterNames.contains(name)) continue;
                        Object value = item.getValue();
                        queryObject.setParameter(name, value);
                    }
                    List resultList = Collections.emptyList();
                    try {
                        resultList = queryObject.getResultList();
                    }
                    catch (IllegalArgumentException e) {
                        log.error(e.getMessage());
                    }
                    result = printDesign.print((Collection)resultList);
                }
            }
        }
        return result;
    }

    private static String getIfIsDate(String value) {
        if (StringUtils.isEmpty((CharSequence)value) || value.length() < 4) {
            return null;
        }
        Calendar c = Utils.toGenericCalendar(value);
        if (c != null) {
            return "datetimeoffset'" + Utils.getISODateFormat().format(c.getTime()) + SINGLE_QUOTE;
        }
        return null;
    }

    public static String repCharCannotBeEscaped(String value, boolean isUndo) {
        for (Map.Entry<String, String> entry : charCannotBeEscaped.entrySet()) {
            String toFind = isUndo ? entry.getValue() : entry.getKey();
            String toReplace = isUndo ? entry.getKey() : entry.getValue();
            value = value.replace(toFind, toReplace);
        }
        return value;
    }

    private static String parseParameter(String s, Map<String, String> values) {
        if (s.startsWith(":")) {
            String parameterName = s.substring(1);
            if (values.containsKey(parameterName)) {
                String value = values.get(parameterName);
                String date = ReportService.getIfIsDate(value);
                if (StringUtils.isNotEmpty((CharSequence)date)) {
                    return date;
                }
                value = ReportService.repCharCannotBeEscaped(StringEscapeUtils.escapeEcmaScript((String)ReportService.repCharCannotBeEscaped(value, false)), true);
                return SINGLE_QUOTE + value + SINGLE_QUOTE;
            }
            return "''";
        }
        return s;
    }

    private static String getOperatorODATA(String left, String operator, String right) {
        switch (operator) {
            case "%": {
                return "substringof(" + right + ", " + left + ")";
            }
            case "=": {
                return left + " eq " + right;
            }
            case "!=": {
                return left + " ne " + right;
            }
            case ">": {
                return left + " gt " + right;
            }
            case ">=": {
                return left + " ge " + right;
            }
            case "<": {
                return left + " lt " + right;
            }
            case "<=": {
                return left + " le " + right;
            }
        }
        throw new CronapiException("Invalid filter expression type " + operator);
    }

    private static String toFilter(JsonObject data, Map<String, String> values) {
        Object result = "";
        if (data != null) {
            String type;
            JsonArray expressionArgs = data.getAsJsonArray("args");
            JsonPrimitive expressionType = data.getAsJsonPrimitive("type");
            JsonArray args = expressionArgs == null ? new JsonArray() : expressionArgs;
            String string = type = expressionType == null ? "" : expressionType.getAsString();
            if (args != null && args.size() > 0) {
                for (int i = 0; i < args.size(); ++i) {
                    JsonObject arg = args.get(i).getAsJsonObject();
                    String oper = type;
                    if (i == 0) {
                        oper = "";
                    }
                    JsonPrimitive expressionCurrentType = arg.getAsJsonPrimitive("type");
                    JsonPrimitive expressionLeft = arg.getAsJsonPrimitive("left");
                    JsonPrimitive expressionRight = arg.getAsJsonPrimitive("right");
                    String left = expressionLeft == null ? "" : ReportService.parseParameter(expressionLeft.getAsString(), values);
                    String right = expressionRight == null ? "" : ReportService.parseParameter(expressionRight.getAsString(), values);
                    String currentType = expressionCurrentType == null ? "" : expressionCurrentType.getAsString();
                    result = arg.getAsJsonArray("args") != null && arg.getAsJsonArray("args").size() > 0 ? (String)result + " " + oper.toLowerCase() + " ( " + ReportService.toFilter(arg, values) + " ) " : (String)result + " " + oper.toLowerCase() + " " + ReportService.getOperatorODATA(left, currentType, right);
                }
            }
        }
        return ((String)result).trim();
    }

    private static String addParams(String filter, Map<String, String> values) {
        if (values != null) {
            for (Map.Entry<String, String> entry : values.entrySet()) {
                String key = entry.getKey();
                if (((String)filter).toLowerCase().contains(key.toLowerCase())) continue;
                filter = (String)filter + (((String)filter).contains("?") ? "&" : "?") + key + "=" + entry.getValue();
            }
        }
        return filter;
    }

    private static String removeSingleQuote(String value) {
        if (value.startsWith(SINGLE_QUOTE) && value.endsWith(SINGLE_QUOTE)) {
            return value.replaceAll("(^')|('$)", "");
        }
        return value;
    }

    private static String getFieldValue(String s, Map<String, String> values) {
        if (s.startsWith(":")) {
            String parameterName = s.substring(1);
            if (values.containsKey(parameterName)) {
                return values.get(parameterName);
            }
            return "";
        }
        return ReportService.removeSingleQuote(s);
    }

    private static String toQueryString(JsonArray paramsJson, Map<String, String> values) {
        if (paramsJson == null || paramsJson.size() == 0) {
            return "";
        }
        Object queryString = "";
        if (paramsJson != null) {
            for (JsonElement p : paramsJson) {
                JsonObject param = p.getAsJsonObject();
                queryString = (String)queryString + param.get("fieldName").getAsString();
                queryString = (String)queryString + "=";
                queryString = (String)queryString + ReportService.getFieldValue(param.get("fieldValue").getAsString(), values);
                queryString = (String)queryString + "&";
            }
            queryString = ((String)queryString).substring(0, ((String)queryString).length() - 1);
        }
        return queryString;
    }

    private static String getQueryId(String query) {
        return query.split("\\?", 2)[0];
    }

    private static JsonObject genParamsBasedOnValues(Map<String, String> values) {
        JsonArray params = new JsonArray();
        values.forEach((key, value) -> {
            JsonObject param = new JsonObject();
            param.addProperty("fieldName", key);
            param.addProperty("fieldValue", ":" + key);
            params.add((JsonElement)param);
        });
        JsonObject container = new JsonObject();
        container.add("params", (JsonElement)params);
        return container;
    }

    private static JsonObject getQueryJson(String query, Map<String, String> values) {
        String[] querySlices = query.split("\\?", 2);
        if (querySlices.length == 1 && values != null && !values.isEmpty()) {
            return ReportService.genParamsBasedOnValues(values);
        }
        if (querySlices.length == 2) {
            JsonParser jsonParser = new JsonParser();
            return (JsonObject)jsonParser.parse(querySlices[1]);
        }
        return null;
    }

    private static String bindParameters(String query, Map<String, String> values) {
        String SERVICE_ROOT_URI = "https://localhost/";
        String[] querySlices = query.split("\\?", 2);
        JsonParser jsonParser = new JsonParser();
        JsonObject queryJson = querySlices.length > 1 ? (JsonObject)jsonParser.parse(querySlices[1]) : null;
        JsonObject expressionJson = queryJson != null ? queryJson.getAsJsonObject("expression") : null;
        String filter = ReportService.toFilter(expressionJson, values);
        String queryString = query;
        if (StringUtils.isNotEmpty((CharSequence)filter)) {
            URIBuilder uriBuilder = ODataClient.newInstance().uriBuilder("https://localhost/");
            uriBuilder.appendEntitySetSegment(querySlices[0]);
            uriBuilder.filter(filter);
            queryString = uriBuilder.build().toString().replaceFirst("https://localhost/", "");
        }
        queryString = ReportService.addParams(queryString, values);
        return queryString;
    }

    public static void main(String[] args) throws Exception {
        String query = "User?{\"params\":[],\"expression\":{\"type\":\"AND\",\"args\":[{\"type\":\"=\",\"left\":\"userName\",\"right\":\":userName\",\"args\":[]}]}}";
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("userName", "admin");
        System.out.println(ReportService.bindParameters(query, values));
    }

    public void exportStimulsoftReportContentToFile(String reportContent, File file, Map<String, String> parameters, String type, Boolean isLegacyReport) throws Exception {
        if (!reportContent.isEmpty()) {
            StiReport stiReport = new StiReport();
            stiReport.loadFromJson(reportContent);
            this.exportStimulsoftReportToFile(stiReport, file, parameters, type, isLegacyReport);
        }
    }

    void exportStimulsoftReportToFile(String reportName, File file, Map<String, String> parameters, String type, Boolean isLegacyReport) {
        StiReport stiReport = null;
        try (InputStream inputStream = this.getInputStream(reportName);){
            stiReport = StiSerializeManager.deserializeReport((InputStream)inputStream);
            this.exportStimulsoftReportToFile(stiReport, file, parameters, type, isLegacyReport);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    void exportStimulsoftReportToFile(StiReport stiReport, File file, Map<String, String> parameters, String type, Boolean isLegacyReport) {
        try {
            if (stiReport.getDataSources() != null) {
                stiReport.getDataSources().forEach(stiDataSource -> {
                    if (stiDataSource instanceof StiODataSource) {
                        StiODataSource stiODataSource = (StiODataSource)((Object)stiDataSource);
                        String query = ReportService.bindParameters(stiODataSource.getQuery(), parameters);
                        stiODataSource.setQuery(query);
                    }
                });
            }
            stiReport.getDictionary().getVariables().forEach(c -> c.setValue((String)parameters.get(c.name)));
            stiReport.Render();
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                if (TYPE_HTML.equals(type)) {
                    StiHtmlExportSettings htmlExportSettings = new StiHtmlExportSettings();
                    htmlExportSettings.setEncoding(Charset.defaultCharset());
                    htmlExportSettings.setExportQuality(StiHtmlExportQuality.High);
                    StiExportManager.exportHtml((StiReport)stiReport, (StiHtmlExportSettings)htmlExportSettings, (OutputStream)outputStream);
                }
                if (TYPE_EXCEL.equalsIgnoreCase(type)) {
                    StiExcelExportSettings excelExportSettings = new StiExcelExportSettings();
                    StiExportManager.exportExcel((StiReport)stiReport, (StiExcelExportSettings)excelExportSettings, (OutputStream)outputStream);
                } else {
                    StiPdfExportSettings pdfExportSettings = new StiPdfExportSettings();
                    pdfExportSettings.setPdfACompliance(false);
                    pdfExportSettings.setEmbeddedFonts(true);
                    pdfExportSettings.setStandardPdfFonts(true);
                    pdfExportSettings.setCompressed(true);
                    try {
                        StiExportManager.exportPdf((StiReport)stiReport, (StiPdfExportSettings)pdfExportSettings, (OutputStream)outputStream);
                    }
                    catch (Exception e) {
                        pdfExportSettings.setPdfACompliance(false);
                        pdfExportSettings.setEmbeddedFonts(false);
                        StiExportManager.exportPdf((StiReport)stiReport, (StiPdfExportSettings)pdfExportSettings, (OutputStream)outputStream);
                    }
                }
            }
        }
        catch (StiException | IOException e) {
            log.error("Problems exporting stimulsoft report to pdf file.");
            throw new RuntimeException(e);
        }
        finally {
            if (stiReport != null && !StiValidationUtil.isNullOrEmpty((String)stiReport.reportCachePath)) {
                stiReport.dispose();
            }
        }
    }

    void exportStimulsoftReportToFile(String reportName, File file, Map<String, String> parameters, String type) {
        this.exportStimulsoftReportToFile(reportName, file, parameters, type, (Boolean)true);
    }

    void exportStimulsoftReportToPdfFile(String reportName, File file, Map<String, String> parameters) {
        this.exportStimulsoftReportToFile(reportName, file, parameters, TYPE_PDF);
    }

    void exportStimulsoftReportToHtmlFile(String reportName, File file, Map<String, String> parameters) {
        this.exportStimulsoftReportToFile(reportName, file, parameters, TYPE_HTML);
    }

    private ReportExport getReportExport(ReportFront reportFront) {
        return this.getReportExport(reportFront, null);
    }

    private List<DataSourcesInBand.ParamValue> getDataSourceParamsFromCustomQuery(JsonObject customQuery) {
        ArrayList<DataSourcesInBand.ParamValue> params = new ArrayList<DataSourcesInBand.ParamValue>();
        if (customQuery != null) {
            for (JsonElement queryParamsValues : customQuery.get("queryParamsValues").getAsJsonArray()) {
                JsonObject paramNameValue = queryParamsValues.getAsJsonObject();
                DataSourcesInBand.ParamValue paramValue = new DataSourcesInBand.ParamValue();
                paramValue.setFieldName(paramNameValue.get("fieldName").getAsString());
                params.add(paramValue);
            }
        }
        return params;
    }

    private EntityManager getEntityManager(String persistenceUnit) {
        HashMap<String, String> properties = new HashMap<String, String>();
        properties.put("javax.persistence.jtaDataSource", persistenceUnit);
        EntityManagerFactory managerFactory = Persistence.createEntityManagerFactory((String)persistenceUnit, properties);
        return managerFactory.createEntityManager();
    }

    private Connection getConnection(String datasource) {
        if (datasource != null && !datasource.isEmpty() && !"null".equals(datasource)) {
            Context context = null;
            DataSource dataSource = null;
            try {
                context = (Context)new InitialContext().lookup("java:/comp/env");
                dataSource = (DataSource)context.lookup(datasource);
            }
            catch (NamingException e) {
                try {
                    if (context != null) {
                        dataSource = (DataSource)context.lookup(datasource.toLowerCase());
                    }
                }
                catch (NamingException e1) {
                    throw new RuntimeException(new Exception("Connection context not found.\nError: " + e.getMessage()));
                }
            }
            try {
                if (dataSource != null) {
                    return dataSource.getConnection();
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(new Exception("Trouble getting a connection from the context.\nError: " + e.getMessage()));
            }
        }
        return null;
    }

    private InputStream getInputStream(String reportName) {
        InputStream inputStream = this.loader.getResourceAsStream(reportName);
        if (inputStream == null) {
            throw new RuntimeException("File [" + reportName + "] not found.");
        }
        return inputStream;
    }

    private JsonObject parseJsonObject(String content) {
        return (JsonObject)new JsonParser().parse(content);
    }

    public String getRenderType(String content) {
        String type = TYPE_PDF.toUpperCase();
        JsonObject json = this.parseJsonObject(content);
        if (json.has(REPORT_CONFIG)) {
            type = json.get(REPORT_CONFIG).getAsString();
        }
        return type;
    }

    private File exportReportFile(ReportFront report, String extension) {
        File file = null;
        try {
            file = DownloadREST.getTempFile(UUID.randomUUID().toString() + "." + extension);
            if (file.createNewFile()) {
                log.info("Temporary report file created.");
            }
            HashMap<String, String> parameters = new HashMap<String, String>();
            for (Parameter param : report.getParameters()) {
                parameters.put(param.getName(), param.getValue().toString());
            }
            if (TYPE_PDF.equals(extension)) {
                this.exportStimulsoftReportToPdfFile(report.getReportName(), file, parameters);
            }
            if (TYPE_HTML.equals(extension)) {
                this.exportStimulsoftReportToHtmlFile(report.getReportName(), file, parameters);
            }
        }
        catch (IOException e) {
            log.error("Problems to make the temporary report file.");
            throw new RuntimeException(e);
        }
        return file;
    }

    static {
        StiLicense.setKey((String)cronapi.util.Functions.requirementsForReports());
        StiOptions.Services.getDataSource().add(StiODataSource.class);
        StiOptions.Services.getDataBases().add(StiODataDatabase.class);
        charCannotBeEscaped = new HashMap<String, String>(){
            {
                this.put("/", "|slash|");
            }
        };
        log = LoggerFactory.getLogger(ReportService.class);
    }
}

