/*
 * Decompiled with CFR 0.152.
 */
package cronapi.jdbc;

import cronapi.Var;
import cronapi.jdbc.DatabaseMetadata;
import cronapi.jdbc.SQLAnsiMetadata;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Limit;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.core.edm.provider.EdmSimplePropertyImplProv;
import org.apache.olingo.odata2.jpa.processor.core.ExpressionProvider;
import org.apache.olingo.odata2.jpa.processor.core.ExpressionProviderFactory;
import org.apache.olingo.odata2.jpa.processor.core.model.JPAEdmMappingImpl;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.MySQLDictionary;
import org.apache.openjpa.lib.conf.Configuration;

public class MySQLMetadata
extends SQLAnsiMetadata
implements DatabaseMetadata {
    private static final MySQLDictionary DICTIONARY = new MySQLDictionary();

    @Override
    public String limit(Statement statement, Connection connection, Integer top, Integer skip) throws Exception {
        PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
        Limit limit = new Limit();
        limit.setOffset((Expression)new LongValue().withValue((long)skip.intValue()));
        limit.setRowCount((Expression)new LongValue().withValue((long)top.intValue()));
        select.setLimit(limit);
        return statement.toString();
    }

    @Override
    public String count(Statement statement, Connection connection) {
        PlainSelect select = (PlainSelect)((Select)statement).getSelectBody();
        select.setOrderByElements(List.of());
        String sql = "select count(*) AS CRONAPP_COUNT from (" + String.valueOf(statement) + ") as CRONAPP_COUNT_SELECT";
        return sql;
    }

    @Override
    public DBDictionary getDictionary(Connection connection) throws SQLException {
        return DICTIONARY;
    }

    @Override
    public Map<String, Object> getGenerated(EdmEntityType entity, PreparedStatement ps, Connection connection) throws Exception {
        ResultSet keys = ps.getGeneratedKeys();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        int c = 0;
        if (keys != null && keys.next()) {
            for (String name : entity.getPropertyNames()) {
                EdmSimplePropertyImplProv property = (EdmSimplePropertyImplProv)entity.getProperty(name);
                if (property.getFacets() == null || !property.getFacets().isAutoGenerated()) continue;
                map.put(property.getName(), Var.valueOf(keys.getObject(++c)).getObject(((JPAEdmMappingImpl)property.getMapping()).getJPAType()));
            }
        }
        return map;
    }

    @Override
    public ExpressionProvider getExpressionProvider() {
        return ExpressionProviderFactory.getProvider((String)"MySQL");
    }

    static {
        DICTIONARY.setConfiguration((Configuration)new JDBCConfigurationImpl());
    }
}

