window.onload = function() {
  //<editor-fold desc="Changeable Configuration Block">

  // the following lines will be replaced by docker/configurator, when it runs in a docker-container
  window.ui = SwaggerUIBundle({
    url: location.pathname.replace('/api/metadata/index.html','/api/metadata/configuration'),
    dom_id: '#swagger-ui',
    deepLinking: true,
    presets: [
      SwaggerUIBundle.presets.apis,
      SwaggerUIStandalonePreset
    ],
    plugins: [
      SwaggerUIBundle.plugins.DownloadUrl,
      HideTopbarPlugin
    ],
    layout: "StandaloneLayout",
    requestInterceptor: function(request) {
      const match = document.cookie.match(new RegExp('(^| )XSRF-TOKEN=([^;]+)'));
      if (match) {
        request.headers['X-XSRF-TOKEN'] = match[2];
      }
      return request;
    }
  });

  //</editor-fold>

  function HideTopbarPlugin() {
    // this plugin overrides the Topbar component to return nothing
    return {
      components: {
        Topbar: function() { return null; }
      }
    };
  }
};
