/*
 * Decompiled with CFR 0.152.
 */
package cronapi;

import cronapi.ApiManager;
import cronapi.AppConfig;
import cronapi.RestClient;
import cronapi.Var;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.impl.lang.JwtDateConverter;
import io.jsonwebtoken.security.WeakKeyException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.userdetails.UserDetails;

public class TokenUtils {
    private static final String SECRET = AppConfig.token();
    private static final String AUDIENCE_MOBILE = "mobile";
    private static final String AUDIENCE_TABLET = "tablet";
    public static final String AUTH_HEADER_NAME = "X-AUTH-TOKEN";
    public static final String AUTH_COOKIE_NAME = "AuthToken";

    public static SignatureAlgorithm selectHmacAlgorithm(String secret) {
        int len;
        int n = len = secret == null ? 0 : secret.getBytes(StandardCharsets.UTF_8).length;
        if (len >= 64) {
            return SignatureAlgorithm.HS512;
        }
        if (len >= 48) {
            return SignatureAlgorithm.HS384;
        }
        return SignatureAlgorithm.HS256;
    }

    public static List<String> getAuthoritiesFromToken(String token) {
        try {
            return (List)TokenUtils.getClaimsFromToken(token).get((Object)"authorities");
        }
        catch (Exception e) {
            return new ArrayList<String>();
        }
    }

    public static String getUsernameFromToken(String token) {
        try {
            return TokenUtils.getClaimsFromToken(token).getSubject();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getProviderFromToken(String token) {
        try {
            return TokenUtils.getClaimsFromToken(token).getIssuer();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Date getCreatedDateFromToken(String token) {
        try {
            return TokenUtils.fromJwtDate(TokenUtils.getClaimsFromToken(token).get((Object)"created"));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getExpirationDateFromToken(String token) {
        try {
            return TokenUtils.getClaimsFromToken(token).getExpiration();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String getAudienceFromToken(String token) {
        try {
            return (String)TokenUtils.getClaimsFromToken(token).get((Object)"audience");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Claims getClaimsFromToken(String token) {
        try {
            return (Claims)Jwts.parser().setSigningKey(SECRET).build().parseClaimsJws((CharSequence)token).getBody();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String addClaimToToken(String token, String key, Object value) {
        try {
            Claims claims = (Claims)Jwts.parser().setSigningKey(SECRET).build().parseClaimsJws((CharSequence)token).getBody();
            claims.put((Object)key, value);
            SignatureAlgorithm alg = TokenUtils.selectHmacAlgorithm(SECRET);
            try {
                return ((JwtBuilder)Jwts.builder().setClaims((Map)claims).setExpiration(claims.getExpiration())).signWith(alg, SECRET).compact();
            }
            catch (WeakKeyException wke1) {
                try {
                    SignatureAlgorithm fallback = alg == SignatureAlgorithm.HS512 ? SignatureAlgorithm.HS384 : SignatureAlgorithm.HS256;
                    return ((JwtBuilder)Jwts.builder().setClaims((Map)claims).setExpiration(claims.getExpiration())).signWith(fallback, SECRET).compact();
                }
                catch (WeakKeyException wke2) {
                    return ((JwtBuilder)Jwts.builder().setClaims((Map)claims).setExpiration(claims.getExpiration())).signWith(SignatureAlgorithm.HS256, SECRET).compact();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Token is not in the request");
        }
    }

    public static String setExpiration(String token, Date expiration) {
        Claims claims = (Claims)Jwts.parser().setSigningKey(SECRET).build().parseClaimsJws((CharSequence)token).getBody();
        SignatureAlgorithm alg = TokenUtils.selectHmacAlgorithm(SECRET);
        try {
            return ((JwtBuilder)Jwts.builder().setClaims((Map)claims).setExpiration(expiration)).signWith(alg, SECRET).compact();
        }
        catch (WeakKeyException wke1) {
            try {
                SignatureAlgorithm fallback = alg == SignatureAlgorithm.HS512 ? SignatureAlgorithm.HS384 : SignatureAlgorithm.HS256;
                return ((JwtBuilder)Jwts.builder().setClaims((Map)claims).setExpiration(expiration)).signWith(fallback, SECRET).compact();
            }
            catch (WeakKeyException wke2) {
                return ((JwtBuilder)Jwts.builder().setClaims((Map)claims).setExpiration(expiration)).signWith(SignatureAlgorithm.HS256, SECRET).compact();
            }
        }
    }

    public static String getNameFromToken(String token) {
        try {
            return (String)TokenUtils.getClaimsFromToken(token).get((Object)"name");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String getIssuerFromToken(String token) {
        try {
            return (String)TokenUtils.getClaimsFromToken(token).get((Object)"iss");
        }
        catch (Exception e) {
            return null;
        }
    }

    public static List<String> getScopeFromToken(String token) {
        try {
            String scope = (String)TokenUtils.getClaimsFromToken(token).get((Object)"scope");
            return scope == null ? List.of() : Arrays.asList(scope.trim().split(" "));
        }
        catch (Exception e) {
            return List.of();
        }
    }

    public static Date generateCurrentDate() {
        return new Date(System.currentTimeMillis());
    }

    public static Date generateExpirationDate() {
        return new Date(System.currentTimeMillis() + AppConfig.tokenExpiration() * 1000L);
    }

    public static boolean isTokenExpired(String token) {
        Claims claims;
        boolean expired = true;
        if (token != null && !token.isBlank() && (claims = TokenUtils.getClaimsFromToken(token)) != null) {
            Date expiration = claims.getExpiration();
            boolean bl = expired = expiration == null || expiration.before(TokenUtils.generateCurrentDate());
            if (!expired) {
                expired = ApiManager.isInvalidatedTokenCacheEnabled() && ApiManager.getInvalidatedTokens().contains(claims.getId());
            }
        }
        return expired;
    }

    private static boolean isCreatedBeforeLastPasswordReset(Date created, Date lastPasswordReset) {
        return lastPasswordReset != null && created.before(lastPasswordReset);
    }

    private static String generateAudience() {
        return "web";
    }

    private static boolean ignoreTokenExpiration(String token) {
        String audience = TokenUtils.getAudienceFromToken(token);
        return AUDIENCE_TABLET.equals(audience) || AUDIENCE_MOBILE.equals(audience);
    }

    static String generateToken(UserDetails userDetails) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("sub", userDetails.getUsername());
        claims.put("audience", TokenUtils.generateAudience());
        claims.put("created", TokenUtils.toJwtDate(TokenUtils.generateCurrentDate()));
        claims.put("iss", "local");
        return TokenUtils.generateToken(claims, null, null);
    }

    static String generateToken(UserDetails userDetails, String provider) {
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("sub", userDetails.getUsername());
        claims.put("audience", TokenUtils.generateAudience());
        claims.put("created", TokenUtils.toJwtDate(TokenUtils.generateCurrentDate()));
        claims.put("iss", provider);
        return TokenUtils.generateToken(claims, null, null);
    }

    public static String generateToken(Authentication userDetails, String provider) {
        Enumeration names;
        LinkedHashMap<String, Object> extraClaims = new LinkedHashMap<String, Object>();
        HttpServletRequest request = RestClient.getRestClient().getRequest();
        if (request != null && (names = request.getAttributeNames()) != null) {
            while (names.hasMoreElements()) {
                String attrName = (String)names.nextElement();
                if (attrName == null || !attrName.startsWith("CronappToken:")) continue;
                extraClaims.put(attrName.replace("CronappToken:", ""), Var.valueOf(RestClient.getRestClient().getRequest().getAttribute(attrName)).getObject());
            }
        }
        Date expires = null;
        if (request != null && request.getAttribute("CronappTokenExpiration") != null) {
            expires = ((Calendar)request.getAttribute("CronappTokenExpiration")).getTime();
        }
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("sub", userDetails.getName());
        claims.put("audience", TokenUtils.generateAudience());
        claims.put("created", TokenUtils.toJwtDate(TokenUtils.generateCurrentDate()));
        claims.put("iss", provider);
        claims.put("name", userDetails.getName());
        claims.put("authorities", userDetails.getAuthorities().stream().map(authority -> authority.getAuthority()).collect(Collectors.toList()));
        claims.putAll(extraClaims);
        String oldToken = RestClient.getRestClient().getToken();
        if (Strings.isNotBlank((String)oldToken)) {
            Claims oldClaims = TokenUtils.getClaimsFromToken(oldToken);
            oldClaims.forEach(claims::putIfAbsent);
        }
        return TokenUtils.generateToken(claims, expires, null);
    }

    public static String generateToken(UserDetails userDetails, String name, String provider) {
        return TokenUtils.generateToken(userDetails, name, provider, new LinkedHashMap<String, Object>());
    }

    public static String generateToken(UserDetails userDetails, String name, String provider, LinkedHashMap<String, Object> extras) {
        Enumeration names;
        LinkedHashMap<String, Object> extraClaims = new LinkedHashMap<String, Object>();
        extraClaims.putAll(extras);
        HttpServletRequest request = RestClient.getRestClient().getRequest();
        if (request != null && (names = request.getAttributeNames()) != null) {
            while (names.hasMoreElements()) {
                String attrName = (String)names.nextElement();
                if (attrName == null || !attrName.startsWith("CronappToken:")) continue;
                extraClaims.put(attrName.replace("CronappToken:", ""), Var.valueOf(RestClient.getRestClient().getRequest().getAttribute(attrName)).getObject());
            }
        }
        Date expires = null;
        if (request != null && request.getAttribute("CronappTokenExpiration") != null) {
            expires = ((Calendar)request.getAttribute("CronappTokenExpiration")).getTime();
        }
        HashMap<String, Object> claims = new HashMap<String, Object>();
        claims.put("sub", userDetails.getUsername());
        claims.put("audience", TokenUtils.generateAudience());
        claims.put("created", TokenUtils.toJwtDate(TokenUtils.generateCurrentDate()));
        claims.put("iss", provider);
        claims.put("name", name);
        claims.put("authorities", userDetails.getAuthorities().stream().map(authority -> authority.getAuthority()).collect(Collectors.toList()));
        claims.putAll(extraClaims);
        String oldToken = RestClient.getRestClient().getToken();
        if (Strings.isNotBlank((String)oldToken)) {
            Claims oldClaims = TokenUtils.getClaimsFromToken(oldToken);
            oldClaims.forEach(claims::putIfAbsent);
        }
        return TokenUtils.generateToken(claims, expires, null);
    }

    public static String generateToken(Map<String, Object> claims, Date expires, String id) {
        if (expires == null) {
            expires = TokenUtils.generateExpirationDate();
        }
        if (id == null) {
            id = UUID.randomUUID().toString();
        }
        return ((JwtBuilder)((JwtBuilder)Jwts.builder().setClaims(claims).setExpiration(expires)).setId(id)).signWith(SignatureAlgorithm.HS256, SECRET).compact();
    }

    public static boolean canTokenBeRefreshed(String token, Date lastPasswordReset) {
        Date created = TokenUtils.getCreatedDateFromToken(token);
        return TokenUtils.isCreatedBeforeLastPasswordReset(created, lastPasswordReset) && (!TokenUtils.isTokenExpired(token) || TokenUtils.ignoreTokenExpiration(token));
    }

    public static String refreshToken(String token) {
        try {
            Claims originalClaims = TokenUtils.getClaimsFromToken(token);
            HashMap<String, Object> claims = new HashMap<String, Object>((Map<String, Object>)originalClaims);
            claims.put("created", TokenUtils.toJwtDate(TokenUtils.generateCurrentDate()));
            return TokenUtils.generateToken(claims, null, originalClaims.getId());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static synchronized void revokeToken(String token) {
        if (ApiManager.isInvalidatedTokenCacheEnabled()) {
            Claims claims = TokenUtils.getClaimsFromToken(token);
            ApiManager.addInvalidatedToken(claims.getId(), claims.getExpiration());
        }
    }

    public static Cookie createCookieFromToken(String token, String path, boolean isSecure) {
        Cookie cookie = new Cookie(AUTH_COOKIE_NAME, token);
        long expires = TokenUtils.getExpirationDateFromToken(token).getTime() / 1000L;
        long now = TokenUtils.generateCurrentDate().getTime() / 1000L;
        cookie.setMaxAge((int)(expires - now));
        cookie.setSecure(isSecure);
        cookie.setHttpOnly(true);
        if (path != null) {
            if ((path = path.trim()).isEmpty() || path.equals("/")) {
                cookie.setPath("/");
            } else {
                if (path.endsWith("/")) {
                    path = path.substring(0, path.length() - 1);
                }
                cookie.setPath(path);
            }
        }
        return cookie;
    }

    public static String getTokenFromCookie(Cookie[] cookies) {
        String token = null;
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                String value;
                if (!AUTH_COOKIE_NAME.equals(cookie.getName()) || TokenUtils.isTokenExpired(value = cookie.getValue()) || token != null && !token.isBlank() && !TokenUtils.getCreatedDateFromToken(value).after(TokenUtils.getCreatedDateFromToken(token))) continue;
                token = value;
            }
        }
        return token;
    }

    private static Object toJwtDate(Date date) {
        return JwtDateConverter.INSTANCE.applyTo(date);
    }

    private static Date fromJwtDate(Object o) {
        return JwtDateConverter.INSTANCE.applyFrom(o);
    }
}

