/*
 * Decompiled with CFR 0.152.
 */
package cronapi.math;

import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;

@CronapiMetaData(category=CronapiMetaData.CategoryType.MATH, categoryTags={"Math", "Matem\u00e1tica"})
public class Operations {
    public static final Var multiply(Var ... values) throws Exception {
        Var result = new Var();
        boolean isDouble = false;
        for (Var v : values) {
            if (v.getType() != Var.Type.DOUBLE) continue;
            isDouble = true;
        }
        result = isDouble ? Operations.multiplyDouble(values) : Operations.multiplyLong(values);
        return result;
    }

    public static final Var subtract(Var ... values) throws Exception {
        Var result = new Var();
        boolean isDouble = false;
        for (Var v : values) {
            if (v.getType() != Var.Type.DOUBLE) continue;
            isDouble = true;
        }
        result = isDouble ? Operations.subtractDouble(values) : Operations.subtractLong(values);
        return result;
    }

    public static final Var sum(Var ... values) throws Exception {
        Var result = new Var();
        boolean isDouble = false;
        for (Var v : values) {
            if (v.getType() != Var.Type.DOUBLE) continue;
            isDouble = true;
            break;
        }
        if (!isDouble) {
            block1: for (Var v : values) {
                if (v.getType() != Var.Type.LIST) continue;
                for (int i = 0; i < v.size(); ++i) {
                    if (v.get(i).getType() != Var.Type.DOUBLE) continue;
                    isDouble = true;
                    continue block1;
                }
            }
        }
        result = isDouble ? Operations.addDouble(values) : Operations.addLong(values);
        return result;
    }

    public static final Var listSum(Var values) throws Exception {
        return new Var(Operations.sum(values));
    }

    public static final Var addLong(Var ... values) throws Exception {
        Long addedValue = 0L;
        for (Var value : values) {
            if (value.getType() == Var.Type.LIST) {
                for (Object v : Var.valueOf(value).getObjectAsList()) {
                    addedValue = addedValue + Var.valueOf(v).getObjectAsLong();
                }
                continue;
            }
            addedValue = addedValue + value.getObjectAsLong();
        }
        return new Var(addedValue);
    }

    public static final Var addDouble(Var ... values) throws Exception {
        Double addedValue = 0.0;
        for (Var value : values) {
            if (value.getType() == Var.Type.LIST) {
                for (Object v : Var.valueOf(value).getObjectAsList()) {
                    addedValue = addedValue + Var.valueOf(v).getObjectAsDouble();
                }
                continue;
            }
            addedValue = addedValue + value.getObjectAsDouble();
        }
        return new Var(addedValue);
    }

    public static final Var subtractLong(Var ... values) throws Exception {
        Long initialValue = values[0].getObjectAsLong();
        for (int i = 1; i < values.length; ++i) {
            Var value = values[i];
            initialValue = initialValue - value.getObjectAsLong();
        }
        return new Var(initialValue);
    }

    public static final Var subtractDouble(Var ... values) throws Exception {
        Double initialValue = values[0].getObjectAsDouble();
        for (int i = 1; i < values.length; ++i) {
            Var value = values[i];
            initialValue = initialValue - value.getObjectAsDouble();
        }
        return new Var(initialValue);
    }

    public static final Var multiplyLong(Var ... values) throws Exception {
        Long returnValue = 1L;
        for (Var value : values) {
            returnValue = returnValue * value.getObjectAsLong();
        }
        return new Var(returnValue);
    }

    public static final Var multiplyDouble(Var ... values) throws Exception {
        Double returnValue = 1.0;
        for (Var value : values) {
            returnValue = returnValue * value.getObjectAsDouble();
        }
        return new Var(returnValue);
    }

    public static final Var divisor(Var ... values) throws Exception {
        Double result = Var.valueOf(0).getObjectAsDouble();
        int n = 0;
        Var[] varArray = values;
        int n2 = varArray.length;
        if (n < n2) {
            Var v = varArray[n];
            result = values[0].getObjectAsDouble();
            values[0] = new Var(1);
            for (Var value : values) {
                result = result / value.getObjectAsDouble();
            }
            return new Var(result);
        }
        return new Var(result);
    }

    public static final Var abs(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.abs(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.abs(value.getObjectAsLong()));
            default -> new Var(Math.abs(value.getObjectAsDouble()));
        };
    }

    public static final Var sqrt(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.sqrt(Math.abs(value.getObjectAsDouble())));
            case Var.Type.INT -> new Var(Math.sqrt(Math.abs(value.getObjectAsLong())));
            default -> new Var(Math.sqrt(Math.abs(value.getObjectAsInt())));
        };
    }

    public static final Var log(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.log(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.log(value.getObjectAsLong().longValue()));
            default -> new Var(Math.log(value.getObjectAsInt().intValue()));
        };
    }

    public static final Var log10(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.log10(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.log10(value.getObjectAsLong().longValue()));
            default -> new Var(Math.log10(value.getObjectAsInt().intValue()));
        };
    }

    public static final Var exp(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.exp(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.exp(value.getObjectAsLong().longValue()));
            default -> new Var(Math.exp(value.getObjectAsInt().intValue()));
        };
    }

    @CronapiMetaData(type="function", name="{{MATHTHEPOW}}", displayInline=true, nameTags={"Pot\u00eancia", "pow"}, description="{{MATHPOWDESCRIPTION}}", returnType=CronapiMetaData.ObjectType.DOUBLE)
    public static final Var pow(@ParamMetaData(description="{{MATHPOWBASE}}", type=CronapiMetaData.ObjectType.DOUBLE) Var base, @ParamMetaData(description="{{MATHPOWEXPONENT}}", type=CronapiMetaData.ObjectType.DOUBLE) Var exponent) throws Exception {
        return Var.valueOf(Math.pow(base.getObjectAsDouble(), exponent.getObjectAsDouble()));
    }

    public static final Var pow10(Var value1) throws Exception {
        return switch (value1.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.pow(10.0, value1.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.pow(10.0, value1.getObjectAsLong().longValue()));
            default -> new Var(Math.pow(10.0, value1.getObjectAsDouble()));
        };
    }

    public static final Var round(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.round(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.round(value.getObjectAsLong().longValue()));
            default -> new Var(Math.round(value.getObjectAsInt().intValue()));
        };
    }

    public static final Var ceil(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.ceil(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.ceil(value.getObjectAsLong().longValue()));
            default -> new Var(Math.ceil(value.getObjectAsInt().intValue()));
        };
    }

    public static final Var floor(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.floor(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.floor(value.getObjectAsLong().longValue()));
            default -> new Var(Math.floor(value.getObjectAsInt().intValue()));
        };
    }

    public static final Var sin(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.sin(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.sin(value.getObjectAsLong().longValue()));
            default -> new Var(Math.sin(value.getObjectAsInt().intValue()));
        };
    }

    public static final Var cos(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.cos(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.cos(value.getObjectAsLong().longValue()));
            default -> new Var(Math.cos(value.getObjectAsInt().intValue()));
        };
    }

    public static final Var tan(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.tan(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.tan(value.getObjectAsLong().longValue()));
            default -> new Var(Math.tan(value.getObjectAsInt().intValue()));
        };
    }

    public static final Var asin(Var value) throws Exception {
        if (value.getObjectAsDouble() > 1.0) {
            return new Var(Math.acos(1.0));
        }
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.asin(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.asin(value.getObjectAsLong().longValue()));
            default -> new Var(Math.asin(value.getObjectAsInt().intValue()));
        };
    }

    public static final Var acos(Var value) throws Exception {
        if (value.getObjectAsDouble() > 1.0) {
            return new Var(Math.acos(1.0));
        }
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.acos(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.acos(value.getObjectAsLong().longValue()));
            default -> new Var(Math.acos(value.getObjectAsInt().intValue()));
        };
    }

    public static final Var atan(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(Math.atan(value.getObjectAsDouble()));
            case Var.Type.INT -> new Var(Math.atan(value.getObjectAsLong().longValue()));
            default -> new Var(Math.atan(value.getObjectAsInt().intValue()));
        };
    }

    public static final Var pi() throws Exception {
        return new Var(Math.PI);
    }

    public static final Var neg(Var value) throws Exception {
        return switch (value.getType()) {
            case Var.Type.DOUBLE -> new Var(value.getObjectAsDouble() * -1.0);
            case Var.Type.INT -> new Var(value.getObjectAsLong() * -1L);
            default -> new Var(value.getObjectAsLong() * -1L);
        };
    }

    public static final Var infinity() throws Exception {
        return new Var(Double.POSITIVE_INFINITY);
    }

    public static final Var e() throws Exception {
        return new Var(Math.E);
    }

    public static final Var goldenRatio() throws Exception {
        return new Var((1.0 + Math.sqrt(5.0)) / 2.0);
    }

    public static final Var isEven(Var value) throws Exception {
        if (Math.abs(value.getObjectAsInt()) % 2 == 0) {
            return new Var(true);
        }
        return new Var(false);
    }

    public static final Var isOdd(Var value) throws Exception {
        if (Math.abs(value.getObjectAsInt()) % 2 == 1) {
            return new Var(true);
        }
        return new Var(false);
    }

    public static final Var isPrime(Var value) throws Exception {
        if ((value = new Var(Math.abs(value.getObjectAsInt()))).getObjectAsLong() < 2L) {
            return new Var(false);
        }
        if (value.getObjectAsLong() == 2L) {
            return new Var(true);
        }
        if (value.getObjectAsLong() % 2L == 0L) {
            return new Var(false);
        }
        int i = 3;
        while ((long)(i * i) <= value.getObjectAsLong()) {
            if (value.getObjectAsLong() % (long)i == 0L) {
                return new Var(false);
            }
            i += 2;
        }
        return new Var(true);
    }

    public static final Var isInt(Var value) throws Exception {
        if (value.getType() == Var.Type.INT || value.getType() == Var.Type.NULL) {
            return new Var(true);
        }
        return new Var(false);
    }

    public static final Var isPositive(Var value) throws Exception {
        if (value.getObjectAsLong() >= 0L) {
            return new Var(true);
        }
        return new Var(false);
    }

    public static final Var isNegative(Var value) throws Exception {
        if (value.getObjectAsLong() < 0L) {
            return new Var(true);
        }
        return new Var(false);
    }

    public static final Var isDivisibleBy(Var value1, Var value2) throws Exception {
        if (value1.getObjectAsDouble() % value2.getObjectAsDouble() == 0.0) {
            return new Var(true);
        }
        return new Var(false);
    }

    public static final Var randomInt(Var min, Var max) throws Exception {
        Random random = new Random();
        if (min.equals(max)) {
            return min;
        }
        boolean isDouble = false;
        if (min.getType() == Var.Type.DOUBLE || max.getType() == Var.Type.DOUBLE) {
            isDouble = true;
        }
        if (!max.greaterThanOrEqual(min)) {
            Var aux = max;
            max = min;
            min = aux;
        }
        if (isDouble) {
            return Var.valueOf(max.getObjectAsDouble() + (max.getObjectAsDouble() - min.getObjectAsDouble()) * random.nextDouble());
        }
        int maxValue = max.getObjectAsInt() + 1;
        return Var.valueOf(random.nextInt(maxValue -= min.getObjectAsInt().intValue()) + min.getObjectAsInt());
    }

    public static final Var randomFloat() throws Exception {
        Random random = new Random();
        double result = random.nextGaussian();
        while (result < 0.0 || result > 1.0) {
            result = random.nextGaussian();
        }
        return new Var(result);
    }

    public static final Var listSmaller(Var value) throws Exception {
        Double result;
        switch (Var.valueOf(value.getObjectAsList()).get(0).getType()) {
            case DOUBLE: {
                result = Var.valueOf(value.getObjectAsList().get(0)).getObjectAsDouble();
                for (Object v : value.getObjectAsList()) {
                    if (!(Var.valueOf(v).getObjectAsDouble() < Var.valueOf(result).getObjectAsDouble())) continue;
                    result = v;
                }
                break;
            }
            case INT: {
                result = Var.valueOf(value.getObjectAsList().get(0)).getObjectAsDouble();
                for (Object v : value.getObjectAsList()) {
                    if (Var.valueOf(v).getObjectAsLong() >= Var.valueOf(result).getObjectAsLong()) continue;
                    result = v;
                }
                break;
            }
            default: {
                result = Var.valueOf(value.getObjectAsList().get(0)).getObjectAsDouble();
                for (Object v : value.getObjectAsList()) {
                    if (Var.valueOf(v).getObjectAsLong() >= Var.valueOf(result).getObjectAsLong()) continue;
                    result = v;
                }
            }
        }
        return Var.valueOf(result);
    }

    public static final Var listLarger(Var value) throws Exception {
        Number result;
        switch (Var.valueOf(value.getObjectAsList()).get(0).getType()) {
            case DOUBLE: {
                result = Var.valueOf(value.getObjectAsList()).get(0).getObjectAsDouble();
                for (Object v : value.getObjectAsList()) {
                    if (!(Var.valueOf(v).getObjectAsDouble() > Var.valueOf(result).getObjectAsDouble())) continue;
                    result = v;
                }
                break;
            }
            case INT: {
                result = Var.valueOf(value.getObjectAsList()).get(0).getObjectAsLong();
                for (Object v : value.getObjectAsList()) {
                    if (Var.valueOf(v).getObjectAsLong() <= Var.valueOf(result).getObjectAsLong()) continue;
                    result = v;
                }
                break;
            }
            default: {
                result = Var.valueOf(value.getObjectAsList()).get(0).getObjectAsLong();
                for (Object v : value.getObjectAsList()) {
                    if (Var.valueOf(v).getObjectAsLong() <= Var.valueOf(result).getObjectAsLong()) continue;
                    result = v;
                }
            }
        }
        return Var.valueOf(result);
    }

    public static final Var listAverage(Var value) throws Exception {
        Double sum = 0.0;
        for (Object v : value.getObjectAsList()) {
            sum = sum + Var.valueOf(v).getObjectAsDouble();
        }
        Var result = new Var(sum / (double)value.size());
        return result;
    }

    public static final Var listMedium(Var value) throws Exception {
        switch (Var.valueOf(value.getObjectAsList().get(0)).getType()) {
            case DOUBLE: {
                List lklist = value.getObjectAsList();
                Collections.sort(lklist, new Comparator<Var>(){

                    @Override
                    public int compare(Var o1, Var o2) {
                        if (o1.getObjectAsDouble() > o2.getObjectAsDouble()) {
                            return 1;
                        }
                        if (o1.getObjectAsDouble() == o2.getObjectAsDouble()) {
                            return 0;
                        }
                        if (o1.getObjectAsDouble() < o2.getObjectAsDouble()) {
                            return -1;
                        }
                        return 0;
                    }
                });
                if (lklist.size() % 2 == 1) {
                    return new Var(lklist.get(lklist.size() / 2));
                }
                Var result = Var.valueOf(lklist.get(lklist.size() / 2 - 1));
                result = Var.valueOf(Var.valueOf(result).getObjectAsDouble() + Var.valueOf(lklist.get(lklist.size() / 2 + 1)).getObjectAsDouble() / 2.0);
                return result;
            }
            case INT: {
                List lklist = value.getObjectAsList();
                Collections.sort(lklist, new Comparator<Var>(){

                    @Override
                    public int compare(Var o1, Var o2) {
                        if (o1.getObjectAsLong() > o2.getObjectAsLong()) {
                            return 1;
                        }
                        if (o1.getObjectAsLong() == o2.getObjectAsLong()) {
                            return 0;
                        }
                        if (o1.getObjectAsLong() < o2.getObjectAsLong()) {
                            return -1;
                        }
                        return 0;
                    }
                });
                if (lklist.size() % 2 == 1) {
                    return new Var(lklist.get(lklist.size() / 2));
                }
                Var result = new Var(lklist.get(lklist.size() / 2 - 1));
                result = Var.valueOf(Var.valueOf(result).getObjectAsLong() + Var.valueOf(lklist.get(lklist.size() / 2 + 1)).getObjectAsLong() / 2L);
                return result;
            }
        }
        List lklist = value.getObjectAsList();
        Collections.sort(lklist, new Comparator<Var>(){

            @Override
            public int compare(Var o1, Var o2) {
                if (o1.getObjectAsLong() > o2.getObjectAsLong()) {
                    return 1;
                }
                if (o1.getObjectAsLong() == o2.getObjectAsLong()) {
                    return 0;
                }
                if (o1.getObjectAsLong() < o2.getObjectAsLong()) {
                    return -1;
                }
                return 0;
            }
        });
        if (lklist.size() % 2 == 1) {
            return new Var(lklist.get(lklist.size() / 2));
        }
        Var result = new Var(lklist.get(lklist.size() / 2 - 1));
        result = Var.valueOf(Var.valueOf(result).getObjectAsLong() + Var.valueOf(lklist.get(lklist.size() / 2 + 1)).getObjectAsLong() / 2L);
        return result;
    }

    public static final Var listModes(Var value) throws Exception {
        Var modes = new Var();
        HashMap<Double, Double> countMap = new HashMap<Double, Double>();
        double max = -1.0;
        List ll = Var.valueOf(value).getObjectAsList();
        for (Object e : ll) {
            double d = Var.valueOf(e).getObjectAsDouble();
            double count = 0.0;
            count = countMap.containsKey(d) ? (Double)countMap.get(d) + 1.0 : 1.0;
            countMap.put(d, count);
            if (!(count > max)) continue;
            max = count;
        }
        for (Map.Entry entry : countMap.entrySet()) {
            if ((Double)entry.getValue() != max) continue;
            modes = new Var(Var.valueOf((double)((Double)entry.getKey())));
        }
        return modes;
    }

    public static final Var listRandomItem(Var value) throws Exception {
        return new Var(value.get(Operations.randomInt(new Var(0), new Var(value.size() - 1)).getObjectAsInt()));
    }

    public static final Var listStandardDeviation(Var value) throws Exception {
        double mean = Operations.listAverage(value).getObjectAsDouble();
        double size = value.size();
        double temp = 0.0;
        List ll = value.getObjectAsList();
        if (size == 1.0) {
            return Var.valueOf(0.0);
        }
        for (Object var : ll) {
            double d = Var.valueOf(var).getObjectAsDouble() - mean;
            temp += d * d;
        }
        return new Var(Math.sqrt(1.0 / (size - 1.0) * temp));
    }

    public static final Var mod(Var value1, Var value2) throws Exception {
        boolean isDouble = false;
        if (value1.getType() == Var.Type.DOUBLE || value2.getType() == Var.Type.DOUBLE) {
            isDouble = true;
        }
        if (isDouble) {
            Double resultado = value1.getObjectAsDouble() % value2.getObjectAsDouble();
            return new Var(resultado);
        }
        Long resultado = value1.getObjectAsLong() % value2.getObjectAsLong();
        return new Var(resultado);
    }

    public static final Var min(Var value1, Var value2) throws Exception {
        if (value1.getType().equals((Object)Var.Type.DOUBLE) || value2.getType().equals((Object)Var.Type.DOUBLE)) {
            return value1.getObjectAsDouble() <= value2.getObjectAsDouble() ? value1 : value2;
        }
        return value1.getObjectAsInt() <= value2.getObjectAsInt() ? value1 : value2;
    }

    public static final Var max(Var value1, Var value2) throws Exception {
        if (value1.getType().equals((Object)Var.Type.DOUBLE) || value2.getType().equals((Object)Var.Type.DOUBLE)) {
            return value1.getObjectAsDouble() >= value2.getObjectAsDouble() ? value1 : value2;
        }
        return value1.getObjectAsInt() >= value2.getObjectAsInt() ? value1 : value2;
    }

    public static final Var negate(Var value) throws Exception {
        if (value.getType().equals((Object)Var.Type.DOUBLE)) {
            return new Var(value.getObjectAsDouble() * -1.0);
        }
        return new Var(value.getObjectAsLong() * -1L);
    }
}

