/*
 * Decompiled with CFR 0.152.
 */
package cronapi;

import com.google.gson.JsonObject;
import cronapi.ClientCommand;
import cronapi.CronapiFilter;
import cronapi.RestBody;
import cronapi.TokenUtils;
import cronapi.Var;
import cronapi.database.TenantService;
import cronapi.database.TransactionManager;
import cronapi.i18n.AppMessages;
import cronapi.i18n.Messages;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.olingo.odata2.core.servlet.ODataServlet;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RestClient {
    private static ThreadLocal<RestClient> REST_CLIENT = new ThreadLocal();
    private static ThreadLocal<Map<String, Object>> THREAD_VALUES = ThreadLocal.withInitial(HashMap::new);
    private LinkedList<ClientCommand> commands = new LinkedList();
    private HttpServletResponse response;
    private HttpServletRequest request;
    private HttpSession session;
    private User user;
    private String host;
    private String method;
    private String queryString;
    private String userAgent;
    private JsonObject query = null;
    private boolean filteredEnabled = false;
    private Locale locale;
    private Integer utcOffset;
    private Map<String, String> parameters;
    private Map<String, String> headers;
    private Object entity;
    private List<Object> keys;
    private String token;
    private static List<GrantedAuthority> DEFAULT_AUTHORITIES;
    private static final String[] IP_HEADER_CANDIDATES;
    private RestBody body;
    private Var rawBody;
    private TenantService tenantService;

    public RestClient clone() {
        TenantService newTenant = new TenantService();
        if (this.tenantService != null) {
            newTenant.getContextIds().putAll(this.tenantService.getContextIds());
        }
        RestClient newClient = new RestClient();
        newClient.setUser(this.getUser());
        newClient.setTenantService(newTenant);
        newClient.setSession(this.getSession());
        newClient.setLocale(this.getLocale());
        newClient.setFilteredEnabled(this.filteredEnabled);
        newClient.setMethod(this.getMethod());
        newClient.setUtcOffset(this.getUtcOffset());
        return newClient;
    }

    public static Runnable getContextRunnable(Runnable runnable, boolean transactional) {
        RestClient client = RestClient.getRestClient().clone();
        return () -> {
            RestClient.setRestClient(client);
            try {
                if (transactional) {
                    RestClient.contextExecute(runnable);
                } else {
                    runnable.run();
                }
            }
            finally {
                RestClient.removeClient();
                Messages.remove();
                AppMessages.remove();
            }
        };
    }

    private static void contextExecute(Runnable runnable) {
        try {
            runnable.run();
            TransactionManager.commit();
        }
        catch (Exception e) {
            TransactionManager.rollback();
            throw new RuntimeException(e);
        }
        finally {
            TransactionManager.close();
            TransactionManager.clear();
        }
    }

    public static RestClient getRestClient() {
        RestClient restClient = REST_CLIENT.get();
        if (restClient == null) {
            restClient = new RestClient();
            REST_CLIENT.set(restClient);
        }
        return restClient;
    }

    public void downloadURL(String url) {
        ClientCommand command = new ClientCommand("cronapi.util.downloadFile");
        command.addParam(url);
        this.addCommand(command);
    }

    public static void setRestClient(RestClient client) {
        REST_CLIENT.set(client);
        if (client.getLocale() != null) {
            Messages.set(client.getLocale());
            AppMessages.set(client.getLocale());
        }
    }

    public static void removeClient() {
        REST_CLIENT.set(null);
        REST_CLIENT.remove();
    }

    public ClientCommand addCommand(ClientCommand command) {
        this.commands.add(command);
        return command;
    }

    public ClientCommand addCommand(String name) {
        ClientCommand command = new ClientCommand(name);
        this.commands.add(command);
        return command;
    }

    public LinkedList<ClientCommand> getCommands() {
        return this.commands;
    }

    public RestBody getBody() {
        if (this.body == null) {
            this.body = new RestBody();
        }
        return this.body;
    }

    public void setBody(RestBody body) {
        this.body = body;
    }

    public Var getRawBody() {
        return this.rawBody;
    }

    public void setRawBody(Var rawBody) {
        this.rawBody = rawBody;
    }

    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    public HttpServletRequest getRequest() {
        if (this.request != null) {
            return this.request;
        }
        HttpServletRequest request = (HttpServletRequest)ODataServlet.REQUEST.get();
        if (request == null) {
            HttpServletRequest httpServletRequest = request = RequestContextHolder.getRequestAttributes() != null ? ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest() : null;
        }
        if (request == null) {
            request = CronapiFilter.REQUEST.get();
        }
        return request;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public HttpServletResponse getResponse() {
        if (this.response != null) {
            return this.response;
        }
        return RequestContextHolder.getRequestAttributes() != null ? ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getResponse() : null;
    }

    public void setParameter(String key, String value) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        this.parameters.put(key, value);
    }

    public void setHeader(String key, String value) {
        if (this.headers == null) {
            this.headers = new LinkedHashMap<String, String>();
        }
        this.headers.put(key, value);
    }

    public void setParameters(String parametersStr) {
        if (this.parameters == null) {
            this.parameters = new LinkedHashMap<String, String>();
        }
        if (parametersStr != null && !parametersStr.trim().isEmpty()) {
            List params = URLEncodedUtils.parse((String)parametersStr, (Charset)Charset.defaultCharset());
            for (NameValuePair pair : params) {
                String value = pair.getValue();
                this.parameters.put(pair.getName(), value);
            }
        }
    }

    public String getParameter(String key) {
        if (this.parameters != null) {
            return this.parameters.get(key);
        }
        return this.getRequest().getParameter(key);
    }

    public String getHeader(String key) {
        if (this.headers != null) {
            return this.headers.get(key);
        }
        return this.getRequest().getHeader(key);
    }

    public String getServerAddress() {
        return this.getRequest().getScheme() + "://" + this.getRequest().getServerName() + ":" + this.getRequest().getServerPort();
    }

    public boolean hasParameter(String key) {
        if (this.parameters != null) {
            return this.parameters.containsKey(key);
        }
        return this.getRequest().getParameterMap().containsKey(key);
    }

    public String getParameter(String key, String defaultValue) {
        String result = this.parameters != null ? this.parameters.get(key) : this.getRequest().getParameter(key);
        if (result == null) {
            return defaultValue;
        }
        return result;
    }

    public int getParameterAsInt(String key, int defaultValue) {
        return Integer.valueOf(this.getParameter(key, String.valueOf(defaultValue)));
    }

    public boolean getParameterAsBoolean(String key, boolean defaultValue) {
        return Boolean.valueOf(this.getParameter(key, String.valueOf(defaultValue)));
    }

    public String getMethod() {
        if (this.method != null) {
            return this.method;
        }
        try {
            if (this.getRequest() == null) {
                return "";
            }
            return this.getRequest().getMethod();
        }
        catch (IllegalStateException e) {
            return "";
        }
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public JsonObject getQuery() {
        return this.query;
    }

    public String getQueryString() {
        if (this.queryString != null) {
            return this.queryString;
        }
        if (this.getRequest() == null) {
            return "";
        }
        return this.getRequest().getQueryString();
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public void setQuery(JsonObject query) {
        this.query = query;
    }

    public Object getEntity() {
        return this.entity;
    }

    public void setEntity(Object entity) {
        this.entity = entity;
    }

    public List<Object> getKeys() {
        return this.keys;
    }

    public void setKeys(List<Object> keys) {
        this.keys = keys;
    }

    public User getUser() {
        Object localUser;
        if (this.user == null && SecurityContextHolder.getContext() != null && SecurityContextHolder.getContext().getAuthentication() != null && (localUser = SecurityContextHolder.getContext().getAuthentication().getPrincipal()) != null) {
            if (localUser instanceof User) {
                User contextUser;
                this.user = contextUser = (User)localUser;
            } else if (localUser instanceof String) {
                String username = (String)localUser;
                this.user = new User(username, "", SecurityContextHolder.getContext().getAuthentication().getAuthorities());
            }
        }
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public Collection<GrantedAuthority> getAuthorities() {
        User user = this.getUser();
        if (user != null) {
            return user.getAuthorities();
        }
        return Collections.EMPTY_LIST;
    }

    public boolean isFilteredEnabled() {
        return this.filteredEnabled;
    }

    public void setFilteredEnabled(boolean filteredEnabled) {
        this.filteredEnabled = filteredEnabled;
    }

    public TenantService getTenantService() {
        return this.tenantService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public HttpSession getSession() {
        if (this.session != null) {
            return this.session;
        }
        if (this.getRequest() != null) {
            return this.getRequest().getSession();
        }
        return null;
    }

    public void setSession(HttpSession session) {
        this.session = session;
    }

    public void updateSessionValue(String name, Object value) {
        this.getSession().setAttribute(name, value);
    }

    public void updateThreadValue(String name, Object value) {
        THREAD_VALUES.get().put(name, value);
    }

    public void updateRequestValue(String name, Object value) {
        this.getRequest().setAttribute(name, value);
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        if (this.getRequest() != null) {
            return this.getRequest().getLocale();
        }
        return Messages.DEFAUL_LOCALE;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Object getSessionValue(String name) {
        return this.getSession().getAttribute(name);
    }

    public Object getThreadValue(String name) {
        return THREAD_VALUES.get().get(name);
    }

    public Object getRequestValue(String name) {
        return this.getRequest().getAttribute(name);
    }

    public Integer getUtcOffset() {
        if (this.utcOffset != null) {
            return this.utcOffset;
        }
        if (this.getRequest() != null && !StringUtils.isEmpty((CharSequence)this.getRequest().getHeader("timezone"))) {
            return Integer.valueOf(this.getRequest().getHeader("timezone"));
        }
        return TimeZone.getDefault().getRawOffset() / 1000 / 60;
    }

    public void setUtcOffset(Integer utcOffset) {
        this.utcOffset = utcOffset;
    }

    public boolean isDefined() {
        return this.getRequest() != null;
    }

    public String getHost() {
        if (this.host != null) {
            return this.host;
        }
        if (this.getRequest() != null) {
            return RestClient.getClientIpAddress(this.getRequest());
        }
        return null;
    }

    public String getAgent() {
        if (this.userAgent != null) {
            return this.userAgent;
        }
        if (this.getRequest() != null) {
            return this.getRequest().getHeader("User-Agent");
        }
        return null;
    }

    public static String getClientIpAddress() {
        return RestClient.getClientIpAddress(RestClient.getRestClient().getRequest());
    }

    public static String getClientIpAddress(HttpServletRequest request) {
        for (String header : IP_HEADER_CANDIDATES) {
            String ip = request.getHeader(header);
            if (ip == null || ip.length() == 0 || "unknown".equalsIgnoreCase(ip)) continue;
            return ip;
        }
        return request.getRemoteAddr();
    }

    public String getToken() {
        if (this.token != null) {
            return this.token;
        }
        if (this.getRequest() != null) {
            String tokenFromRequest = this.getRequest().getHeader("X-AUTH-TOKEN");
            if (tokenFromRequest == null) {
                tokenFromRequest = TokenUtils.getTokenFromCookie(this.getRequest().getCookies());
            }
            return tokenFromRequest;
        }
        return null;
    }

    public void setToken(String token) {
        this.token = token;
        if (token != null && !token.isBlank()) {
            this.getResponse().addCookie(TokenUtils.createCookieFromToken(token, this.getRequest().getContextPath(), this.getRequest().isSecure()));
        }
    }

    public void cleanup() {
        THREAD_VALUES.get().clear();
    }

    static {
        IP_HEADER_CANDIDATES = new String[]{"X-Forwarded-For", "Proxy-Client-IP", "WL-Proxy-Client-IP", "HTTP_X_FORWARDED_FOR", "HTTP_X_FORWARDED", "HTTP_X_CLUSTER_CLIENT_IP", "HTTP_CLIENT_IP", "HTTP_FORWARDED_FOR", "HTTP_FORWARDED", "HTTP_VIA", "REMOTE_ADDR"};
        DEFAULT_AUTHORITIES = new ArrayList<GrantedAuthority>();
        DEFAULT_AUTHORITIES.add((GrantedAuthority)new SimpleGrantedAuthority("authenticated"));
    }
}

