/*
 * Decompiled with CFR 0.152.
 */
package cronapi.database;

import cronapi.AppConfig;
import cronapi.RestClient;
import cronapi.database.TenantService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.Persistence;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.persistence.internal.jpa.deployment.PersistenceUnitProcessor;
import org.eclipse.persistence.internal.jpa.deployment.SEPersistenceUnitInfo;
import org.eclipse.persistence.jpa.Archive;

public class TransactionManager {
    public static final String AUTO = "AUTO";
    private static final ThreadLocal<Map<String, EntityManager>> CACHE_NAMESPACE = new ThreadLocal();
    private static final ThreadLocal<Integer> USE_ISOLATION = new ThreadLocal();
    private static final ThreadLocal<Integer> OLD_ISOLATION = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(TransactionManager.class.getName());

    public static void addNamespace(String namespace, EntityManager entityManager) {
        Map<String, EntityManager> map = CACHE_NAMESPACE.get();
        if (map == null) {
            map = new HashMap<String, EntityManager>();
            CACHE_NAMESPACE.set(map);
        }
        map.put(namespace, entityManager);
    }

    public static void useIsolationTransaction(int isolationLevel) {
        if (isolationLevel == 0 || isolationLevel == 2 || isolationLevel == 1 || isolationLevel == 4 || isolationLevel == 8) {
            USE_ISOLATION.set(isolationLevel);
        } else {
            LOGGER.warning(() -> "Level de isolamento de transa\u00e7\u00e3o desconhecido: " + isolationLevel);
        }
    }

    private static void restoreTrasactionIsolation(Connection conn) {
        if (conn != null) {
            try {
                if (OLD_ISOLATION.get() != null) {
                    conn.setTransactionIsolation(OLD_ISOLATION.get());
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e, () -> "N\u00e3o foi poss\u00edvel restaurar o level de isolamento de transa\u00e7\u00e3o para " + String.valueOf(OLD_ISOLATION.get()));
            }
        }
    }

    public static EntityManager getEntityManager(Class domainClass) {
        return TransactionManager.getEntityManager(domainClass, true);
    }

    public static EntityManager getEntityManager(Class domainClass, boolean cache) {
        String namespace = domainClass.getPackage().getName().replace(".entity", "");
        return TransactionManager.getEntityManager(namespace, cache);
    }

    public static EntityManager getEntityManager(String namespace, boolean cache) {
        TenantService tenantService;
        EntityManager emNamespace;
        Map<String, EntityManager> mapNamespace = CACHE_NAMESPACE.get();
        if (mapNamespace == null) {
            mapNamespace = new HashMap<String, EntityManager>();
            CACHE_NAMESPACE.set(mapNamespace);
        }
        if (mapNamespace != null && cache && (emNamespace = mapNamespace.get(namespace)) != null && emNamespace.isOpen()) {
            return emNamespace;
        }
        EntityManagerFactory factory = TransactionManager.findEntityManagerFactory(namespace);
        EntityManager em = factory.createEntityManager();
        em.setFlushMode(AppConfig.flushMode());
        if (cache) {
            CACHE_NAMESPACE.get().put(namespace, em);
        }
        if ((tenantService = RestClient.getRestClient().getTenantService()) != null && tenantService.getContextIds() != null) {
            Set<String> keySet = tenantService.getContextIds().keySet();
            for (String key : keySet) {
                em.setProperty(key, tenantService.getId(key));
            }
        }
        if (!cache) {
            em.setProperty("eclipselink.query-results-cache", (Object)"false");
            em.setProperty("eclipselink.cache.shared.default", (Object)"false");
        }
        return em;
    }

    public static EntityManagerFactory findEntityManagerFactory(Class domainClass) {
        String namespace = domainClass.getPackage().getName().replace(".entity", "");
        return TransactionManager.findEntityManagerFactory(namespace);
    }

    public static EntityManagerFactory findEntityManagerFactory(String namespace) {
        Set archives = PersistenceUnitProcessor.findPersistenceArchives();
        for (Archive archive : archives) {
            List persistenceUnitInfos = PersistenceUnitProcessor.getPersistenceUnits((Archive)archive, (ClassLoader)Thread.currentThread().getContextClassLoader());
            for (SEPersistenceUnitInfo pui : persistenceUnitInfos) {
                if (!pui.getPersistenceUnitName().equals(namespace)) continue;
                EntityManagerFactory factory = Persistence.createEntityManagerFactory((String)namespace);
                return factory;
            }
        }
        return null;
    }

    public static void commit(Class domainClass) {
        EntityManager em = TransactionManager.getEntityManager(domainClass);
        if (em != null && em.getTransaction().isActive()) {
            TransactionManager.restoreTrasactionIsolation((Connection)em.unwrap(Connection.class));
            em.getTransaction().commit();
        }
    }

    public static void commit(String namespace) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (em != null && em.getTransaction().isActive()) {
            TransactionManager.restoreTrasactionIsolation((Connection)em.unwrap(Connection.class));
            em.getTransaction().commit();
        }
    }

    public static void flush(Class domainClass) {
        EntityManager em = TransactionManager.getEntityManager(domainClass);
        if (em != null && em.getTransaction().isActive()) {
            em.flush();
        }
    }

    public static void flush(String namespace) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (em != null && em.getTransaction().isActive()) {
            em.flush();
        }
    }

    public static void begin(Class domainClass) {
        EntityManager em = TransactionManager.getEntityManager(domainClass);
        if (em != null && !em.getTransaction().isActive()) {
            em.getTransaction().begin();
            TransactionManager.setTrasactionIsolation((Connection)em.unwrap(Connection.class));
        }
    }

    public static void begin(String namespace) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (em != null && !em.getTransaction().isActive()) {
            em.getTransaction().begin();
            TransactionManager.setTrasactionIsolation((Connection)em.unwrap(Connection.class));
        }
    }

    public static void rollback(Class domainClass) {
        EntityManager em = TransactionManager.getEntityManager(domainClass);
        if (em != null && em.getTransaction().isActive()) {
            TransactionManager.restoreTrasactionIsolation((Connection)em.unwrap(Connection.class));
            em.getTransaction().rollback();
        }
    }

    private static void setTrasactionIsolation(Connection conn) {
        if (conn != null) {
            try {
                if (USE_ISOLATION.get() != null) {
                    if (OLD_ISOLATION.get() == null) {
                        OLD_ISOLATION.set(conn.getTransactionIsolation());
                    }
                    conn.setTransactionIsolation(USE_ISOLATION.get());
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, () -> "N\u00e3o foi poss\u00edvel definir o level de isolamento de transa\u00e7\u00e3o para " + String.valueOf(USE_ISOLATION.get()) + ", " + e.getMessage());
            }
        } else if (USE_ISOLATION.get() != null) {
            LOGGER.log(Level.WARNING, () -> "N\u00e3o foi poss\u00edvel definir o level de isolamento de transa\u00e7\u00e3o para " + String.valueOf(USE_ISOLATION.get()) + ", unraw da conex\u00e3o retornou null.");
        }
    }

    public static void rollback(String namespace) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (em != null && em.getTransaction().isActive()) {
            TransactionManager.restoreTrasactionIsolation((Connection)em.unwrap(Connection.class));
            em.getTransaction().rollback();
        }
    }

    public static void close(Class domainClass) {
        EntityManager em = TransactionManager.getEntityManager(domainClass);
        if (em != null) {
            em.clear();
            TransactionManager.restoreTrasactionIsolation((Connection)em.unwrap(Connection.class));
            em.close();
        }
    }

    public static void close(String namespace) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (em != null) {
            em.clear();
            TransactionManager.restoreTrasactionIsolation((Connection)em.unwrap(Connection.class));
            em.close();
        }
    }

    public static void commit() {
        Map<String, EntityManager> mapNamespace = CACHE_NAMESPACE.get();
        if (mapNamespace != null) {
            for (EntityManager em : mapNamespace.values()) {
                if (!em.getTransaction().isActive()) continue;
                TransactionManager.restoreTrasactionIsolation((Connection)em.unwrap(Connection.class));
                em.getTransaction().commit();
            }
        }
    }

    public static void flush() {
        Map<String, EntityManager> mapNamespace = CACHE_NAMESPACE.get();
        if (mapNamespace != null) {
            for (EntityManager em : mapNamespace.values()) {
                em.flush();
            }
        }
    }

    public static void rollback() {
        Map<String, EntityManager> mapNamespace = CACHE_NAMESPACE.get();
        if (mapNamespace != null) {
            for (EntityManager em : mapNamespace.values()) {
                if (!em.getTransaction().isActive()) continue;
                TransactionManager.restoreTrasactionIsolation((Connection)em.unwrap(Connection.class));
                em.getTransaction().rollback();
            }
        }
    }

    public static void close() {
        Map<String, EntityManager> mapNamespace = CACHE_NAMESPACE.get();
        if (mapNamespace != null) {
            for (EntityManager em : mapNamespace.values()) {
                if (!em.isOpen()) continue;
                em.clear();
                TransactionManager.restoreTrasactionIsolation((Connection)em.unwrap(Connection.class));
                em.close();
            }
        }
    }

    public static void clear() {
        Map<String, EntityManager> map = CACHE_NAMESPACE.get();
        if (map != null) {
            for (EntityManager em : map.values()) {
                try {
                    if (!em.isOpen()) continue;
                    em.clear();
                }
                catch (Exception exception) {}
            }
            map.clear();
        }
        CACHE_NAMESPACE.set(null);
        CACHE_NAMESPACE.remove();
    }

    public static void setFlushMode(String namespace, String flushMode) {
        EntityManager em = TransactionManager.getEntityManager(namespace, true);
        if (AUTO.equalsIgnoreCase(flushMode)) {
            em.setFlushMode(FlushModeType.AUTO);
        } else {
            em.setFlushMode(FlushModeType.COMMIT);
        }
    }
}

