/*
 * Decompiled with CFR 0.152.
 */
package cronapi.util;

import java.util.LinkedHashMap;
import java.util.Map;

public class LRUCache<K, V> {
    private LinkedHashMap<K, LRUEntry> map;
    private int expires;

    public LRUCache(final int cacheSize, int expires) {
        this.expires = expires;
        this.map = new LinkedHashMap<K, LRUEntry>(16, 0.75f, true){
            private static final long serialVersionUID = 1L;

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, LRUEntry> eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    public synchronized V get(Object key) {
        LRUEntry entry = this.map.get(key);
        if (entry != null && System.currentTimeMillis() - entry.time <= (long)this.expires) {
            return entry.value;
        }
        return null;
    }

    public synchronized V put(K key, V value) {
        this.map.put(key, new LRUEntry(this, value));
        return value;
    }

    private class LRUEntry {
        private V value;
        private long time = System.currentTimeMillis();

        public LRUEntry(LRUCache lRUCache, V value) {
            this.value = value;
        }
    }
}

