/*
 * Decompiled with CFR 0.152.
 */
package cronapi.clazz;

import cronapi.util.Operations;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.IOUtils;

public class CronapiClassLoader
extends ClassLoader {
    public static ThreadLocal<CronapiClassLoader> CLASS_LOADER = new ThreadLocal();
    private Map<String, Class<?>> classes = new ConcurrentHashMap();

    public void addClass(String className, byte[] classData) {
        Class<?> clazz = this.defineClass(className, classData, 0, classData.length);
        this.classes.put(className, clazz);
    }

    public static synchronized CronapiClassLoader getInstance() {
        CronapiClassLoader loader = CLASS_LOADER.get();
        if (loader == null) {
            loader = new CronapiClassLoader();
            CLASS_LOADER.set(loader);
        }
        return loader;
    }

    private CronapiClassLoader() {
        super(CronapiClassLoader.class.getClassLoader());
    }

    @Override
    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.findClass(className);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Class<?> findClass(String className) throws ClassNotFoundException {
        Class<?> clazz;
        Class<?> clazz2 = this.classes.get(className);
        if (clazz2 != null) {
            return clazz2;
        }
        String path = className.replace('.', File.separatorChar);
        File classFile = new File(CronapiClassLoader.classFolder(Class.forName(className)), path + ".class");
        if (!classFile.exists()) return Class.forName(className);
        if (className.startsWith("cronapi.")) {
            return Class.forName(className);
        }
        FileInputStream fi = new FileInputStream(classFile);
        try {
            byte[] classData = IOUtils.toByteArray((InputStream)fi);
            clazz2 = this.defineClass(className, classData, 0, classData.length);
            this.classes.put(className, clazz2);
            clazz = clazz2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    fi.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ClassNotFoundException(e.getMessage(), e);
            }
        }
        fi.close();
        return clazz;
    }

    private static String classFolder(Class<?> clazz) {
        String classFolder = "";
        try {
            if (clazz.getProtectionDomain() != null && clazz.getProtectionDomain().getCodeSource() != null) {
                classFolder = new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getAbsolutePath();
                String windowsSlash = Operations.IS_WINDOWS ? "/?" : "";
                classFolder = classFolder.replaceAll("file:" + windowsSlash + "|vfs:" + windowsSlash, "");
                String path = null;
                path = clazz.getCanonicalName() != null ? clazz.getCanonicalName().replace(".", File.separator) + ".class" : clazz.getName().replace(".", File.separator) + ".class";
                if (classFolder.endsWith(path)) {
                    classFolder = classFolder.substring(0, classFolder.length() - path.length());
                }
            }
        }
        catch (Exception e) {
            classFolder = "";
        }
        return CronapiClassLoader.fix(classFolder);
    }

    private static String fix(String path) {
        return path.replace('\\', File.separatorChar).replace('/', File.separatorChar);
    }

    public static synchronized void clear() {
        CronapiClassLoader loader = CLASS_LOADER.get();
        if (loader != null) {
            loader.classes.clear();
            CLASS_LOADER.set(null);
            CLASS_LOADER.remove();
        }
    }
}

