/*
 * Decompiled with CFR 0.152.
 */
package cronapi.email;

import cronapi.CronapiConfigurator;
import cronapi.CronapiMetaData;
import cronapi.ParamMetaData;
import cronapi.Var;
import jakarta.activation.FileDataSource;
import jakarta.mail.Authenticator;
import jakarta.mail.Session;
import java.util.Properties;
import org.apache.commons.mail2.core.EmailException;
import org.apache.commons.mail2.jakarta.DefaultAuthenticator;
import org.apache.commons.mail2.jakarta.EmailAttachment;
import org.apache.commons.mail2.jakarta.HtmlEmail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@CronapiMetaData(category=CronapiMetaData.CategoryType.EMAIL, categoryTags={"Email"})
public class Operations {
    private static final Logger log = LoggerFactory.getLogger(Operations.class);

    @CronapiMetaData(type="function", name="{{sendEmailName}}", nameTags={"sendEmail"}, description="{{sendEmailDescription}}", params={"{{sendEmailParam0}}", "{{sendEmailParam1}}", "{{sendEmailParam2}}", "{{sendEmailParam3}}", "{{sendEmailParam4}}", "{{sendEmailParam5}}", "{{sendEmailParam6}}", "{{sendEmailParam7}}", "{{sendEmailParam8}}", "{{sendEmailParam9}}", "{{sendEmailParam10}}", "{{sendEmailParam11}}"}, paramsType={CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.LIST, CronapiMetaData.ObjectType.LIST, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.LIST, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING, CronapiMetaData.ObjectType.STRING})
    public static final void sendEmail(@ParamMetaData(defaultValue="email@techne.com.br", type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam0}}") Var from, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam1}}") Var to, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam2}}") Var Cc, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam3}}") Var Bcc, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam4}}") Var subject, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam5}}") Var msg, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam6}}") Var html, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam7}}") Var attachments, @ParamMetaData(defaultValue="smtp.office365.com", type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam8}}") Var smtpHost, @ParamMetaData(defaultValue="587", type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam9}}") Var smtpPort, @ParamMetaData(defaultValue="email@techne.com.br", type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam10}}") Var login, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam11}}") Var password, @ParamMetaData(type=CronapiMetaData.ObjectType.STRING, description="{{sendEmailParam12}}", blockType="util_dropdown", keys={"SSL", "TLS", "TLSv1", "TLSv1.1", "TLSv1.2", "PLAIN"}, values={"SSL", "TLS", "TLS v1.0", "TLS v1.1", "TLS v1.2", "PLAIN"}) Var ssl) {
        try {
            boolean isTLS = ssl.getObjectAsString().startsWith("TLS") || ssl.getObjectAsString().equals("false");
            HtmlEmail email = new HtmlEmail();
            log.info("SMTP: Setting up e-mail parameters");
            email.setCharset(CronapiConfigurator.ENCODING);
            if (ssl.getObjectAsString().equals("SSL") || ssl.getObjectAsBoolean().booleanValue()) {
                email.setSSLOnConnect(true);
                email.setSslSmtpPort(smtpPort.getObjectAsString());
            } else if (isTLS) {
                email.setStartTLSRequired(true);
                email.setSSLOnConnect(false);
                email.setSmtpPort(smtpPort.getObjectAsInt().intValue());
            } else if (ssl.getObjectAsString().equals("PLAIN")) {
                email.setStartTLSRequired(false);
                email.setSSLOnConnect(false);
                email.setSmtpPort(smtpPort.getObjectAsInt().intValue());
            }
            email.setHostName(smtpHost.getObjectAsString());
            email.setAuthenticator((Authenticator)new DefaultAuthenticator(login.getObjectAsString(), password.getObjectAsString()));
            email.setFrom(from.getObjectAsString());
            email.setDebug(false);
            email.setSubject(subject.getObjectAsString());
            email.setMsg(msg.getObjectAsString());
            if (Cc.getType() == Var.Type.LIST) {
                for (Object v : Cc.getObjectAsList()) {
                    email.addCc(Var.valueOf(v).getObjectAsString());
                }
            } else if (!Cc.equals(Var.VAR_NULL)) {
                email.addCc(Cc.getObjectAsString());
            }
            if (Bcc.getType() == Var.Type.LIST) {
                for (Object v : Bcc.getObjectAsList()) {
                    email.addBcc(Var.valueOf(v).getObjectAsString());
                }
            } else if (!Bcc.equals(Var.VAR_NULL)) {
                email.addBcc(Bcc.getObjectAsString());
            }
            if (!html.equals(Var.VAR_NULL)) {
                email.setHtmlMsg(html.getObjectAsString());
            }
            if (!attachments.equals(Var.VAR_NULL)) {
                if (attachments.getType() == Var.Type.LIST) {
                    for (Object v : attachments.getObjectAsList()) {
                        FileDataSource fileSource = new FileDataSource(Var.valueOf(v).getObjectAsString().trim());
                        EmailAttachment anexo = new EmailAttachment();
                        anexo.setPath(Var.valueOf(v).getObjectAsString());
                        anexo.setDisposition("attachment");
                        anexo.setName(Var.valueOf(fileSource.getName()).getObjectAsString());
                        email.attach(anexo);
                    }
                } else if (attachments.getType() == Var.Type.STRING) {
                    FileDataSource fileSource = new FileDataSource(Var.valueOf(attachments).getObjectAsString().trim());
                    EmailAttachment anexo = new EmailAttachment();
                    anexo.setPath(attachments.getObjectAsString());
                    anexo.setDisposition("attachment");
                    anexo.setName(fileSource.getName());
                    email.attach(anexo);
                }
            }
            if (to.getType() == Var.Type.LIST) {
                for (Object v : to.getObjectAsList()) {
                    email.addTo(Var.valueOf(v).getObjectAsString());
                }
            } else if (to.getType() == Var.Type.STRING) {
                email.addTo(to.getObjectAsString());
            }
            log.info("SMTP: Starts sending email");
            Session session = email.getMailSession();
            Properties props = session.getProperties();
            props.remove("mail.smtp.ssl.protocols");
            if (isTLS) {
                switch (ssl.getObjectAsString()) {
                    case "TLSv1": {
                        props.setProperty("mail.smtp.ssl.protocols", "TLSv1");
                        break;
                    }
                    case "TLSv1.1": {
                        props.setProperty("mail.smtp.ssl.protocols", "TLSv1.1");
                        break;
                    }
                    case "TLSv1.2": {
                        props.setProperty("mail.smtp.ssl.protocols", "TLSv1.2");
                    }
                }
            }
            email.send();
            log.info("SMTP: Email sent");
        }
        catch (EmailException e) {
            log.error("SMTP: Fail on sending email. " + e.getMessage());
            throw new RuntimeException(e);
        }
    }
}

