/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.authentication.social.linkedin;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import cronapi.CronapiConfigurator;
import cronapi.ErrorResponse;
import cronapp.framework.authentication.normal.AuthenticationConfigurer;
import cronapp.framework.authentication.social.SocialConfig;
import cronapp.framework.authentication.social.linkedin.LinkedinAccessTokenTemplate;
import cronapp.framework.authentication.social.linkedin.LinkedinProfileTemplate;
import cronapp.framework.authentication.token.AuthenticationController;
import cronapp.framework.authentication.token.AuthenticationResponse;
import cronapp.framework.i18n.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mobile.device.LiteDeviceResolver;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/signin/linkedin"})
public class LinkedinSignInController {
    private static final Logger logger = LoggerFactory.getLogger(LinkedinSignInController.class);
    private static final String LINKEDIN_OAUTH2_URL = "https://www.linkedin.com/oauth/v2/authorization";
    private static final String LINKEDIN_EXCHANGE_URL = "https://www.linkedin.com/oauth/v2/accessToken";
    private static final String LINKEDIN_PROFILE_URL = "https://api.linkedin.com/v2/me";
    private static final String LINKEDIN_EMAIL_ADDRESS_URL = "https://api.linkedin.com/v2/emailAddress?q=members&projection=(elements*(handle~))";
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private HttpServletResponse response;
    @Autowired(required=false)
    private AuthenticationConfigurer authenticationConfigurer;
    @Autowired(required=false)
    private AuthenticationController authenticationController;

    @ExceptionHandler(value={Throwable.class})
    @ResponseBody
    public void handleControllerException(HttpServletRequest req, Throwable ex) throws IOException {
        logger.error("Linkedin Authentication Error", ex);
        ErrorResponse errorResponse = new ErrorResponse(HttpStatus.INTERNAL_SERVER_ERROR.value(), ex, req.getMethod());
        this.response.sendRedirect(this.request.getRequestURL().toString() + "/#/notconnected");
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(method={RequestMethod.POST})
    public void post(@RequestParam(name="scope", required=false) String scope) throws Exception {
        if (!SocialConfig.isEnabled("linkedin")) {
            logger.error("Login via Linkedin is disabled on your social config.");
            throw new Exception(Messages.getString("notAllowed"));
        }
        String clientId = SocialConfig.getProperties().getProperty("linkedin.appId");
        String redirectUri = URLEncoder.encode(this.request.getRequestURL().toString(), CronapiConfigurator.ENCODING);
        String linkedinScope = "r_liteprofile%20r_emailaddress";
        this.response.sendRedirect("https://www.linkedin.com/oauth/v2/authorization?response_type=code&client_id=" + clientId + "&redirect_uri=" + redirectUri + "&scope=" + linkedinScope);
    }

    @ResponseStatus(value=HttpStatus.OK)
    @RequestMapping(method={RequestMethod.GET})
    public void get(@RequestParam(name="code", required=false) String code, @RequestParam(name="state", required=false) String state, @RequestParam(name="error", required=false) String error, @RequestParam(name="error_description", required=false) String errorDescription) throws Exception {
        if (!SocialConfig.isEnabled("linkedin")) {
            logger.error("Login via Linkedin is disabled on your social config.");
            throw new Exception(Messages.getString("notAllowed"));
        }
        if (!StringUtils.isBlank((CharSequence)error) || !StringUtils.isBlank((CharSequence)errorDescription)) {
            throw new Exception("An error has occurred: \n" + error + "\n" + errorDescription);
        }
        LinkedinAccessTokenTemplate accessCode = this.getLinkedinAccessToken(code);
        LinkedinProfileTemplate profile = this.getLinkedinProfile(accessCode.getAccessToken());
        JsonObject details = new JsonObject();
        details.addProperty("name", (profile.getFirstName() + " " + profile.getLastName()).trim());
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)profile.getEmailAddress(), (Object)"cronapp", Arrays.asList(new SimpleGrantedAuthority("#OAUTH#")));
        auth.setDetails((Object)details);
        String redirect = this.request.getContextPath() + "/#/connected";
        if (this.authenticationConfigurer != null) {
            Authentication socialAuth = this.authenticationConfigurer.authenticate((Authentication)auth);
            SecurityContextHolder.getContext().setAuthentication(socialAuth);
            try {
                this.request.getSession().setAttribute("#OAUTH#USER", (Object)profile.getEmailAddress());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            LiteDeviceResolver deviceResolver = new LiteDeviceResolver();
            ResponseEntity<AuthenticationResponse> authenticationRequest = this.authenticationController.auth(profile.getEmailAddress(), "cronapp", deviceResolver.resolveDevice(this.request), "cronapp", null, (JsonObject)new Gson().toJsonTree((Object)profile), this.request, this.response);
            redirect = this.request.getContextPath() + "/#/connected?_ctk=" + ((AuthenticationResponse)authenticationRequest.getBody()).getToken();
        }
        this.response.sendRedirect(redirect);
    }

    private LinkedinAccessTokenTemplate getLinkedinAccessToken(String authorizationCode) throws Exception {
        String clientId = SocialConfig.getProperties().getProperty("linkedin.appId");
        String clientSecret = SocialConfig.getProperties().getProperty("linkedin.appSecret");
        String redirectUri = URLEncoder.encode(this.request.getRequestURL().toString(), CronapiConfigurator.ENCODING);
        String requestUrl = "https://www.linkedin.com/oauth/v2/accessToken?grant_type=authorization_code&code=" + authorizationCode + "&redirect_uri=" + redirectUri + "&client_id=" + clientId + "&client_secret=" + clientSecret;
        HttpPost httpPost = new HttpPost(requestUrl);
        CloseableHttpClient httpClient = HttpClients.createSystem();
        CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
        String result = IOUtils.toString((InputStream)response.getEntity().getContent(), (String)"UTF-8");
        logger.info("getLinkedinAccessToken: " + result);
        LinkedinAccessTokenTemplate linkedinAccessToken = (LinkedinAccessTokenTemplate)new ObjectMapper().readValue(result, LinkedinAccessTokenTemplate.class);
        return linkedinAccessToken;
    }

    private LinkedinProfileTemplate getLinkedinProfile(String accessToken) throws Exception {
        HttpGet httpGet = new HttpGet(LINKEDIN_PROFILE_URL);
        CloseableHttpClient httpClient = HttpClients.createSystem();
        httpGet.addHeader("Authorization", "Bearer " + accessToken);
        httpGet.addHeader("Connection", "Keep-Alive");
        CloseableHttpResponse responseProfile = httpClient.execute((HttpUriRequest)httpGet);
        String result = IOUtils.toString((InputStream)responseProfile.getEntity().getContent(), (String)"UTF-8");
        logger.info("getLinkedinProfile: " + result);
        LinkedinProfileTemplate profile = (LinkedinProfileTemplate)new ObjectMapper().readValue(result, LinkedinProfileTemplate.class);
        httpGet.setURI(new URI(LINKEDIN_EMAIL_ADDRESS_URL));
        CloseableHttpResponse responseEmail = httpClient.execute((HttpUriRequest)httpGet);
        String resultEmail = IOUtils.toString((InputStream)responseEmail.getEntity().getContent(), (String)"UTF-8");
        logger.info("getLinkedinProfileEmail: " + resultEmail);
        LinkedinProfileTemplate tmpProfile = (LinkedinProfileTemplate)new ObjectMapper().readValue(resultEmail, LinkedinProfileTemplate.class);
        profile.setEmailAddress(tmpProfile.getEmailAddress());
        return profile;
    }
}

