/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.api;

import com.google.gson.JsonObject;
import cronapi.AppConfig;
import cronapi.Var;
import cronapi.database.DataSource;
import cronapi.database.DatabaseQueryManager;
import cronapi.util.LRUCache;
import cronapi.util.Operations;
import cronapp.framework.api.Device;
import cronapp.framework.api.EventsManager;
import cronapp.framework.api.User;
import cronapp.framework.security.CronappUserDetails;
import java.text.Normalizer;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

public final class ApiManager
extends cronapi.ApiManager {
    public static final String SECURABLE_ATTRIBUTE_NAME = "name";
    public static final String SECURABLE_ATTRIBUTE_PATTERN = "pattern";
    public static final String SECURABLE_ATTRIBUTE_TYPE = "type";
    public static final String SECURABLE_TYPE_VIEW = "view";
    private static final Logger logger = LoggerFactory.getLogger(ApiManager.class);
    private static boolean OLD_AUTHORIZATION;
    private final String username;
    private final String password;
    private final String type;
    private final boolean autoSignUp;
    private static final LRUCache<String, Collection<Var>> SECURABLE_CACHE;
    private static final LRUCache<String, LinkedHashSet<String>> SECURABLE_USER_CACHE;
    private final PasswordEncoder passwordEncoder = new BCryptPasswordEncoder();
    private Boolean passwordMatches = false;
    private JsonObject details;

    private ApiManager(String username, String password, String type, boolean autoSignUp, JsonObject details) {
        this.username = ApiManager.normalize(username);
        this.password = password;
        this.type = type == null ? "local" : type;
        this.autoSignUp = autoSignUp;
        this.details = details;
        try {
            DatabaseQueryManager authManager = new DatabaseQueryManager("auth");
            this.passwordMatches = !EventsManager.hasEvent("onAuthenticate") && authManager.isDatabase();
        }
        catch (Exception e) {
            logger.error("It was not possible to authenticate.", (Throwable)e);
        }
    }

    public static ApiManager byUser(String username) {
        return new ApiManager(username, null, "local", false, null);
    }

    public static ApiManager byUserAndPassword(String username, String password, String type, boolean autoSignUp, JsonObject details) {
        return new ApiManager(username, password, type, autoSignUp, details);
    }

    public static ApiManager byUserAndPassword(String username, String password) {
        return new ApiManager(username, password, "local", false, null);
    }

    public static Collection<Var> getUserSecurables(String username) {
        LinkedHashSet<Var> listSecurables = (LinkedHashSet<Var>)SECURABLE_CACHE.get((Object)("user-" + username));
        if (listSecurables != null) {
            return listSecurables;
        }
        listSecurables = new LinkedHashSet<Var>();
        username = ApiManager.normalize(username);
        try {
            if (EventsManager.hasEvent("onGetUserSecurables")) {
                Var securableResult = EventsManager.executeEventOnTransaction("onGetUserSecurables", Var.valueOf((String)"username", (Object)username));
                if (securableResult.getType() != Var.Type.NULL) {
                    if (securableResult.getType() != Var.Type.LIST && !(securableResult.getObject() instanceof DataSource)) {
                        listSecurables.add(securableResult);
                    } else {
                        for (Object securable : securableResult.getObjectAsList()) {
                            listSecurables.add(Var.valueOf(securable));
                        }
                    }
                }
            } else if (!OLD_AUTHORIZATION) {
                DatabaseQueryManager securableManager = new DatabaseQueryManager("userSecurables");
                Var securableResult = securableManager.get(new Object[]{username});
                if (securableManager.isDatabase()) {
                    if (securableResult.size() > 0) {
                        Var securableObject = securableResult.get(0);
                        if (securableObject.isNative()) {
                            for (Object userSecurable : securableResult.getObjectAsList()) {
                                listSecurables.add(Var.valueOf(userSecurable));
                            }
                        } else {
                            List userSecurables = securableResult.getObjectAsList();
                            for (Object userSecurable : userSecurables) {
                                listSecurables.add(Var.valueOf(userSecurable));
                            }
                        }
                    }
                } else if (securableResult.getType() != Var.Type.NULL) {
                    if (securableResult.getType() != Var.Type.LIST) {
                        listSecurables.add(securableResult);
                    } else {
                        for (Object securable : securableResult.getObjectAsList()) {
                            listSecurables.add(Var.valueOf(securable));
                        }
                    }
                }
            }
            if (!listSecurables.isEmpty()) {
                SECURABLE_CACHE.put((Object)("user-" + username), listSecurables);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return listSecurables;
    }

    public static Collection<Var> getAuthenticatedSecurables() {
        return ApiManager.getRoleSecurables("authenticated users");
    }

    public static Collection<Var> getSecurables(String name) {
        LinkedHashSet<Var> listSecurables = new LinkedHashSet<Var>();
        try {
            if (EventsManager.hasEvent("onGetSecurables")) {
                Var securableResult = EventsManager.executeEventOnTransaction("onGetSecurables", Var.valueOf((String)"username", (Object)name));
                if (securableResult.getType() != Var.Type.NULL) {
                    if (securableResult.getType() != Var.Type.LIST && !(securableResult.getObject() instanceof DataSource)) {
                        listSecurables.add(securableResult);
                    } else {
                        for (Object securable : securableResult.getObjectAsList()) {
                            listSecurables.add(Var.valueOf(securable));
                        }
                    }
                }
            } else {
                DatabaseQueryManager securableManager = new DatabaseQueryManager("securables");
                Var securableResult = securableManager.get(new Object[]{name});
                if (securableManager.isDatabase()) {
                    if (securableResult.size() > 0) {
                        Var securableObject = securableResult.get(0);
                        if (securableObject.isNative()) {
                            for (Object userSecurable : securableResult.getObjectAsList()) {
                                listSecurables.add(Var.valueOf(userSecurable));
                            }
                        } else {
                            List userSecurables = securableResult.getObjectAsList();
                            for (Object userSecurable : userSecurables) {
                                listSecurables.add(Var.valueOf(userSecurable));
                            }
                        }
                    }
                } else if (securableResult.getType() != Var.Type.NULL) {
                    if (securableResult.getType() != Var.Type.LIST) {
                        listSecurables.add(securableResult);
                    } else {
                        for (Object securable : securableResult.getObjectAsList()) {
                            listSecurables.add(Var.valueOf(securable));
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return listSecurables;
    }

    public static Var getUserFromProvider(String providerName, String providerKey) {
        DatabaseQueryManager loginFromProvider = new DatabaseQueryManager("userProviderKey");
        Var user = null;
        try {
            Var providerResult = loginFromProvider.get(new Object[]{providerName, providerKey});
            if (providerResult != null && providerResult.size() > 0) {
                Var providerObject = providerResult.get(0);
                user = providerObject.getField("user");
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return user;
    }

    public static Collection<Var> getSecurableViews(String name) {
        LinkedHashSet<Var> listSecurables = (LinkedHashSet<Var>)SECURABLE_CACHE.get((Object)("view-" + name));
        if (listSecurables != null) {
            return listSecurables;
        }
        listSecurables = new LinkedHashSet<Var>();
        try {
            if (EventsManager.hasEvent("onGetSecurableViews")) {
                Var securableResult = EventsManager.executeEventOnTransaction("onGetSecurableViews", Var.valueOf((String)"securableName", (Object)name));
                if (securableResult.getType() != Var.Type.NULL) {
                    if (securableResult.getType() != Var.Type.LIST && !(securableResult.getObject() instanceof DataSource)) {
                        listSecurables.add(securableResult);
                    } else {
                        for (Object securable : securableResult.getObjectAsList()) {
                            listSecurables.add(Var.valueOf(securable));
                        }
                    }
                }
            } else {
                DatabaseQueryManager securableManager = new DatabaseQueryManager("securableViews");
                Var securableResult = securableManager.get(new Object[]{name});
                if (securableManager.isDatabase()) {
                    if (securableResult.size() > 0) {
                        Var securableObject = securableResult.get(0);
                        if (securableObject.isNative()) {
                            for (Object userSecurable : securableResult.getObjectAsList()) {
                                listSecurables.add(Var.valueOf(userSecurable));
                            }
                        } else {
                            List userSecurables = securableResult.getObjectAsList();
                            for (Object userSecurable : userSecurables) {
                                listSecurables.add(Var.valueOf(userSecurable));
                            }
                        }
                    }
                } else if (securableResult.getType() != Var.Type.NULL) {
                    if (securableResult.getType() != Var.Type.LIST) {
                        listSecurables.add(securableResult);
                    } else {
                        for (Object securable : securableResult.getObjectAsList()) {
                            listSecurables.add(Var.valueOf(securable));
                        }
                    }
                }
            }
            if (!listSecurables.isEmpty()) {
                SECURABLE_CACHE.put((Object)("view-" + name), listSecurables);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return listSecurables;
    }

    public static List<GrantedAuthority> getPublicAuthorities() {
        return ApiManager.getPublicSecurables().stream().map(securable -> securable.getStringField(SECURABLE_ATTRIBUTE_NAME)).map(SimpleGrantedAuthority::new).collect(Collectors.toList());
    }

    public static Collection<Var> getPublicSecurables() {
        return ApiManager.getRoleSecurables("anonymous users");
    }

    public static Collection<Var> getRoleSecurables(String rolename) {
        LinkedHashSet<Var> listSecurables = (LinkedHashSet<Var>)SECURABLE_CACHE.get((Object)("role-" + (rolename = ApiManager.normalize(rolename))));
        if (listSecurables != null) {
            return listSecurables;
        }
        listSecurables = new LinkedHashSet<Var>();
        try {
            if (EventsManager.hasEvent("onGetRoleSecurables")) {
                Var securableResult = EventsManager.executeEventOnTransaction("onGetRoleSecurables", Var.valueOf((String)"rolename", (Object)rolename));
                if (securableResult.getType() != Var.Type.NULL) {
                    if (securableResult.getType() != Var.Type.LIST && !(securableResult.getObject() instanceof DataSource)) {
                        listSecurables.add(securableResult);
                    } else {
                        for (Object securable : securableResult.getObjectAsList()) {
                            listSecurables.add(Var.valueOf(securable));
                        }
                    }
                }
            } else if (!OLD_AUTHORIZATION) {
                DatabaseQueryManager securableManager = new DatabaseQueryManager("roleSecurables");
                Var securableResult = securableManager.get(new Object[]{rolename});
                if (securableManager.isDatabase()) {
                    if (securableResult.size() > 0) {
                        Var securableObject = securableResult.get(0);
                        if (securableObject.isNative()) {
                            for (Object userSecurable : securableResult.getObjectAsList()) {
                                listSecurables.add(Var.valueOf(userSecurable));
                            }
                        } else {
                            List userSecurables = securableResult.getObjectAsList();
                            for (Object userSecurable : userSecurables) {
                                listSecurables.add(Var.valueOf(userSecurable));
                            }
                        }
                    }
                } else if (securableResult.getType() != Var.Type.NULL) {
                    if (securableResult.getType() != Var.Type.LIST) {
                        listSecurables.add(securableResult);
                    } else {
                        for (Object securable : securableResult.getObjectAsList()) {
                            listSecurables.add(Var.valueOf(securable));
                        }
                    }
                }
            }
            if (!listSecurables.isEmpty()) {
                SECURABLE_CACHE.put((Object)("role-" + rolename), listSecurables);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage());
        }
        return listSecurables;
    }

    public static String normalize(String s) {
        if (StringUtils.isEmpty((CharSequence)s)) {
            return "";
        }
        if (OLD_AUTHORIZATION) {
            return s;
        }
        return Normalizer.normalize(s, Normalizer.Form.NFD).replaceAll("[^\\p{ASCII}]", "").toLowerCase().trim();
    }

    public static void updateDevice(Device device) {
        try {
            logger.info("Device logged in:  " + device.getId());
            DatabaseQueryManager deviceManager = new DatabaseQueryManager("device");
            Var deviceResult = deviceManager.get(new Object[]{device.getId()});
            if (deviceManager.isDatabase()) {
                if (deviceResult.size() > 0) {
                    Var deviceObject = deviceResult.get(0);
                    deviceObject.setField("token", (Object)device.getToken());
                    deviceObject.setField("appVersion", (Object)device.getAppVersion());
                    deviceObject.setField("platformVersion", (Object)device.getPlatformVersion());
                    deviceManager.update(deviceObject, new Object[0]);
                } else {
                    LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                    map.put("id", device.getId());
                    map.put("platform", device.getPlatform());
                    map.put("platformVersion", device.getPlatformVersion());
                    map.put("appName", device.getAppName());
                    map.put("appVersion", device.getAppVersion());
                    map.put("token", device.getToken());
                    map.put("model", device.getModel());
                    deviceManager.insert((Object)Var.valueOf(map), new Object[0]);
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public boolean passwordMatches(CharSequence rawPassword, String password) {
        if (rawPassword != null && !rawPassword.toString().startsWith("$2a$10$")) {
            if (this.passwordMatches.booleanValue()) {
                return this.passwordEncoder.matches(rawPassword, password) || rawPassword.equals(password);
            }
            return true;
        }
        return false;
    }

    public User getUser() throws Exception {
        return this.getUser(null);
    }

    private Var getField(Var obj, String ... fields) {
        for (String field : fields) {
            Var value = obj.getField(field);
            if (value == null || value.getObject() == null || value.getObjectAsString().isEmpty()) continue;
            return value;
        }
        return Var.VAR_NULL;
    }

    public User getUser(CronappUserDetails userDetails) throws Exception {
        Var resultObject = this.getUserVar(userDetails);
        if (resultObject != null) {
            Var id = resultObject.getField("id");
            Var name = this.getField(resultObject, SECURABLE_ATTRIBUTE_NAME, "login", "username", "userName");
            Var username = this.getField(resultObject, "login", "username", "userName");
            Var password = resultObject.getField("password");
            Var theme = resultObject.getField("theme");
            Var picture = resultObject.getField("picture");
            Var lockoutEnabled = resultObject.getField("lockoutEnabled");
            Var lockoutEnd = resultObject.getField("lockoutEnd");
            Var accessFailedCount = resultObject.getField("accessFailedCount");
            Var email = resultObject.getField("email");
            return new User(id, name, username, password, theme, picture, lockoutEnabled, lockoutEnd, accessFailedCount, email);
        }
        return null;
    }

    public Var createUser(CronappUserDetails userDetails) {
        String userId;
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (userDetails == null) {
            map.put(SECURABLE_ATTRIBUTE_NAME, this.getDetail(SECURABLE_ATTRIBUTE_NAME, this.username));
            map.put("userName", this.getDetail("login", this.username));
            map.put("normalizedUserName", ApiManager.normalize(this.getDetail("login", this.username)));
            map.put("normalizedEmail", ApiManager.normalize(this.getDetail("email", this.username)));
            map.put("login", this.getDetail("login", this.username));
            map.put("email", this.getDetail("email", this.username));
            map.put("image", this.getDetail("image", null));
            map.put("picture", this.getDetail("image", null));
            map.put("password", UUID.randomUUID().toString());
            map.put("theme", this.getDetail("theme", ""));
        } else {
            map.put(SECURABLE_ATTRIBUTE_NAME, userDetails.getName());
            map.put("login", userDetails.getNormalizedUserName());
            map.put("email", userDetails.getEmail());
            map.put("password", UUID.randomUUID().toString());
            map.put("id", UUID.randomUUID());
            map.put("userName", userDetails.getUserName());
            map.put("normalizedUserName", userDetails.getNormalizedUserName());
            map.put("normalizedEmail", userDetails.getNormalizedEmail());
            map.put("emailConfirmed", userDetails.isEmailConfirmed());
            map.put("securityStamp", userDetails.getSecurityStamp());
            map.put("phoneNumber", userDetails.getPhoneNumber());
            map.put("phoneNumberConfirmed", userDetails.isPhoneNumberConfirmed());
            map.put("twoFactorEnabled", userDetails.isTwoFactorEnabled());
            map.put("lockoutEnd", userDetails.getLockoutEnd());
            map.put("lockoutEnabled", userDetails.isLockoutEnabled());
            map.put("accessFailedCount", userDetails.getAccessFailedCount());
            map.put("picture", this.getDetail("image", null));
        }
        Var userResult = Var.valueOf(map);
        DatabaseQueryManager authManager = new DatabaseQueryManager("auth");
        DatabaseQueryManager userManager = new DatabaseQueryManager("userManager");
        userManager.addFilter("normalizedUserName", "string", "equal", userResult.get("normalizedUserName").toString());
        Var userCheck = userManager.get(new Object[0]);
        if (userCheck.size() > 0) {
            userId = userCheck.get(0).get("id").toString();
        } else {
            Var userAdded = authManager.insert((Object)userResult, new Object[0]);
            userId = userAdded.get("id").toString();
        }
        DatabaseQueryManager applicationUser = DatabaseQueryManager.getInsanceBasedOnEntity((String)"app.entity.ApplicationUser");
        LinkedHashMap<String, String> appUser = new LinkedHashMap<String, String>();
        appUser.put("application", AppConfig.getApplicationId());
        appUser.put("user", userId);
        applicationUser.insert(appUser, new Object[0]);
        return userResult;
    }

    private Var getUserVar(CronappUserDetails userDetails) throws Exception {
        DatabaseQueryManager authManager = new DatabaseQueryManager("auth");
        Var userResult = authManager.get(new Object[]{Var.valueOf((String)"login", (Object)this.username)});
        if (userResult.getType() == Var.Type.LIST && userResult.size() == 0 && this.autoSignUp && !"local".equals(this.type)) {
            userResult = this.createUser(userDetails);
        }
        if (userResult.getType() == Var.Type.BOOLEAN) {
            if (userResult.getObjectAsBoolean().booleanValue()) {
                LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
                map.put("login", this.username);
                map.put("password", this.password);
                map.put("theme", "");
                return Var.valueOf(map);
            }
        } else {
            if (userResult.getType() == Var.Type.LIST && userResult.size() > 0) {
                return userResult.get(0);
            }
            if (userResult.getType() == Var.Type.LIST && userResult.size() == 0) {
                return null;
            }
            if (userResult.getType() != Var.Type.NULL) {
                return userResult;
            }
        }
        return null;
    }

    private String getDetail(String key, String defValue) {
        if (this.details != null && this.details.has(key) && this.details.get(key) != null && !this.details.get(key).isJsonNull() && StringUtils.isBlank((CharSequence)this.details.get(key).getAsString())) {
            return this.details.get(key).getAsString();
        }
        return defValue;
    }

    public Collection<String> getRoles() {
        LinkedHashSet<String> listRoles = (LinkedHashSet<String>)SECURABLE_USER_CACHE.get((Object)("listRoles-" + this.username));
        if (listRoles == null) {
            listRoles = new LinkedHashSet<String>();
            try {
                if (EventsManager.hasEvent("onGetRoles")) {
                    roleResult = EventsManager.executeEventOnTransaction("onGetRoles", Var.valueOf((String)"username", (Object)this.username));
                    if (roleResult.getType() != Var.Type.NULL) {
                        if (roleResult.getType() != Var.Type.LIST && !(roleResult.getObject() instanceof DataSource)) {
                            listRoles.add(roleResult.getObjectAsString());
                        } else {
                            for (Object role2 : roleResult.getObjectAsList()) {
                                listRoles.add(Var.valueOf(role2).getObjectAsString());
                            }
                        }
                    }
                } else {
                    DatabaseQueryManager roleManager = new DatabaseQueryManager("roles");
                    roleResult = roleManager.get(new Object[]{this.username});
                    if (roleManager.isDatabase()) {
                        if (roleResult.size() > 0) {
                            Var roleObject = roleResult.get(0);
                            if (roleObject.isNative()) {
                                for (Object userRole : roleResult.getObjectAsList()) {
                                    String roleString = Var.valueOf(userRole).getObjectAsString();
                                    listRoles.add(roleString);
                                }
                            } else {
                                List userRoles = roleResult.getObjectAsList();
                                for (Object userRole : userRoles) {
                                    Var roleVar = Var.valueOf(userRole).getField("role");
                                    Var roleName = roleVar.getField(SECURABLE_ATTRIBUTE_NAME);
                                    String roleString = roleName.getObjectAsString();
                                    listRoles.add(roleString);
                                }
                            }
                        }
                    } else if (roleResult.getType() != Var.Type.NULL) {
                        if (roleResult.getType() != Var.Type.LIST) {
                            listRoles.add(roleResult.getObjectAsString());
                        } else {
                            for (Object role3 : roleResult.getObjectAsList()) {
                                listRoles.add(Var.valueOf(role3).getObjectAsString());
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
            SECURABLE_USER_CACHE.put((Object)("listRoles-" + this.username), listRoles);
        }
        Collection allSecurables = listRoles.stream().flatMap(role -> ApiManager.getRoleSecurables(role).stream()).map(securable -> securable.getStringField(SECURABLE_ATTRIBUTE_NAME)).collect(Collectors.toList());
        allSecurables.addAll(ApiManager.getUserSecurables(this.username).stream().map(securable -> securable.getStringField(SECURABLE_ATTRIBUTE_NAME)).collect(Collectors.toList()));
        allSecurables.addAll(ApiManager.getAuthenticatedSecurables().stream().map(securable -> securable.getStringField(SECURABLE_ATTRIBUTE_NAME)).collect(Collectors.toList()));
        allSecurables.addAll(ApiManager.getPublicSecurables().stream().map(securable -> securable.getStringField(SECURABLE_ATTRIBUTE_NAME)).collect(Collectors.toList()));
        if (allSecurables.isEmpty()) {
            allSecurables.addAll(listRoles);
        }
        return new HashSet<String>(allSecurables);
    }

    public Set<GrantedAuthority> getAuthorities() {
        return this.getRoles().stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
    }

    public void updateTheme(String theme) throws Exception {
        Var userVar = this.getUserVar();
        if (userVar != null) {
            userVar.setField("theme", (Object)theme);
            try {
                DatabaseQueryManager authManager = new DatabaseQueryManager("auth");
                authManager.update(userVar, new Object[0]);
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    public static void lockUser(User user) {
        if (user != null && user.getLockoutEnabled().booleanValue()) {
            user.setLockoutEnd(DateUtils.addMinutes((Date)Date.from(Instant.now()), (int)AppConfig.getBlockTime()));
            try {
                DatabaseQueryManager authManager = new DatabaseQueryManager("auth");
                authManager.update(Var.valueOf((Object)user), new Object[0]);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static int getFailedAttempts(User user) {
        int failedAttempts = 0;
        if (user != null) {
            failedAttempts = user.getAccessFailedCount();
        }
        return failedAttempts;
    }

    public static boolean isUserLocked(User user) {
        if (user != null && user.getLockoutEnd() != null) {
            return user.getLockoutEnd().after(Date.from(Instant.now()));
        }
        return false;
    }

    public static void unlockUser(User user) {
        if (user != null && (user.getLockoutEnd() != null || user.getAccessFailedCount() > 0)) {
            user.setLockoutEnd(null);
            user.setAccessFailedCount(0);
            try {
                DatabaseQueryManager authManager = new DatabaseQueryManager("auth");
                authManager.update(Var.valueOf((Object)user), new Object[0]);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static void attemptFailed(User user) {
        try {
            if (user != null && user.getLockoutEnabled().booleanValue()) {
                int failedAttempts = user.getAccessFailedCount();
                user.setAccessFailedCount(failedAttempts + 1);
                DatabaseQueryManager authManager = new DatabaseQueryManager("auth");
                authManager.update(Var.valueOf((Object)user), new Object[0]);
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private Var getUserVar() throws Exception {
        return this.getUserVar(null);
    }

    public void setProviderInfo(String providerName, String providerKey) throws Exception {
        Var userVar = this.getUserVar();
        if (userVar != null) {
            try {
                DatabaseQueryManager providerManager = new DatabaseQueryManager("userProviderKey");
                Var providerResult = providerManager.get(new Object[]{providerName, providerKey});
                if (providerManager.isDatabase()) {
                    if (providerResult.size() > 0) {
                        Var providerObject = providerResult.get(0);
                        if (providerObject.getField("providerKey").getObjectAsString().equals(providerKey)) {
                            return;
                        }
                        providerObject.setField("providerName", (Object)providerName);
                        providerObject.setField("providerKey", (Object)providerKey);
                        providerManager.insert((Object)providerObject, new Object[0]);
                    } else {
                        LinkedHashMap<String, Object> loginProviderObject = new LinkedHashMap<String, Object>();
                        loginProviderObject.put("id", UUID.randomUUID());
                        loginProviderObject.put("loginProvider", providerName);
                        loginProviderObject.put("providerDisplayName", providerName);
                        loginProviderObject.put("providerKey", providerKey);
                        loginProviderObject.put("user", userVar);
                        providerManager.insert((Object)Var.valueOf(loginProviderObject), new Object[0]);
                    }
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    public void updatePassword(String password) throws Exception {
        Var userVar = this.getUserVar();
        if (userVar != null) {
            userVar.setField("password", (Object)password);
            DatabaseQueryManager authManager = new DatabaseQueryManager("auth");
            authManager.update(userVar, new Object[0]);
        }
    }

    public static void createUser(Var fields) throws Exception {
        DatabaseQueryManager authManager = new DatabaseQueryManager("userManager");
        DatabaseQueryManager userAppManager = new DatabaseQueryManager("applicationUser");
        Var user = authManager.insert((Object)fields, new Object[0]);
        Var idUser = new Var(user.getObjectAsMap().get("id"));
        LinkedHashMap<String, String> mapUserApp = new LinkedHashMap<String, String>();
        mapUserApp.put("id", UUID.randomUUID().toString().toUpperCase());
        mapUserApp.put("application", (String)Operations.getApplicationId());
        mapUserApp.put("user", idUser.getObjectAsString());
        Var roleResult = Var.valueOf(mapUserApp);
        userAppManager.insert((Object)roleResult, new Object[0]);
    }

    static {
        SECURABLE_CACHE = new LRUCache(100, INTERVAL);
        SECURABLE_USER_CACHE = new LRUCache(100, INTERVAL);
        try {
            Class.forName("auth.permission.SecurityPermission");
            OLD_AUTHORIZATION = true;
        }
        catch (Throwable e) {
            OLD_AUTHORIZATION = false;
        }
    }
}

