/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.persistence;

import cronapp.framework.CronappFrameworkException;
import cronapp.framework.persistence.PasswordEncoder;
import cronapp.framework.persistence.ValidPassword;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorEventAdapter;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.sessions.DataRecord;

public class PasswordEncoderListener
extends DescriptorEventAdapter {
    public void aboutToInsert(DescriptorEvent event) {
        super.aboutToInsert(event);
        this.hashPassword(event);
    }

    public void aboutToUpdate(DescriptorEvent event) {
        super.aboutToUpdate(event);
        this.hashPassword(event);
    }

    private <T> T getProperty(Object bean, String name) {
        try {
            Object propertyvalue = PropertyUtils.getProperty((Object)bean, (String)name);
            return (T)propertyvalue;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new CronappFrameworkException(String.format("Error getting %s property value", name), e);
        }
    }

    private void hashPassword(DescriptorEvent event) {
        for (ValidPassword validPassword : (ValidPassword[])event.getObject().getClass().getAnnotationsByType(ValidPassword.class)) {
            this.hashPassword(event, validPassword.passwordProperty(), validPassword.passwordHistoryProperty());
        }
    }

    private DatabaseField getDatabaseField(DescriptorEvent event, String attributeName) {
        DatabaseMapping databaseMapping = event.getDescriptor().getMappingForAttributeName(attributeName);
        return databaseMapping == null ? null : databaseMapping.getField();
    }

    private void hashPassword(DescriptorEvent event, String passwordProperty, String passwordHistoryProperty) {
        String encodedPassword;
        Object sourceBean = event.getSource();
        Object originalBean = event.getOriginalObject();
        String sourcePassword = (String)this.getProperty(sourceBean, passwordProperty);
        String sourcePasswordHistory = (String)this.getProperty(sourceBean, passwordHistoryProperty);
        String originalPassword = (String)this.getProperty(originalBean, passwordProperty);
        String originalPasswordHistory = (String)this.getProperty(originalBean, passwordProperty);
        if (sourcePassword == null) {
            return;
        }
        DatabaseField passwordField = this.getDatabaseField(event, passwordProperty);
        DatabaseField passwordHistoryField = this.getDatabaseField(event, passwordHistoryProperty);
        String string = encodedPassword = PasswordEncoder.getPasswordEncoder().isEncoded(sourcePassword) ? sourcePassword : PasswordEncoder.getPasswordEncoder().encode(sourcePassword);
        Object encodedPasswordHistory = sourcePasswordHistory != null && sourcePasswordHistory.contains(encodedPassword) ? sourcePasswordHistory : (StringUtils.isBlank((CharSequence)sourcePasswordHistory) ? encodedPassword : encodedPassword + "," + sourcePasswordHistory);
        DataRecord record = event.getRecord();
        if (passwordField != null) {
            if (StringUtils.equals((CharSequence)originalPassword, (CharSequence)encodedPassword)) {
                record.remove((Object)passwordField);
            } else {
                record.put((Object)passwordField, (Object)encodedPassword);
            }
        }
        if (passwordHistoryField != null) {
            if (StringUtils.equals((CharSequence)originalPasswordHistory, (CharSequence)encodedPasswordHistory)) {
                record.remove((Object)passwordHistoryField);
            } else {
                String truncatedPasswordHistory = List.of(((String)encodedPasswordHistory).split(",")).stream().limit(3L).collect(Collectors.joining(","));
                record.put((Object)passwordHistoryField, (Object)truncatedPasswordHistory);
            }
        }
        AbstractSession rootSession = event.getSession().getRootSession(event.getQuery());
        Object primaryKey = event.getSession().getId(sourceBean);
        Class<?> beanClass = sourceBean.getClass();
        rootSession.getIdentityMapAccessor().invalidateObject(primaryKey, beanClass);
    }
}

