/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.security.ApiAuthenticationFailureHandler;
import cronapp.framework.security.ApiAuthenticationSuccessHandler;
import cronapp.framework.security.HttpSecurityCustomizer;
import lombok.Generated;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.security.authentication.dao.AbstractUserDetailsAuthenticationProvider;
import org.springframework.security.config.Customizer;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="cronapp.security.forms", name={"enabled"}, havingValue="true")
public class FormsConfiguration
implements BeanPostProcessor {
    private final ApiAuthenticationFailureHandler authenticationFailureHandler;
    private final ApiAuthenticationSuccessHandler authenticationSuccessHandler;

    @Bean
    public HttpSecurityCustomizer formsCustomizer() {
        return http -> http.formLogin(configurer -> {
            configurer.failureHandler((AuthenticationFailureHandler)this.authenticationFailureHandler);
            configurer.successHandler((AuthenticationSuccessHandler)this.authenticationSuccessHandler);
        }).rememberMe(Customizer.withDefaults());
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AbstractUserDetailsAuthenticationProvider) {
            AbstractUserDetailsAuthenticationProvider authenticationProvider = (AbstractUserDetailsAuthenticationProvider)bean;
            authenticationProvider.setHideUserNotFoundExceptions(false);
        }
        return bean;
    }

    @Generated
    public FormsConfiguration(ApiAuthenticationFailureHandler authenticationFailureHandler, ApiAuthenticationSuccessHandler authenticationSuccessHandler) {
        this.authenticationFailureHandler = authenticationFailureHandler;
        this.authenticationSuccessHandler = authenticationSuccessHandler;
    }
}

