/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cronapi.AppConfig;
import cronapi.RestClient;
import cronapi.Var;
import cronapi.database.DatabaseQueryManager;
import cronapi.database.HistoryListener;
import cronapi.database.TransactionManager;
import cronapp.framework.LockedUserException;
import java.util.Arrays;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationListener;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.event.AbstractAuthenticationEvent;
import org.springframework.security.authentication.event.AbstractAuthenticationFailureEvent;
import org.springframework.security.authentication.event.AuthenticationSuccessEvent;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;

@Component
public class SecurityAuditListener
implements ApplicationListener<AbstractAuthenticationEvent> {
    private static final String AUTHENTICATION_TYPE_SUCCESS = "Success";
    private static final String AUTHENTICATION_TYPE_FAIL = "Fail";
    private static final String AUTHENTICATION_COMMAND = "auth";
    private static final String AUTHENTICATION_PARAMETER_REASON = "Reason";
    private static final String AUTHENTICATION_PARAMETER_ROLES = "Roles";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public void onApplicationEvent(AbstractAuthenticationEvent event) {
        String username = event.getAuthentication().getName();
        if (event instanceof AuthenticationSuccessEvent) {
            AuthenticationSuccessEvent successEvent = (AuthenticationSuccessEvent)event;
            String roles = successEvent.getAuthentication().getAuthorities().stream().map(Object::toString).collect(Collectors.joining(","));
            this.doLogAuthOperation(AUTHENTICATION_TYPE_SUCCESS, username, Arrays.asList(AUTHENTICATION_PARAMETER_ROLES, roles));
        } else if (event instanceof AbstractAuthenticationFailureEvent) {
            AbstractAuthenticationFailureEvent failureEvent = (AbstractAuthenticationFailureEvent)event;
            if (failureEvent.getException() instanceof UsernameNotFoundException) {
                this.doLogAuthOperation(AUTHENTICATION_TYPE_FAIL, username, Arrays.asList(AUTHENTICATION_PARAMETER_REASON, "UserNotFound"));
            } else if (failureEvent.getException() instanceof BadCredentialsException) {
                this.doLogAuthOperation(AUTHENTICATION_TYPE_FAIL, username, Arrays.asList(AUTHENTICATION_PARAMETER_REASON, "UserOrPassordInvalids"));
            } else if (failureEvent.getException() instanceof LockedUserException) {
                this.doLogAuthOperation(AUTHENTICATION_TYPE_FAIL, username, Arrays.asList(AUTHENTICATION_PARAMETER_REASON, "UserLocked"));
            } else {
                this.doLogAuthOperation(AUTHENTICATION_TYPE_FAIL, username, Arrays.asList(AUTHENTICATION_PARAMETER_REASON, failureEvent.getException().getMessage()));
            }
        } else {
            this.logger.warn("Unknown event type: {}", (Object)event.getClass().getName());
        }
    }

    private void doLogAuthOperation(String type, String user, List<String> params) {
        try {
            DatabaseQueryManager logManager = HistoryListener.getAuditLogManager();
            if (logManager != null) {
                String className = logManager.getEntity();
                Class<?> c = Class.forName(className);
                TransactionManager.begin(c);
                JsonObject json = new JsonObject();
                JsonArray arrayParams = new JsonArray();
                json.add("parameters", (JsonElement)arrayParams);
                for (String p : params) {
                    arrayParams.add(p);
                }
                Var auditLog = new Var(new LinkedHashMap());
                auditLog.set("type", (Object)("app.authorization." + type));
                auditLog.set("command", (Object)AUTHENTICATION_COMMAND);
                auditLog.set("category", (Object)"Authorization");
                auditLog.set("date", (Object)new Date());
                auditLog.set("objectData", (Object)json.toString());
                auditLog.set("user", (Object)user);
                auditLog.set("host", (Object)RestClient.getRestClient().getHost());
                auditLog.set("agent", (Object)RestClient.getRestClient().getAgent());
                auditLog.set("server", (Object)HistoryListener.CURRENT_IP);
                auditLog.set("affectedFields", null);
                auditLog.set("application", (Object)AppConfig.guid());
                logManager.insert((Object)auditLog, new Object[0]);
                TransactionManager.commit(c);
            }
        }
        catch (Exception e) {
            this.logger.error("Error on logging: {}", (Object)e.getMessage());
        }
    }
}

