/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.core.CronappConfiguration;
import java.util.HashMap;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

@Configuration
@Order
@ConditionalOnProperty(prefix="cronapp.security.session", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class SessionPropertyHandler
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (CronappConfiguration.hasDatabase((Environment)applicationContext.getEnvironment())) {
            HashMap<String, String> properties = new HashMap<String, String>();
            properties.put("cronapp.security.session.enabled", "true");
            properties.put("spring.session.store-type", "jdbc");
            properties.put("spring.session.jdbc.initialize-schema", "always");
            MapPropertySource propertySource = new MapPropertySource(this.getClass().getName(), properties);
            applicationContext.getEnvironment().getPropertySources().addFirst((PropertySource)propertySource);
        }
    }
}

