/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.api;

import cronapi.Var;
import java.util.Date;

public final class User {
    private String id;
    private final String name;
    private final String username;
    private final String password;
    private final String theme;
    private String picture;
    private Boolean lockoutEnabled = false;
    private Date lockoutEnd;
    private Integer accessFailedCount = 0;
    private String email;

    public User(String id, String name, String username, String password, String theme, String picture, Boolean lockoutEnabled, Date lockoutEnd, Integer accessFailedCount) {
        this.id = id;
        this.username = username;
        this.password = password;
        this.theme = theme;
        this.name = name;
        this.picture = picture;
        this.lockoutEnabled = lockoutEnabled;
        this.lockoutEnd = lockoutEnd;
        this.accessFailedCount = accessFailedCount;
    }

    public User(String username) {
        this.name = username;
        this.username = username;
        this.password = "";
        this.theme = "";
    }

    public User(String name, String username) {
        this.name = name == null ? username : name;
        this.username = username;
        this.password = "";
        this.theme = "";
    }

    public User(Var id, Var name, Var username, Var password, Var theme, Var picture, Var lockoutEnabled, Var lockoutEnd, Var accessFailedCount, Var email) {
        this.id = id.getObjectAsString();
        this.name = name.getObjectAsString();
        this.username = username.getObjectAsString();
        this.password = password.getObjectAsString();
        this.theme = theme.getObjectAsString();
        this.picture = picture.getObjectAsString();
        this.lockoutEnabled = lockoutEnabled != null && lockoutEnabled.isNull() == false ? lockoutEnabled.getObjectAsBoolean() : null;
        this.lockoutEnd = lockoutEnd != null && lockoutEnd.isNull() == false ? lockoutEnd.getObjectAsDateTime().getTime() : null;
        this.accessFailedCount = accessFailedCount != null && accessFailedCount.isNull() == false ? accessFailedCount.getObjectAsInt() : 0;
        this.email = email.getObjectAsString();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTheme() {
        return this.theme;
    }

    public String getName() {
        return this.name;
    }

    public String getPicture() {
        return this.picture;
    }

    public void setPicture(String picture) {
        this.picture = picture;
    }

    public Boolean getLockoutEnabled() {
        return this.lockoutEnabled;
    }

    public void setLockoutEnabled(Boolean lockoutEnabled) {
        this.lockoutEnabled = lockoutEnabled;
    }

    public Date getLockoutEnd() {
        return this.lockoutEnd;
    }

    public void setLockoutEnd(Date lockoutEnd) {
        this.lockoutEnd = lockoutEnd;
    }

    public Integer getAccessFailedCount() {
        return this.accessFailedCount;
    }

    public void setAccessFailedCount(Integer accessFailedCount) {
        this.accessFailedCount = accessFailedCount;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        User user = (User)o;
        return this.username != null ? this.username.equals(user.username) : user.username == null;
    }

    public int hashCode() {
        return this.username != null ? this.username.hashCode() : 0;
    }

    public String toString() {
        return "User{username='" + this.username + "'}";
    }

    public User resetPassword() {
        return new User(this.id, this.name, this.username, null, this.theme, this.picture, this.lockoutEnabled, this.lockoutEnd, this.accessFailedCount);
    }
}

