/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapp.framework.api.ApiManager;
import cronapp.framework.api.User;
import cronapp.framework.i18n.Messages;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.log.LogMessage;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.LockedException;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.stereotype.Component;

@Component
public class ApiAuthenticationFailureHandler
implements AuthenticationFailureHandler {
    @Generated
    private static final Log log = LogFactory.getLog(ApiAuthenticationFailureHandler.class);
    private static final String USER_LOCKED = "UserLocked";
    private static final String USER_LOCKED_10_MIN = "UserLocked10Min";
    private static final String USER_OR_PASSWORD_INVALID = "UserOrPassordInvalids";
    private static final String AUTH_ERROR = "AuthError";

    public void onAuthenticationFailure(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (exception instanceof BadCredentialsException) {
            boolean userLocked = false;
            try {
                String username = request.getParameter("username");
                ApiManager apiManager = ApiManager.byUser(username);
                User apiManagerUser = apiManager.getUser();
                if (apiManagerUser != null) {
                    ApiManager.attemptFailed(apiManagerUser);
                    userLocked = ApiManager.isUserLocked(apiManagerUser);
                }
            }
            catch (Exception e) {
                log.error((Object)LogMessage.format((String)"Error updating the user failed attempts after authentication failure: %s", (Object)e.getMessage()), (Throwable)e);
            }
            if (userLocked) {
                response.sendError(401, Messages.getString(USER_LOCKED_10_MIN));
            } else {
                response.sendError(401, Messages.getString(USER_OR_PASSWORD_INVALID));
            }
        } else if (exception instanceof UsernameNotFoundException) {
            response.sendError(401, Messages.getString(USER_OR_PASSWORD_INVALID));
        } else if (exception instanceof LockedException) {
            response.sendError(401, Messages.getString(USER_LOCKED));
        } else {
            response.sendError(401, Messages.getString(AUTH_ERROR));
            log.error((Object)"Error trying to authenticate an user", (Throwable)exception);
        }
    }
}

