/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import cronapi.Var;
import cronapp.framework.api.EventsManager;
import cronapp.framework.security.ApiUserDetailsManager;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;

public class FormsAuthenticationProvider
extends DaoAuthenticationProvider {
    private final ApiUserDetailsManager userDetailsManager;

    public FormsAuthenticationProvider(ApiUserDetailsManager userDetailsManager) {
        this.userDetailsManager = userDetailsManager;
        this.setUserDetailsService((UserDetailsService)userDetailsManager);
        this.setPasswordEncoder((PasswordEncoder)new BCryptPasswordEncoder());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String providedPassword = (String)authentication.getCredentials();
        this.userDetailsManager.setCurrentPassword(providedPassword);
        try {
            if (EventsManager.hasEvent("onAuthenticate")) {
                String username = this.determineUsername(authentication);
                UserDetails user = this.retrieveUser(username, (UsernamePasswordAuthenticationToken)authentication);
                if (user == null) {
                    throw new BadCredentialsException("Bad credentials");
                }
                Var userResult = EventsManager.executeEventOnTransaction("onAuthenticate", Var.valueOf((String)"username", (Object)username), Var.valueOf((String)"password", (Object)providedPassword));
                if (userResult == null || userResult.isEmptyOrNull().booleanValue()) {
                    throw new BadCredentialsException("Bad credentials");
                }
                if (userResult.getType() == Var.Type.BOOLEAN && !userResult.getObjectAsBoolean().booleanValue()) {
                    throw new BadCredentialsException("Bad credentials");
                }
                Authentication authentication2 = this.createSuccessAuthentication(username, authentication, user);
                return authentication2;
            }
            Authentication authentication3 = super.authenticate(authentication);
            return authentication3;
        }
        finally {
            this.userDetailsManager.setCurrentPassword(null);
        }
    }

    private String determineUsername(Authentication authentication) {
        return authentication.getPrincipal() == null ? "NONE_PROVIDED" : authentication.getName();
    }
}

