/*
 * Decompiled with CFR 0.152.
 */
package cronapp.framework.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import cronapi.TokenUtils;
import cronapp.framework.security.JwtUserDetails;
import io.jsonwebtoken.Claims;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class JwtAuthenticationToken
extends AbstractAuthenticationToken {
    private String credentials;
    private JwtUserDetails principal;
    private final ObjectMapper objectMapper = new ObjectMapper();
    public static final String JWT_USER_DETAIL_KEY = "details";

    public JwtAuthenticationToken(String token) {
        super((Collection)TokenUtils.getAuthoritiesFromToken((String)token).stream().map(SimpleGrantedAuthority::new).collect(Collectors.toSet()));
        this.credentials = token;
        this.principal = this.normalizeUser(token);
    }

    private JwtUserDetails normalizeUser(String token) {
        Claims claims = TokenUtils.getClaimsFromToken((String)token);
        if (claims != null && claims.containsKey((Object)JWT_USER_DETAIL_KEY)) {
            try {
                Map map = (Map)new Gson().fromJson(claims.get((Object)JWT_USER_DETAIL_KEY).toString(), Map.class);
                return new JwtUserDetails(map.get("username").toString(), "", map.get("enabled").toString().equals("true"), map.get("accountNonExpired").toString().equals("true"), map.get("credentialsNonExpired").toString().equals("true"), map.get("accountNonLocked").toString().equals("true"), this.getAuthorities());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new JwtUserDetails(TokenUtils.getNameFromToken((String)token), this.getAuthorities());
    }

    public Object getCredentials() {
        return this.credentials;
    }

    public Object getPrincipal() {
        return this.principal;
    }
}

